/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.web;

import java.util.LinkedHashMap;
import java.util.Map;
import org.scijava.search.SearchResult;

public class WebSearchResult
implements SearchResult {
    private static final String DEFAULT_ICON = "/icons/search/world_link.png";
    private final String name;
    private final String iconPath;
    private final String url;
    private final Map<String, String> props;

    public WebSearchResult(String name, String url, String details) {
        this(name, url, details, null, null);
    }

    public WebSearchResult(String name, String url, String details, String iconPath, Map<String, String> extraProps) {
        this.name = name;
        this.url = url;
        this.iconPath = iconPath == null ? DEFAULT_ICON : iconPath;
        this.props = new LinkedHashMap<String, String>();
        this.props.put(null, details);
        this.props.put("URL", url);
        if (extraProps != null) {
            this.props.putAll(extraProps);
        }
    }

    public String url() {
        return this.url;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String iconPath() {
        return this.iconPath;
    }

    @Override
    public Map<String, String> properties() {
        return this.props;
    }
}

