/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BaseStorageWriteChannel;
import com.google.cloud.storage.BlobReadChannelV2;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.LazyWriteChannel;
import com.google.cloud.storage.ResumableMedia;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

final class BlobWriteChannelV2
extends BaseStorageWriteChannel<StorageObject> {
    private final BlobReadChannelV2.BlobReadChannelContext blobChannelContext;
    private final JsonResumableWrite start;

    BlobWriteChannelV2(BlobReadChannelV2.BlobReadChannelContext blobChannelContext, JsonResumableWrite start) {
        super(Conversions.json().blobInfo());
        this.start = start;
        this.blobChannelContext = blobChannelContext;
    }

    public synchronized RestorableState<WriteChannel> capture() {
        byte[] bufferSnapshot;
        BufferHandle handle = this.getBufferHandle();
        if (handle.position() > 0) {
            ByteBuffer byteBuffer = (ByteBuffer)handle.get();
            ByteBuffer dup = byteBuffer.duplicate();
            dup.flip();
            int remaining = dup.remaining();
            bufferSnapshot = new byte[remaining];
            dup.get(bufferSnapshot);
        } else {
            bufferSnapshot = new byte[]{};
        }
        return new BlobWriteChannelV2State(this.blobChannelContext.getStorageOptions(), this.start, this.getCommittedPosition(), this.isOpen(), this.getChunkSize(), bufferSnapshot);
    }

    @Override
    protected LazyWriteChannel<StorageObject> newLazyWriteChannel() {
        return new LazyWriteChannel<StorageObject>(() -> ResumableMedia.http().write().byteChannel(this.blobChannelContext.getHttpClientContext()).resumable().setCommittedBytesCallback(this::setCommittedPosition).withRetryConfig(this.blobChannelContext.getStorageOptions().asRetryDependencies(), this.blobChannelContext.getRetryAlgorithmManager().idempotent()).buffered(this.getBufferHandle()).setStartAsync((ApiFuture<JsonResumableWrite>)ApiFutures.immediateFuture((Object)this.start)).build());
    }

    static final class BlobWriteChannelV2State
    implements RestorableState<WriteChannel>,
    Serializable {
        private static final long serialVersionUID = -1901664719924133474L;
        private final HttpStorageOptions options;
        private final JsonResumableWrite resumableWrite;
        private final Long position;
        private final Boolean isOpen;
        private final Integer chunkSize;
        private final byte[] bufferSnapshot;

        BlobWriteChannelV2State(HttpStorageOptions options, JsonResumableWrite resumableWrite, Long position, Boolean isOpen, Integer chunkSize, byte[] bufferSnapshot) {
            this.options = options;
            this.resumableWrite = resumableWrite;
            this.position = position;
            this.isOpen = isOpen;
            this.chunkSize = chunkSize;
            this.bufferSnapshot = bufferSnapshot;
        }

        public WriteChannel restore() {
            JsonResumableWrite resumableWrite = this.resumableWrite;
            if (this.position != null) {
                resumableWrite = resumableWrite.withBeginOffset(this.position);
            }
            BlobWriteChannelV2 channel = new BlobWriteChannelV2(BlobReadChannelV2.BlobReadChannelContext.from(this.options), resumableWrite);
            if (this.chunkSize != null) {
                channel.setChunkSize(this.chunkSize);
            }
            if (this.bufferSnapshot != null && this.bufferSnapshot.length > 0) {
                BufferHandle handle = channel.getBufferHandle();
                ByteBuffer byteBuffer = (ByteBuffer)handle.get();
                byteBuffer.put(this.bufferSnapshot);
            }
            if (this.position != null) {
                channel.setCommittedPosition(this.position);
            }
            if (this.isOpen != null) {
                channel.setOpen(this.isOpen);
            }
            return channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobWriteChannelV2State)) {
                return false;
            }
            BlobWriteChannelV2State that = (BlobWriteChannelV2State)o;
            return Objects.equals((Object)this.options, (Object)that.options) && Objects.equals(this.resumableWrite, that.resumableWrite) && Objects.equals(this.position, that.position) && Objects.equals(this.isOpen, that.isOpen) && Objects.equals(this.chunkSize, that.chunkSize) && Arrays.equals(this.bufferSnapshot, that.bufferSnapshot);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.options, this.resumableWrite, this.position, this.isOpen, this.chunkSize});
            result = 31 * result + Arrays.hashCode(this.bufferSnapshot);
            return result;
        }
    }
}

