/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.ChannelSplitter;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.Filter;
import mpicbg.imagefeatures.FloatArray2D;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.imagefeatures.ImageArrayConverter;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;

public class SIFT_MultiChannel_Align
implements PlugIn,
KeyListener {
    private final List<Feature> fs1 = new ArrayList<Feature>();
    private final List<Feature> fs2 = new ArrayList<Feature>();
    static final Param p = new Param();

    private static final ImageProcessor downScale(ImageProcessor ip, double s) {
        FloatArray2D g = new FloatArray2D(ip.getWidth(), ip.getHeight());
        ImageArrayConverter.imageProcessorToFloatArray2D((ImageProcessor)ip, (FloatArray2D)g);
        float sigma = (float)Math.sqrt(0.0625 / s / s - 0.25);
        float[] kernel = Filter.createGaussianKernel((float)sigma, (boolean)true);
        FloatArray2D h = Filter.convolveSeparable((FloatArray2D)g, (float[])kernel, (float[])kernel);
        FloatProcessor fp = new FloatProcessor(ip.getWidth(), ip.getHeight());
        ImageArrayConverter.floatArray2DToFloatProcessor((FloatArray2D)h, (FloatProcessor)fp);
        return ip.resize((int)(s * (double)ip.getWidth()));
    }

    public final void run(String args) {
        TranslationModel2D model;
        this.fs1.clear();
        this.fs2.clear();
        if (IJ.versionLessThan((String)"1.41n")) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            System.err.println("There are no images open");
            return;
        }
        String img_title = imp.getTitle();
        GenericDialog gd = new GenericDialog("Align stack");
        gd.addMessage("Input:");
        gd.addNumericField("Registration_channel (on composite) :", (double)SIFT_MultiChannel_Align.p.regChannel, 0);
        gd.addMessage("Scale Invariant Interest Point Detector:");
        gd.addNumericField("initial_gaussian_blur :", (double)SIFT_MultiChannel_Align.p.sift.initialSigma, 2, 6, "px");
        gd.addNumericField("steps_per_scale_octave :", (double)SIFT_MultiChannel_Align.p.sift.steps, 0);
        gd.addNumericField("minimum_image_size :", (double)SIFT_MultiChannel_Align.p.sift.minOctaveSize, 0, 6, "px");
        gd.addNumericField("maximum_image_size :", (double)SIFT_MultiChannel_Align.p.sift.maxOctaveSize, 0, 6, "px");
        gd.addMessage("Feature Descriptor:");
        gd.addNumericField("feature_descriptor_size :", (double)SIFT_MultiChannel_Align.p.sift.fdSize, 0);
        gd.addNumericField("feature_descriptor_orientation_bins :", (double)SIFT_MultiChannel_Align.p.sift.fdBins, 0);
        gd.addNumericField("closest/next_closest_ratio :", (double)SIFT_MultiChannel_Align.p.rod, 2);
        gd.addMessage("Geometric Consensus Filter:");
        gd.addNumericField("maximal_alignment_error :", (double)SIFT_MultiChannel_Align.p.maxEpsilon, 2, 6, "px");
        gd.addNumericField("inlier_ratio :", (double)SIFT_MultiChannel_Align.p.minInlierRatio, 2);
        gd.addChoice("expected_transformation :", Param.modelStrings, Param.modelStrings[SIFT_MultiChannel_Align.p.modelIndex]);
        gd.addMessage("Output:");
        gd.addCheckbox("interpolate", SIFT_MultiChannel_Align.p.interpolate);
        gd.addCheckbox("show_info", SIFT_MultiChannel_Align.p.showInfo);
        gd.addCheckbox("show_transformation_matrix", SIFT_MultiChannel_Align.p.showMatrix);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        SIFT_MultiChannel_Align.p.regChannel = (int)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.sift.initialSigma = (float)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.sift.steps = (int)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.sift.minOctaveSize = (int)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.sift.maxOctaveSize = (int)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.sift.fdSize = (int)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.sift.fdBins = (int)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.rod = (float)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.maxEpsilon = (float)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.minInlierRatio = (float)gd.getNextNumber();
        SIFT_MultiChannel_Align.p.modelIndex = gd.getNextChoiceIndex();
        SIFT_MultiChannel_Align.p.interpolate = gd.getNextBoolean();
        SIFT_MultiChannel_Align.p.showInfo = gd.getNextBoolean();
        SIFT_MultiChannel_Align.p.showMatrix = gd.getNextBoolean();
        ImagePlus[] channels = imp.getBitDepth() == 24 ? new ImagePlus[]{imp} : ChannelSplitter.split((ImagePlus)imp);
        imp = channels[SIFT_MultiChannel_Align.p.regChannel - 1];
        ImageStack stack = imp.getStack();
        ImageStack[] stackAligned = new ImageStack[channels.length];
        for (int ch_i = 0; ch_i < channels.length; ++ch_i) {
            stackAligned[ch_i] = new ImageStack(stack.getWidth(), stack.getHeight());
        }
        float vis_scale = 256.0f / (float)imp.getWidth();
        ImageStack stackInfo = null;
        ImagePlus impInfo = null;
        if (SIFT_MultiChannel_Align.p.showInfo) {
            stackInfo = new ImageStack(Math.round(vis_scale * (float)stack.getWidth()), Math.round(vis_scale * (float)stack.getHeight()));
        }
        for (int ch_i = 0; ch_i < channels.length; ++ch_i) {
            ImageProcessor firstSlice = channels[ch_i].getStack().getProcessor(1);
            stackAligned[ch_i].addSlice(null, firstSlice.duplicate());
            stackAligned[ch_i].getProcessor(1).setMinAndMax(firstSlice.getMin(), firstSlice.getMax());
        }
        ImagePlus[] impAligned = new ImagePlus[channels.length];
        for (int ch_i = 0; ch_i < channels.length; ++ch_i) {
            impAligned[ch_i] = new ImagePlus("Aligned 1 of " + channels[ch_i].getStack().getSize(), stackAligned[ch_i]);
        }
        ImageProcessor ip2 = stack.getProcessor(1);
        ImageProcessor ip3 = null;
        ImageProcessor ip4 = null;
        FloatArray2DSIFT sift = new FloatArray2DSIFT(SIFT_MultiChannel_Align.p.sift);
        SIFT ijSIFT = new SIFT(sift);
        long start_time = System.currentTimeMillis();
        IJ.log((String)"Processing SIFT ...");
        ijSIFT.extractFeatures(ip2, this.fs2);
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        IJ.log((String)(this.fs2.size() + " features extracted."));
        if (SIFT_MultiChannel_Align.p.showInfo) {
            ip2 = SIFT_MultiChannel_Align.downScale(ip2, vis_scale);
        }
        switch (SIFT_MultiChannel_Align.p.modelIndex) {
            case 0: {
                model = new TranslationModel2D();
                break;
            }
            case 1: {
                model = new RigidModel2D();
                break;
            }
            case 2: {
                model = new SimilarityModel2D();
                break;
            }
            case 3: {
                model = new AffineModel2D();
                break;
            }
            default: {
                return;
            }
        }
        InverseTransformMapping mapping = new InverseTransformMapping((InverseCoordinateTransform)model);
        for (int i = 1; i < stack.getSize(); ++i) {
            boolean modelFound;
            TranslationModel2D currentModel;
            ImageProcessor ip1 = ip2;
            ip2 = stack.getProcessor(i + 1);
            this.fs1.clear();
            this.fs1.addAll(this.fs2);
            this.fs2.clear();
            start_time = System.currentTimeMillis();
            IJ.log((String)"Processing SIFT ...");
            ijSIFT.extractFeatures(ip2, this.fs2);
            IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
            IJ.log((String)(this.fs2.size() + " features extracted."));
            start_time = System.currentTimeMillis();
            System.out.print("identifying correspondences using brute force ...");
            Vector candidates = FloatArray2DSIFT.createMatches(this.fs2, this.fs1, (double)1.5, null, (double)3.4028234663852886E38, (double)SIFT_MultiChannel_Align.p.rod);
            System.out.println(" took " + (System.currentTimeMillis() - start_time) + "ms");
            IJ.log((String)(candidates.size() + " potentially corresponding features identified"));
            if (SIFT_MultiChannel_Align.p.showInfo) {
                ip2 = SIFT_MultiChannel_Align.downScale(ip2, vis_scale);
                ip3 = ip1.convertToRGB().duplicate();
                ip4 = ip2.convertToRGB().duplicate();
                ip3.setColor(Color.red);
                ip4.setColor(Color.red);
                ip3.setLineWidth(2);
                ip4.setLineWidth(2);
                for (PointMatch m : candidates) {
                    double[] m_p1 = m.getP1().getL();
                    double[] m_p2 = m.getP2().getL();
                    ip3.drawDot((int)Math.round((double)vis_scale * m_p2[0]), (int)Math.round((double)vis_scale * m_p2[1]));
                    ip4.drawDot((int)Math.round((double)vis_scale * m_p1[0]), (int)Math.round((double)vis_scale * m_p1[1]));
                }
            }
            Vector inliers = new Vector();
            switch (SIFT_MultiChannel_Align.p.modelIndex) {
                case 0: {
                    currentModel = new TranslationModel2D();
                    break;
                }
                case 1: {
                    currentModel = new RigidModel2D();
                    break;
                }
                case 2: {
                    currentModel = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    currentModel = new AffineModel2D();
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                modelFound = currentModel.filterRansac((List)candidates, inliers, 1000, (double)SIFT_MultiChannel_Align.p.maxEpsilon, (double)SIFT_MultiChannel_Align.p.minInlierRatio);
            }
            catch (Exception e) {
                modelFound = false;
                System.err.println(e.getMessage());
            }
            if (modelFound) {
                if (SIFT_MultiChannel_Align.p.showInfo) {
                    ip3.setColor(Color.green);
                    ip4.setColor(Color.green);
                    ip3.setLineWidth(2);
                    ip4.setLineWidth(2);
                    for (PointMatch m : inliers) {
                        double[] m_p1 = m.getP1().getL();
                        double[] m_p2 = m.getP2().getL();
                        ip3.drawDot((int)Math.round((double)vis_scale * m_p2[0]), (int)Math.round((double)vis_scale * m_p2[1]));
                        ip4.drawDot((int)Math.round((double)vis_scale * m_p1[0]), (int)Math.round((double)vis_scale * m_p1[1]));
                    }
                }
                model.concatenate((AbstractAffineModel2D)currentModel);
                if (SIFT_MultiChannel_Align.p.showMatrix) {
                    IJ.log((String)("Transformation Matrix: " + currentModel.createAffine()));
                }
            }
            for (int ch_i = 0; ch_i < channels.length; ++ch_i) {
                ImageProcessor originalSlice = channels[ch_i].getStack().getProcessor(i + 1);
                originalSlice.setInterpolationMethod(1);
                ImageProcessor alignedSlice = originalSlice.createProcessor(channels[ch_i].getStack().getWidth(), channels[ch_i].getStack().getHeight());
                alignedSlice.setMinAndMax(originalSlice.getMin(), originalSlice.getMax());
                if (SIFT_MultiChannel_Align.p.interpolate) {
                    mapping.mapInterpolated(originalSlice, alignedSlice);
                } else {
                    mapping.map(originalSlice, alignedSlice);
                }
                stackAligned[ch_i].addSlice(null, alignedSlice);
                if (SIFT_MultiChannel_Align.p.showInfo && ch_i == SIFT_MultiChannel_Align.p.regChannel - 1) {
                    ImageProcessor tmp = ip3.createProcessor(stackInfo.getWidth(), stackInfo.getHeight());
                    tmp.insert(ip3, 0, 0);
                    stackInfo.addSlice(null, tmp);
                    tmp = ip4.createProcessor(stackInfo.getWidth(), stackInfo.getHeight());
                    tmp.insert(ip4, 0, 0);
                    stackInfo.addSlice(null, tmp);
                    if (i == 1) {
                        impInfo = new ImagePlus("Alignment info", stackInfo);
                        impInfo.show();
                    }
                    impInfo.setStack("Alignment info", stackInfo);
                    int currentSlice = impInfo.getSlice();
                    impInfo.setSlice(stackInfo.getSize());
                    impInfo.setSlice(currentSlice);
                    impInfo.updateAndDraw();
                }
                impAligned[ch_i].setStack("Aligned " + stackAligned[ch_i].getSize() + " of " + stack.getSize(), stackAligned[ch_i]);
                int currentSlice = impAligned[ch_i].getSlice();
                impAligned[ch_i].setSlice(stack.getSize());
                impAligned[ch_i].setSlice(currentSlice);
                impAligned[ch_i].updateAndDraw();
            }
        }
        if (impAligned.length == 1) {
            impAligned[0].show();
            impAligned[0].setTitle("Aligned_" + img_title);
        } else {
            ImagePlus theFinalAlignedimp = RGBStackMerge.mergeChannels((ImagePlus[])impAligned, (boolean)false);
            theFinalAlignedimp.show();
            theFinalAlignedimp.setTitle("Aligned_" + img_title);
        }
        IJ.log((String)"Done.");
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 112 || e.getSource() instanceof TextField) {
            // empty if block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private static class Param {
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public int regChannel = 1;
        public float rod = 0.92f;
        public float maxEpsilon = 25.0f;
        public float minInlierRatio = 0.05f;
        public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine"};
        public int modelIndex = 1;
        public boolean interpolate = true;
        public boolean showInfo = false;
        public boolean showMatrix = false;

        private Param() {
        }
    }
}

