/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.ij.util.Util;
import mpicbg.models.Affine2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.MovingLeastSquaresTransform;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TransformMesh;
import mpicbg.models.TranslationModel2D;

public class Transform_Roi
implements PlugIn {
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    private static final String[] methods = new String[]{"Least Squares", "Moving Least Squares (non-linear)"};
    private static int methodIndex = 0;
    static float alpha = 1.0f;
    static int meshResolution = 32;
    private static final String[] modelClasses = new String[]{"Translation", "Rigid", "Similarity", "Affine", "Perspective"};
    private static int modelClassIndex = 1;
    private static boolean interpolate = true;
    private static boolean showMatrix = false;
    protected ImagePlus source;
    protected ImagePlus template;

    public Transform_Roi() {
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
    }

    protected static final void transform(CoordinateTransform transform, ImageProcessor source, ImageProcessor target) {
        for (int y = 0; y < target.getHeight(); ++y) {
            for (int x = 0; x < target.getWidth(); ++x) {
                double[] t = new double[]{x, y};
                transform.applyInPlace(t);
                target.putPixel(x, y, source.getPixel((int)t[0], (int)t[1]));
            }
        }
    }

    protected static final void transformInterpolated(CoordinateTransform transform, ImageProcessor source, ImageProcessor target) {
        for (int y = 0; y < target.getHeight(); ++y) {
            for (int x = 0; x < target.getWidth(); ++x) {
                double[] t = new double[]{x, y};
                transform.applyInPlace(t);
                target.putPixel(x, y, source.getPixelInterpolated(t[0], t[1]));
            }
        }
    }

    public final void run(String args) {
        InverseTransformMapping mapping;
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        if (!this.setup()) {
            return;
        }
        ImagePlus target = this.template.createImagePlus();
        ImageProcessor ipSource = this.source.getProcessor();
        ImageProcessor ipTarget = this.source.getProcessor().createProcessor(this.template.getWidth(), this.template.getHeight());
        ipTarget.setColor(Toolbar.getBackgroundColor());
        ipTarget.fill();
        ipTarget.setColor(Toolbar.getForegroundColor());
        List sourcePoints = Util.pointRoiToPoints((PointRoi)((PointRoi)this.source.getRoi()));
        List templatePoints = Util.pointRoiToPoints((PointRoi)((PointRoi)this.template.getRoi()));
        int numMatches = Math.min(sourcePoints.size(), templatePoints.size());
        for (int i = 0; i < numMatches; ++i) {
            matches.add(new PointMatch((Point)sourcePoints.get(i), (Point)templatePoints.get(i)));
        }
        if (methodIndex == 0) {
            TranslationModel2D ict;
            TranslationModel2D model;
            switch (modelClassIndex) {
                case 0: {
                    TranslationModel2D t;
                    model = t = new TranslationModel2D();
                    ict = t;
                    break;
                }
                case 1: {
                    RigidModel2D r = new RigidModel2D();
                    model = r;
                    ict = r;
                    break;
                }
                case 2: {
                    SimilarityModel2D s = new SimilarityModel2D();
                    model = s;
                    ict = s;
                    break;
                }
                case 3: {
                    AffineModel2D a = new AffineModel2D();
                    model = a;
                    ict = a;
                    break;
                }
                case 4: {
                    HomographyModel2D h = new HomographyModel2D();
                    model = h;
                    ict = h;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                model.fit(matches);
            }
            catch (NotEnoughDataPointsException e) {
                IJ.showMessage((String)"Not enough landmarks selected to find a transformation model.");
                return;
            }
            catch (IllDefinedDataPointsException e) {
                IJ.showMessage((String)"The set of landmarks is ill-defined in terms of the desired transformation.");
                return;
            }
            if (showMatrix) {
                double[] flatmatrix = new double[6];
                ((Affine2D)model).toArray(flatmatrix);
                IJ.log((String)("Matrix: " + Arrays.toString(flatmatrix)));
            }
            mapping = new InverseTransformMapping((InverseCoordinateTransform)ict);
        } else {
            MovingLeastSquaresTransform t = new MovingLeastSquaresTransform();
            try {
                switch (modelClassIndex) {
                    case 0: {
                        t.setModel(TranslationModel2D.class);
                        break;
                    }
                    case 1: {
                        t.setModel(RigidModel2D.class);
                        break;
                    }
                    case 2: {
                        t.setModel(SimilarityModel2D.class);
                        break;
                    }
                    case 3: {
                        t.setModel(AffineModel2D.class);
                        break;
                    }
                    case 4: {
                        IJ.error((String)"Perspective transformation is not yet supported for Moving Least Squares.  Using Affine instead.");
                        t.setModel(AffineModel2D.class);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception e) {
                return;
            }
            t.setAlpha((double)alpha);
            try {
                t.setMatches(matches);
                mapping = new TransformMeshMapping((TransformMesh)new CoordinateTransformMesh((CoordinateTransform)t, meshResolution, (double)this.source.getWidth(), (double)this.source.getHeight()));
            }
            catch (NotEnoughDataPointsException e) {
                IJ.showMessage((String)"Not enough landmarks selected to find a transformation model.");
                return;
            }
            catch (IllDefinedDataPointsException e) {
                IJ.showMessage((String)"The set of landmarks is ill-defined in terms of the desired transformation.");
                return;
            }
            if (showMatrix) {
                IJ.log((String)"Cannot show matrix for non-linear transformation");
            }
        }
        if (interpolate) {
            ipSource.setInterpolationMethod(1);
            mapping.mapInterpolated(ipSource, ipTarget);
        } else {
            mapping.map(ipSource, ipTarget);
        }
        target.setProcessor("Transformed" + this.source.getTitle(), ipTarget);
        target.show();
    }

    protected final boolean setup() {
        if (IJ.versionLessThan((String)"1.40c")) {
            return false;
        }
        int[] ids = WindowManager.getIDList();
        if (ids == null || ids.length < 2) {
            IJ.showMessage((String)"You should have at least two images open.");
            return false;
        }
        ArrayList<String> titlesList = new ArrayList<String>();
        ArrayList<Integer> idsList = new ArrayList<Integer>();
        String currentTitle = null;
        for (int i = 0; i < ids.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)ids[i]);
            Roi roi = imp.getRoi();
            if (roi == null || roi.getType() != 10) continue;
            titlesList.add(imp.getTitle());
            idsList.add(ids[i]);
            if (imp != WindowManager.getCurrentImage()) continue;
            currentTitle = imp.getTitle();
        }
        if (titlesList.size() < 2) {
            IJ.showMessage((String)"You should have at least two images with selected landmark correspondences open.");
            return false;
        }
        String[] titles = new String[titlesList.size()];
        titlesList.toArray(titles);
        if (currentTitle == null) {
            currentTitle = titles[0];
        }
        GenericDialog gd = new GenericDialog("Transform");
        gd.addChoice("source_image", titles, currentTitle);
        gd.addChoice("template_image", titles, currentTitle.equals(titles[0]) ? titles[1] : titles[0]);
        gd.addChoice("transformation_method", methods, methods[methodIndex]);
        gd.addNumericField("alpha", (double)alpha, 2);
        gd.addNumericField("mesh_resolution", (double)meshResolution, 0);
        gd.addChoice("transformation_class", modelClasses, modelClasses[modelClassIndex]);
        gd.addCheckbox("interpolate", interpolate);
        gd.addCheckbox("show_matrix", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.source = WindowManager.getImage((int)((Integer)idsList.get(gd.getNextChoiceIndex())));
        this.template = WindowManager.getImage((int)((Integer)idsList.get(gd.getNextChoiceIndex())));
        methodIndex = gd.getNextChoiceIndex();
        alpha = (float)gd.getNextNumber();
        meshResolution = (int)gd.getNextNumber();
        modelClassIndex = gd.getNextChoiceIndex();
        interpolate = gd.getNextBoolean();
        showMatrix = gd.getNextBoolean();
        return true;
    }
}

