/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.HashMap;

public class Overlay {
    private HashMap<Shape, OverlayShape> oshapes = null;

    public synchronized void add(Shape shape, Color color, Stroke stroke) {
        this.add(shape, color, stroke, false, false, 1.0f);
    }

    public synchronized void add(Shape shape, Color color, Stroke stroke, boolean as_XOR_color) {
        this.add(shape, color, stroke, false, as_XOR_color, 1.0f);
    }

    public synchronized void add(Shape shape, Color color, Stroke stroke, boolean fill, boolean as_XOR_color, float alpha) {
        if (null == shape) {
            return;
        }
        if (null == this.oshapes) {
            this.oshapes = new HashMap();
        }
        this.oshapes.put(shape, new OverlayShape(shape, color, stroke, fill, as_XOR_color, alpha));
    }

    public synchronized void remove(Shape shape) {
        if (null == this.oshapes || null == shape) {
            return;
        }
        this.oshapes.remove(shape);
    }

    public synchronized void clear() {
        this.oshapes = null;
    }

    public void paint(Graphics2D g, Rectangle srcRect, double mag) {
        if (null == this.oshapes) {
            return;
        }
        AffineTransform original = g.getTransform();
        g.setTransform(new AffineTransform());
        AffineTransform sm = new AffineTransform();
        sm.scale(mag, mag);
        sm.translate(-srcRect.x, -srcRect.y);
        g.setStroke(new BasicStroke(1.0f, 0, 0));
        for (OverlayShape o : this.oshapes.values()) {
            o.paint(g, sm);
        }
        g.setTransform(original);
    }

    private class OverlayShape {
        Shape shape;
        Color color;
        Stroke stroke;
        boolean fill;
        boolean as_XOR_color;
        float alpha;

        OverlayShape(Shape shape, Color color, Stroke stroke, boolean fill, boolean as_XOR_color, float alpha) {
            this.shape = shape;
            this.color = color;
            this.stroke = stroke;
            this.fill = fill;
            this.as_XOR_color = as_XOR_color;
            this.alpha = alpha;
        }

        void paint(Graphics2D g, AffineTransform sm) {
            Composite c = g.getComposite();
            if (this.as_XOR_color) {
                g.setXORMode(null == this.color ? Color.yellow : this.color);
            } else {
                g.setColor(null == this.color ? Color.yellow : this.color);
                if (this.alpha < 1.0f && this.alpha > 0.0f) {
                    g.setComposite(AlphaComposite.getInstance(3, this.alpha));
                }
            }
            Stroke s = null;
            if (null != this.stroke) {
                s = g.getStroke();
                g.setStroke(this.stroke);
            }
            if (this.fill) {
                g.fill(sm.createTransformedShape(this.shape));
            } else {
                g.draw(sm.createTransformedShape(this.shape));
            }
            if (null != this.stroke) {
                g.setStroke(s);
            }
            if (null != c) {
                g.setComposite(c);
            }
        }
    }
}

