/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.tree.TitledThing;
import ini.trakem2.utils.Utils;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public final class LayerThing
extends DBObject
implements TitledThing {
    private TemplateThing template;
    private LayerThing parent;
    private Object object;
    private ArrayList<LayerThing> al_children = null;
    private String title = null;

    @Override
    public Thing shallowCopy() {
        return new LayerThing(this);
    }

    private LayerThing(LayerThing lt) {
        super(lt.project, lt.id);
        this.template = lt.template;
        this.title = lt.title;
        this.object = lt.object;
    }

    public LayerThing(TemplateThing template, Project project, Object ob) throws Exception {
        super(project);
        this.template = template;
        if (null == template) {
            throw new Exception("LayerThing constructor: null template!");
        }
        this.object = ob;
        if (null == ob) {
            throw new Exception("LayerThing constructor: null Object!");
        }
        this.addToDatabase();
    }

    public LayerThing(TemplateThing template, Project project, long id, String title, Object ob, ArrayList<LayerThing> al_children) {
        super(project, id);
        this.template = template;
        this.object = ob;
        this.title = title;
        if (null != title && (0 == title.length() || title.toLowerCase().equals("null"))) {
            this.title = null;
        }
        this.al_children = al_children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        if (null != this.al_children) {
            ArrayList<LayerThing> arrayList = this.al_children;
            synchronized (arrayList) {
                for (LayerThing child : this.al_children) {
                    child.parent = this;
                    child.setup();
                }
            }
        }
    }

    @Override
    public Thing getParent() {
        return this.parent;
    }

    public TemplateThing getChildTemplate(String type) {
        return this.template.getChildTemplate(type);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (null != this.parent) {
            sb.append(Integer.toString(this.parent.indexOf(this) + 1)).append(':').append(' ');
        }
        if (null != this.title) {
            sb.append(this.title);
        }
        sb.append(' ');
        if (null == this.object) {
            sb.append(this.template.getType());
        } else {
            sb.append(this.object.toString()).append(' ').append('[').append(this.template.getType()).append(']');
        }
        return sb.toString();
    }

    @Override
    public void setTitle(String title) {
        if (null == title || title.equals(this.title)) {
            return;
        }
        this.title = title;
        this.updateInDatabase("title");
        if (this.object instanceof Layer) {
            Display.updateTitle((Layer)this.object);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean canHaveAsChild(Thing thing) {
        if (null == thing) {
            return false;
        }
        return this.template.canHaveAsChild(thing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addChild(Thing child) {
        if (!this.template.canHaveAsChild(child)) {
            return false;
        }
        if (null == this.al_children) {
            this.al_children = new ArrayList();
        }
        ArrayList<LayerThing> arrayList = this.al_children;
        synchronized (arrayList) {
            if (null != child.getObject() && child.getObject() instanceof Layer) {
                Layer l = (Layer)child.getObject();
                int i = l.getParent().indexOf(l);
                if (i >= this.al_children.size()) {
                    this.al_children.add((LayerThing)child);
                } else {
                    try {
                        this.al_children.add(i, (LayerThing)child);
                    }
                    catch (Exception e) {
                        Utils.log2("LayerThing.addChild: " + e);
                        this.al_children.add((LayerThing)child);
                    }
                }
            } else {
                this.al_children.add((LayerThing)child);
            }
        }
        child.setParent(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(LayerThing child) {
        if (null == this.al_children || null == child) {
            return false;
        }
        ArrayList<LayerThing> arrayList = this.al_children;
        synchronized (arrayList) {
            return this.al_children.remove(child);
        }
    }

    @Override
    public String getType() {
        return this.template.getType();
    }

    public ArrayList<LayerThing> getChildren() {
        return this.al_children;
    }

    @Override
    public boolean hasChildren() {
        return null != this.al_children && 0 != this.al_children.size();
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public void setParent(Thing parent) {
        this.parent = (LayerThing)parent;
        this.updateInDatabase("parent_id");
    }

    public JMenuItem[] getPopupItems(ActionListener listener) {
        JMenuItem item;
        ArrayList<JMenuItem> al_items = new ArrayList<JMenuItem>();
        JMenu menu = new JMenu("Add...");
        ArrayList<TemplateThing> tc = this.template.getChildren();
        if (null != tc) {
            Iterator<TemplateThing> it = tc.iterator();
            while (it.hasNext()) {
                item = new JMenuItem("new " + it.next().getType().replace('_', ' '));
                item.addActionListener(listener);
                menu.add(item);
            }
            if (this.template.getType().replaceAll("_", " ").equals("layer set")) {
                item = new JMenuItem("many new layers...");
                item.addActionListener(listener);
                menu.add(item);
            }
        }
        if (0 != menu.getItemCount()) {
            al_items.add(menu);
        }
        if (null != this.parent) {
            item = new JMenuItem("Show");
            item.addActionListener(listener);
            al_items.add(item);
        }
        if (this.template.getType().equals("layer")) {
            item = new JMenuItem("Adjust...");
            item.addActionListener(listener);
            al_items.add(item);
        }
        item = new JMenuItem("Rename...");
        item.addActionListener(listener);
        al_items.add(item);
        if (this.template.getType().replaceAll("_", " ").equals("layer set")) {
            if (null != this.parent) {
                item = new JMenuItem("Show centered in Display");
                item.addActionListener(listener);
                al_items.add(item);
            }
            item = new JMenuItem("Resize LayerSet...");
            item.addActionListener(listener);
            al_items.add(item);
            LayerSet layer_set = (LayerSet)this.object;
            boolean empty = 0 == layer_set.getLayers().size();
            item = new JMenuItem("Autoresize LayerSet");
            item.addActionListener(listener);
            al_items.add(item);
            if (empty) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Translate layers in Z...");
            item.addActionListener(listener);
            al_items.add(item);
            if (empty) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Reverse layer Z coords...");
            item.addActionListener(listener);
            al_items.add(item);
            if (empty) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Reset layer Z and thickness");
            item.addActionListener(listener);
            al_items.add(item);
            if (empty) {
                item.setEnabled(false);
            }
            item = new JMenuItem("Search...");
            item.addActionListener(listener);
            al_items.add(item);
            if (empty) {
                item.setEnabled(false);
            }
        }
        item = new JMenuItem("Import stack...");
        if (this.template.getType().replaceAll("_", " ").equals("layer set") && 0 != ((LayerSet)this.object).getLayers().size()) {
            item.setEnabled(false);
        }
        item.addActionListener(listener);
        al_items.add(item);
        if (this.template.getType().equals("layer")) {
            item = new JMenuItem("Import grid...");
            item.addActionListener(listener);
            al_items.add(item);
            item = new JMenuItem("Import sequence as grid...");
            item.addActionListener(listener);
            al_items.add(item);
            item = new JMenuItem("Import from text file...");
            item.addActionListener(listener);
            al_items.add(item);
        }
        if (null != this.parent) {
            al_items.add(new JMenuItem(""));
            item = new JMenuItem("Delete...");
            item.addActionListener(listener);
            al_items.add(item);
        }
        JMenuItem[] items = new JMenuItem[al_items.size()];
        al_items.toArray(items);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(boolean check) {
        if (check && !Utils.check("Really delete " + this.toString() + (this.object instanceof Layer && ((Layer)this.object).getDisplayables().size() > 0 ? " and all its children?" : ""))) {
            return false;
        }
        if (null != this.al_children) {
            ArrayList<LayerThing> arrayList = this.al_children;
            synchronized (arrayList) {
                LayerThing[] ob = new LayerThing[this.al_children.size()];
                this.al_children.toArray(ob);
                for (int i = 0; i < ob.length; ++i) {
                    if (ob[i].remove(false)) continue;
                    Utils.log("Could not delete " + ob[i]);
                    return false;
                }
                this.al_children.clear();
            }
        }
        if (null != this.object && this.object instanceof DBObject) {
            if (!((DBObject)this.object).remove(false)) {
                Utils.log("Could not delete " + this.object);
                return false;
            }
            Display.repaint();
        }
        if (null != this.parent && !this.parent.removeChild(this)) {
            Utils.log("Could not delete LayerThing with id=" + this.id);
            return false;
        }
        this.removeFromDatabase();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thing findChild(Object ob) {
        if (this.object.equals(ob)) {
            return this;
        }
        if (null == this.al_children) {
            return null;
        }
        ArrayList<LayerThing> arrayList = this.al_children;
        synchronized (arrayList) {
            Iterator<LayerThing> it = this.al_children.iterator();
            while (it.hasNext()) {
                Thing found = it.next().findChild(ob);
                if (null == found) continue;
                return found;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(LayerThing child) {
        ArrayList<LayerThing> arrayList = this.al_children;
        synchronized (arrayList) {
            return this.al_children.indexOf(child);
        }
    }

    @Override
    public void debug(String indent) {
        StringBuffer sb_at = new StringBuffer(" (id)");
        sb_at.append("  object: ").append(this.object);
        System.out.println(indent + this.template.getType() + sb_at.toString());
        if (null != this.al_children) {
            if (indent.length() > 20) {
                System.out.println("INDENT OVER 20 !");
                return;
            }
            for (LayerThing child : this.al_children) {
                child.debug(indent + "\t");
            }
        }
    }

    @Override
    public boolean isExpanded() {
        return this.project.getLayerTree().isExpanded(this);
    }

    @Override
    public String getInfo() {
        return "Node: " + this.object + "\n" + (this.object instanceof DBObject ? ((DBObject)this.object).getInfo() : "");
    }
}

