/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.util.ArrayList;

public class Bureaucrat
extends Thread {
    private final Worker worker;
    private final Thread worker_thread;
    private final long onset;
    private final Project[] project;
    private boolean started = false;
    private ArrayList<Runnable> post_tasks = new ArrayList();

    private Bureaucrat(ThreadGroup tg, Worker worker, Project project) {
        this(tg, worker, new Project[]{project});
    }

    private Bureaucrat(ThreadGroup tg, Worker worker, Project[] project) {
        super(tg, "T2-Bureaucrat");
        this.setPriority(5);
        this.worker = worker;
        this.worker_thread = new CachingThread(tg, worker, worker.getThreadName());
        this.worker_thread.setPriority(5);
        worker.setThread(this.worker_thread);
        this.project = project;
        this.onset = System.currentTimeMillis();
        for (int i = 0; i < project.length; ++i) {
            project[i].setReceivesInput(false);
            project[i].getLoader().addJob(this);
        }
    }

    public static Bureaucrat create(Worker worker, Project project) {
        return Bureaucrat.create(worker, new Project[]{project});
    }

    public static Bureaucrat create(Worker worker, Project[] project) {
        ThreadGroup tg = new ThreadGroup("T2-Bureaucrat for " + worker.getTaskName());
        return new Bureaucrat(tg, worker, project);
    }

    public static Bureaucrat createAndStart(Worker worker, Project project) {
        return Bureaucrat.createAndStart(worker, new Project[]{project});
    }

    public static Bureaucrat createAndStart(Worker worker, Project[] project) {
        ThreadGroup tg = new ThreadGroup("T2-Bureaucrat for " + worker.getTaskName());
        tg.setMaxPriority(5);
        Bureaucrat burro = new Bureaucrat(tg, worker, project);
        burro.goHaveBreakfast();
        return burro;
    }

    public void goHaveBreakfast() {
        this.worker_thread.start();
        while (!this.worker.hasStarted()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        this.start();
        while (!this.started) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    private void cleanup() {
        Utils.showProgress(1.0);
        for (int i = 0; i < this.project.length; ++i) {
            this.project[i].getLoader().removeJob(this);
            this.project[i].setReceivesInput(true);
        }
    }

    @Override
    public void run() {
        this.started = true;
        while (!this.worker.isWorking()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.worker.hasQuitted() && !this.worker_thread.isInterrupted()) continue;
            this.worker.cleanup2();
            this.cleanup();
            return;
        }
        ControlWindow.startWaitingCursor();
        int sandwitch = ControlWindow.isGUIEnabled() ? 100 : 5000;
        Utils.showStatus("Started processing: " + this.worker.getTaskName(), false);
        StringBuilder sb = new StringBuilder("Processing... ").append(this.worker.getTaskName()).append(" - ");
        int base_len = sb.length();
        while (this.worker.isWorking() && !this.worker.hasQuitted()) {
            try {
                Thread.sleep(sandwitch);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            float elapsed_seconds = (float)(System.currentTimeMillis() - this.onset) / 1000.0f;
            if (elapsed_seconds < 60.0f) {
                sb.append((int)elapsed_seconds).append(" seconds");
            } else {
                sb.append((int)(elapsed_seconds / 60.0f)).append("' ").append((int)(elapsed_seconds % 60.0f)).append("''");
            }
            Utils.showStatus(sb.toString(), false);
            if (sandwitch < 1000) {
                sandwitch += 100;
            }
            sb.setLength(base_len);
        }
        ControlWindow.endWaitingCursor();
        long elapsed = System.currentTimeMillis() - this.onset;
        String done = "Done " + this.worker.getTaskName() + " (" + Utils.cutNumber((double)elapsed / 1000.0, 2) + "s approx.)";
        Utils.showStatus(done, false);
        Utils.log2(done);
        try {
            if (null != this.post_tasks) {
                for (Runnable r : this.post_tasks) {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        IJError.print(t);
                    }
                }
            }
        }
        catch (Throwable t) {
            IJError.print(t);
        }
        this.cleanup();
    }

    public String getTaskName() {
        return this.worker.getTaskName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        try {
            ArrayList<Runnable> arrayList = this.post_tasks;
            synchronized (arrayList) {
                this.post_tasks.clear();
                this.post_tasks = null;
            }
            Utils.log2("ThreadGroup is " + this.getThreadGroup());
            Utils.log2("ThreadGroup active thread count: " + this.getThreadGroup().activeCount());
            Utils.log2("ThreadGroup active group count: " + this.getThreadGroup().activeGroupCount());
            Thread[] active = new Thread[this.getThreadGroup().activeCount()];
            int count = this.getThreadGroup().enumerate(active);
            Utils.log2("Active threads: " + count);
            for (int i = 0; i < count; ++i) {
                Utils.log2("Active thread: " + active[i]);
            }
            this.worker.quit();
            this.getThreadGroup().interrupt();
        }
        catch (Exception e) {
            IJError.print(e);
        }
        try {
            Utils.log("Waiting for worker to quit...");
            this.worker_thread.join();
            Utils.log("Worker quitted.");
        }
        catch (InterruptedException ie) {
            IJError.print(ie);
        }
        Thread.yield();
        final ThreadGroup tg = this.getThreadGroup();
        if (null == tg) {
            Utils.log2("All threads related to the task died.");
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread[] t = new Thread[tg.activeCount() * 2];
                    int len = tg.enumerate(t);
                    for (int i = 0; i < len && i < t.length; ++i) {
                        Utils.log2("Joining thread: " + t[i]);
                        try {
                            t[i].join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Utils.log2("... thread died: " + t[i]);
                    }
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                finally {
                    Utils.showProgress(1.0);
                }
            }
        }.start();
    }

    public boolean isActive() {
        return this.worker.isWorking();
    }

    public Worker getWorker() {
        return this.worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPostTask(Runnable task) {
        if (this.worker.hasQuitted() || null == this.post_tasks) {
            return false;
        }
        ArrayList<Runnable> arrayList = this.post_tasks;
        synchronized (arrayList) {
            this.post_tasks.add(task);
        }
        return true;
    }
}

