/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import java.util.ArrayList;
import java.util.List;

public class History {
    int index = -1;
    int max_size = -1;
    List<Step<?>> list = new ArrayList();

    public History() {
    }

    public History(int max_size) {
        this.max_size = max_size;
    }

    public synchronized List<Step<?>> add(Step<?> step) {
        if (-1 == this.index) {
            if (this.list.size() > 0) {
                this.list.clear();
            }
        } else {
            this.list = this.list.subList(0, this.index + 1);
        }
        if (this.list.size() > 0 && this.list.get(this.list.size() - 1).isIdentical(step)) {
            return new ArrayList();
        }
        ++this.index;
        this.list.add(step);
        if (-1 != this.max_size) {
            return this.resize(this.max_size);
        }
        return new ArrayList();
    }

    public synchronized List<Step<?>> append(Step<?> step) {
        if (this.list.size() > 0 && this.list.get(this.list.size() - 1).isIdentical(step)) {
            return new ArrayList();
        }
        this.list.add(step);
        if (-1 != this.max_size) {
            return this.resize(this.max_size);
        }
        return new ArrayList();
    }

    public synchronized Step<?> getCurrent() {
        if (-1 == this.index) {
            return null;
        }
        return this.list.get(this.index);
    }

    public synchronized Step<?> undoOneStep() {
        if (this.index < 0) {
            return null;
        }
        if (this.index > 0) {
            --this.index;
        }
        return this.list.get(this.index);
    }

    public synchronized Step<?> redoOneStep() {
        if (this.list.size() == this.index + 1) {
            return null;
        }
        return this.list.get(++this.index);
    }

    public synchronized List<?> remove(long id) {
        ArrayList al = new ArrayList();
        for (Step<?> step : this.list) {
            List<?> rm = step.remove(id);
            if (null == rm) continue;
            al.addAll(rm);
        }
        return al;
    }

    public synchronized List<Step<?>> resize(int size) {
        ArrayList al = new ArrayList();
        if (this.list.size() < size) {
            return al;
        }
        int cut = this.list.size() - size;
        this.index = this.index < cut ? 0 : (this.index -= cut);
        al.addAll(this.list.subList(0, cut));
        this.list = this.list.subList(cut, this.list.size());
        return al;
    }

    public synchronized List<Step<?>> clear() {
        ArrayList al = new ArrayList();
        al.addAll(this.list);
        this.list.clear();
        return al;
    }

    public synchronized List<Step<?>> getAll() {
        return new ArrayList(this.list);
    }

    public synchronized Step<?> get(int i) {
        if (i < 0 || i >= this.list.size()) {
            return null;
        }
        return this.list.get(i);
    }

    public synchronized List<Step<?>> clip() {
        ArrayList al = new ArrayList();
        if (this.indexAtEnd()) {
            return al;
        }
        al.addAll(this.list.subList(this.index + 1, this.list.size()));
        this.list = this.list.subList(0, this.index + 1);
        return al;
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized int index() {
        return this.index;
    }

    public synchronized boolean indexAtStart() {
        return 0 == this.index;
    }

    public synchronized boolean indexAtEnd() {
        return this.index + 1 == this.list.size();
    }

    public synchronized boolean canUndo() {
        return this.index > -1;
    }

    public synchronized boolean canRedo() {
        return this.index < this.list.size() - 1;
    }

    public static interface Step<T> {
        public List<T> remove(long var1);

        public boolean isEmpty();

        public boolean isIdentical(Step<?> var1);
    }
}

