/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.intensity;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mpicbg.models.AffineModel1D;
import mpicbg.models.Model;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import org.janelia.intensity.PointMatchFilter;

public class RansacRegressionReduceFilter
implements PointMatchFilter {
    protected final Model<?> model = new AffineModel1D();
    protected final int iterations = 1000;
    protected final double maxEpsilon = 0.1;
    protected final double minInlierRatio = 0.1;
    protected final int minNumInliers = 10;
    protected final double maxTrust = 3.0;

    protected static final double[] minMax(Iterable<PointMatch> matches) {
        double min;
        Iterator<PointMatch> iter = matches.iterator();
        PointMatch m = iter.next();
        double max = min = m.getP1().getL()[0];
        while (iter.hasNext()) {
            m = iter.next();
            double x = m.getP1().getL()[0];
            if (x < min) {
                min = x;
                continue;
            }
            if (!(x > max)) continue;
            max = x;
        }
        return new double[]{min, max};
    }

    @Override
    public void filter(List<PointMatch> candidates, Collection<PointMatch> inliers) {
        try {
            if (this.model.filterRansac(candidates, inliers, 1000, 0.1, 0.1, 10, 3.0)) {
                this.model.fit(inliers);
                double[] minMax = RansacRegressionReduceFilter.minMax(inliers);
                inliers.clear();
                Point p1 = new Point(new double[]{minMax[0]});
                Point p2 = new Point(new double[]{minMax[1]});
                p1.apply(this.model);
                p2.apply(this.model);
                inliers.add(new PointMatch(p1, new Point((double[])p1.getW().clone())));
                inliers.add(new PointMatch(p2, new Point((double[])p2.getW().clone())));
            } else {
                inliers.clear();
            }
        }
        catch (Exception e) {
            inliers.clear();
        }
    }
}

