/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.n5;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.cache.CacheControl;
import bdv.cache.SharedQueue;
import bdv.img.cache.SimpleCacheArrayLoader;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.n5.DataTypeProperties;
import bdv.img.n5.DefaultN5Properties;
import bdv.img.n5.N5Properties;
import bdv.util.ConstantRandomAccessible;
import bdv.util.MipmapTransforms;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.blocks.SubArrayCopy;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5FSReader;
import org.janelia.saalfeldlab.n5.N5Reader;

public class N5ImageLoader
implements ViewerImgLoader,
MultiResolutionImgLoader {
    private final URI n5URI;
    private final AbstractSequenceDescription<?, ?, ?> seq;
    private final Map<Integer, SetupImgLoader<?, ?>> setupImgLoaders = new HashMap();
    private volatile boolean isOpen = false;
    private SharedQueue createdSharedQueue;
    private VolatileGlobalCellCache cache;
    private N5Reader n5;
    private N5Properties n5properties;
    private int requestedNumFetcherThreads = -1;
    private SharedQueue requestedSharedQueue;

    public N5ImageLoader(URI n5URI, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this.n5URI = n5URI;
        this.seq = sequenceDescription;
    }

    public N5ImageLoader(File n5File, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this(n5File.toURI(), sequenceDescription);
    }

    public N5ImageLoader(N5Reader n5Reader, URI n5URI, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this(n5URI, sequenceDescription);
        this.n5 = n5Reader;
    }

    public URI getN5URI() {
        return this.n5URI;
    }

    public File getN5File() {
        return new File(this.n5URI);
    }

    protected N5Reader instantiateN5Reader() {
        return new N5FSReader(this.getN5File().getAbsolutePath());
    }

    protected N5Properties createN5PropertiesInstance() {
        return new DefaultN5Properties();
    }

    public Future<Void> prefetch(int parallelism) {
        this.openReader();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        new Thread(() -> {
            ForkJoinPool myPool = new ForkJoinPool(parallelism);
            try {
                List vss = this.seq.getViewSetupsOrdered();
                ConcurrentHashMap setupIdToNumLevels = new ConcurrentHashMap();
                ((ForkJoinTask)myPool.submit(() -> vss.parallelStream().mapToInt(Entity::getId).forEach(setup -> {
                    this.n5properties.getDataType(this.n5, setup);
                    setupIdToNumLevels.put(setup, this.n5properties.getMipmapResolutions(this.n5, setup).length);
                }))).join();
                ((ForkJoinTask)myPool.submit(() -> {
                    List tps = this.seq.getTimePoints().getTimePointsOrdered();
                    Stream<Object> viewIds = vss.parallelStream().flatMap(setup -> tps.parallelStream().map(tp -> new ViewId(tp.getId(), setup.getId())));
                    if (this.seq.getMissingViews() != null) {
                        Set missing = this.seq.getMissingViews().getMissingViews();
                        viewIds = viewIds.filter(v -> !missing.contains(v));
                    }
                    viewIds.forEach(viewId -> {
                        int setup = viewId.getViewSetupId();
                        int tp = viewId.getTimePointId();
                        int numLevels = (Integer)setupIdToNumLevels.get(setup);
                        IntStream.range(0, numLevels).parallel().forEach(level -> this.n5.getDatasetAttributes(this.n5properties.getDatasetPath(setup, tp, level)));
                    });
                })).join();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            myPool.shutdown();
        }).start();
        return future;
    }

    @Override
    public synchronized void setNumFetcherThreads(int n) {
        this.requestedNumFetcherThreads = n;
    }

    @Override
    public void setCreatedSharedQueue(SharedQueue createdSharedQueue) {
        this.requestedSharedQueue = createdSharedQueue;
    }

    private synchronized void openReader() {
        if (this.n5 == null) {
            this.n5 = this.instantiateN5Reader();
        }
        if (this.n5properties == null) {
            this.n5properties = this.createN5PropertiesInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() {
        if (!this.isOpen) {
            N5ImageLoader n5ImageLoader = this;
            synchronized (n5ImageLoader) {
                if (this.isOpen) {
                    return;
                }
                try {
                    this.openReader();
                    int maxNumLevels = 0;
                    List setups = this.seq.getViewSetupsOrdered();
                    for (BasicViewSetup setup : setups) {
                        int setupId = setup.getId();
                        SetupImgLoader setupImgLoader = this.createSetupImgLoader(setupId);
                        this.setupImgLoaders.put(setupId, setupImgLoader);
                        maxNumLevels = Math.max(maxNumLevels, setupImgLoader.numMipmapLevels());
                    }
                    int numFetcherThreads = this.requestedNumFetcherThreads >= 0 ? this.requestedNumFetcherThreads : Math.max(1, Runtime.getRuntime().availableProcessors());
                    SharedQueue queue = this.requestedSharedQueue != null ? this.requestedSharedQueue : (this.createdSharedQueue = new SharedQueue(numFetcherThreads, maxNumLevels));
                    this.cache = new VolatileGlobalCellCache(queue);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.isOpen = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isOpen) {
            N5ImageLoader n5ImageLoader = this;
            synchronized (n5ImageLoader) {
                if (!this.isOpen) {
                    return;
                }
                if (this.createdSharedQueue != null) {
                    this.createdSharedQueue.shutdown();
                }
                this.cache.clearCache();
                this.createdSharedQueue = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public SetupImgLoader<?, ?> getSetupImgLoader(int setupId) {
        this.open();
        return this.setupImgLoaders.get(setupId);
    }

    private <T extends NativeType<T>, V extends Volatile<T>> SetupImgLoader<T, V> createSetupImgLoader(int setupId) throws IOException {
        try {
            DataType dataType = this.n5properties.getDataType(this.n5, setupId);
            return new SetupImgLoader(this, setupId, (DataTypeProperties)Cast.unchecked(DataTypeProperties.of(dataType)));
        }
        catch (N5Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public CacheControl getCacheControl() {
        this.open();
        return this.cache;
    }

    protected <T extends NativeType<T>> RandomAccessibleInterval<T> prepareCachedImage(String datasetPath, int setupId, int timepointId, int level, CacheHints cacheHints, T type) {
        try {
            DatasetAttributes attributes = this.n5.getDatasetAttributes(datasetPath);
            long[] dimensions = attributes.getDimensions();
            int[] cellDimensions = attributes.getBlockSize();
            CellGrid grid = new CellGrid(dimensions, cellDimensions);
            DataTypeProperties<?, ?, ?, ?> dataTypeProperties = DataTypeProperties.of(attributes.getDataType());
            N5CacheArrayLoader loader = new N5CacheArrayLoader(this.n5, datasetPath, attributes, dataTypeProperties);
            return this.cache.createImg(grid, timepointId, setupId, level, cacheHints, loader, type);
        }
        catch (N5Exception e) {
            System.err.println(String.format("image data for timepoint %d setup %d level %d could not be found.", timepointId, setupId, level));
            return Views.interval(new ConstantRandomAccessible(type.createVariable(), 3), new FinalInterval(1L, 1L, 1L));
        }
    }

    public static SimpleCacheArrayLoader<?> createCacheArrayLoader(N5Reader n5, String pathName) throws IOException {
        DatasetAttributes attributes;
        try {
            attributes = n5.getDatasetAttributes(pathName);
        }
        catch (N5Exception e) {
            throw new IOException(e);
        }
        return new N5CacheArrayLoader(n5, pathName, attributes, DataTypeProperties.of(attributes.getDataType()));
    }

    private static class N5CacheArrayLoader<T, A extends DataAccess>
    implements SimpleCacheArrayLoader<A> {
        private final N5Reader n5;
        private final String pathName;
        private final DatasetAttributes attributes;
        private final IntFunction<T> createPrimitiveArray;
        private final Function<T, A> createVolatileArrayAccess;
        private final SubArrayCopy.Typed<T, T> subArrayCopy;

        N5CacheArrayLoader(N5Reader n5, String pathName, DatasetAttributes attributes, DataTypeProperties<?, ?, T, A> dataTypeProperties) {
            this(n5, pathName, attributes, dataTypeProperties.createPrimitiveArray(), dataTypeProperties.createVolatileArrayAccess(), SubArrayCopy.forPrimitiveType(dataTypeProperties.type().getNativeTypeFactory().getPrimitiveType()));
        }

        N5CacheArrayLoader(N5Reader n5, String pathName, DatasetAttributes attributes, IntFunction<T> createPrimitiveArray, Function<T, A> createVolatileArrayAccess, SubArrayCopy.Typed<T, T> subArrayCopy) {
            this.n5 = n5;
            this.pathName = pathName;
            this.attributes = attributes;
            this.createPrimitiveArray = createPrimitiveArray;
            this.createVolatileArrayAccess = createVolatileArrayAccess;
            this.subArrayCopy = subArrayCopy;
        }

        @Override
        public A loadArray(long[] gridPosition, int[] cellDimensions) throws IOException {
            DataBlock dataBlock;
            try {
                dataBlock = (DataBlock)Cast.unchecked(this.n5.readBlock(this.pathName, this.attributes, gridPosition));
            }
            catch (N5Exception e) {
                throw new IOException(e);
            }
            if (dataBlock != null && Arrays.equals(dataBlock.getSize(), cellDimensions)) {
                return (A)((DataAccess)this.createVolatileArrayAccess.apply(dataBlock.getData()));
            }
            T data = this.createPrimitiveArray.apply((int)Intervals.numElements(cellDimensions));
            if (dataBlock != null) {
                Object src = dataBlock.getData();
                int[] srcDims = dataBlock.getSize();
                int[] pos = new int[srcDims.length];
                int[] size = new int[srcDims.length];
                Arrays.setAll(size, d -> Math.min(srcDims[d], cellDimensions[d]));
                this.subArrayCopy.copy(src, srcDims, pos, data, cellDimensions, pos, size);
            }
            return (A)((DataAccess)this.createVolatileArrayAccess.apply(data));
        }
    }

    public static class SetupImgLoader<T extends NativeType<T>, V extends Volatile<T>>
    extends AbstractViewerSetupImgLoader<T, V>
    implements MultiResolutionSetupImgLoader<T> {
        private final int setupId;
        private final double[][] mipmapResolutions;
        private final AffineTransform3D[] mipmapTransforms;
        final /* synthetic */ N5ImageLoader this$0;

        public SetupImgLoader(N5ImageLoader this$0, int setupId, DataTypeProperties<T, V, ?, ?> props) throws IOException {
            this(this$0, setupId, (NativeType)props.type(), (Volatile)props.volatileType());
        }

        public SetupImgLoader(int setupId, T type, V volatileType) throws IOException {
            this.this$0 = this$0;
            super(type, volatileType);
            this.setupId = setupId;
            try {
                this.mipmapResolutions = ((N5ImageLoader)this$0).n5properties.getMipmapResolutions(((N5ImageLoader)this$0).n5, setupId);
            }
            catch (N5Exception e) {
                throw new IOException(e);
            }
            this.mipmapTransforms = new AffineTransform3D[this.mipmapResolutions.length];
            for (int level = 0; level < this.mipmapResolutions.length; ++level) {
                this.mipmapTransforms[level] = MipmapTransforms.getMipmapTransformDefault(this.mipmapResolutions[level]);
            }
        }

        @Override
        public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BUDGETED, (NativeType)((Object)this.volatileType));
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
            return this.prepareCachedImage(timepointId, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
        }

        private <T extends NativeType<T>> RandomAccessibleInterval<T> prepareCachedImage(int timepointId, int level, LoadingStrategy loadingStrategy, T type) {
            int priority = this.numMipmapLevels() - 1 - level;
            CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
            String datasetPath = this.this$0.n5properties.getDatasetPath(this.setupId, timepointId, level);
            return this.this$0.prepareCachedImage(datasetPath, this.setupId, timepointId, level, cacheHints, type);
        }

        public Dimensions getImageSize(int timepointId, int level) {
            try {
                return new FinalDimensions(this.this$0.n5properties.getDimensions(this.this$0.n5, this.setupId, timepointId, level));
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public double[][] getMipmapResolutions() {
            return this.mipmapResolutions;
        }

        public AffineTransform3D[] getMipmapTransforms() {
            return this.mipmapTransforms;
        }

        public int numMipmapLevels() {
            return this.mipmapResolutions.length;
        }

        public VoxelDimensions getVoxelSize(int timepointId) {
            return null;
        }
    }
}

