/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.openconnectome;

import bdv.img.cache.CacheArrayLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;

public class OpenConnectomeVolatileArrayLoader
implements CacheArrayLoader<VolatileByteArray> {
    private final String tokenUrl;
    private final String mode;
    private final long zMin;

    public OpenConnectomeVolatileArrayLoader(String baseUrl, String token, String mode, long zMin) {
        this.tokenUrl = baseUrl + "/" + token + "/zip/";
        this.mode = "/" + mode + (mode == null || mode.equals("") ? "" : "/");
        this.zMin = zMin;
    }

    @Override
    public int getBytesPerElement() {
        return 1;
    }

    @Override
    public VolatileByteArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        try {
            return this.tryLoadArray(timepoint, setup, level, dimensions, min);
        }
        catch (OutOfMemoryError e) {
            System.gc();
            return this.tryLoadArray(timepoint, setup, level, dimensions, min);
        }
    }

    public VolatileByteArray tryLoadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        byte[] data = new byte[dimensions[0] * dimensions[1] * dimensions[2]];
        StringBuffer url = new StringBuffer(this.tokenUrl);
        long z = min[2] + this.zMin;
        url.append(level);
        url.append("/");
        url.append(min[0]);
        url.append(",");
        url.append(min[0] + (long)dimensions[0]);
        url.append("/");
        url.append(min[1]);
        url.append(",");
        url.append(min[1] + (long)dimensions[1]);
        url.append("/");
        url.append(z);
        url.append(",");
        url.append(z + (long)dimensions[2]);
        url.append(this.mode);
        try {
            URL file = new URL(url.toString());
            InputStream in = file.openStream();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byte[] chunk = new byte[4096];
            int l = in.read(chunk);
            while (l > 0) {
                byteStream.write(chunk, 0, l);
                l = in.read(chunk);
            }
            byte[] zippedData = byteStream.toByteArray();
            Inflater inflater = new Inflater();
            inflater.setInput(zippedData);
            inflater.inflate(data);
            inflater.end();
            byteStream.close();
        }
        catch (IOException e) {
            System.out.println("failed loading x=" + min[0] + " y=" + min[1] + " z=" + min[2] + " url(" + url.toString() + ")");
        }
        catch (DataFormatException e) {
            System.out.println("failed unpacking x=" + min[0] + " y=" + min[1] + " z=" + min[2] + " url(" + url.toString() + ")");
        }
        return new VolatileByteArray(data, true);
    }
}

