/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.remote;

import bdv.img.cache.CacheArrayLoader;
import bdv.img.remote.RemoteImageLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;

public class RemoteVolatileShortArrayLoader
implements CacheArrayLoader<VolatileShortArray> {
    private final RemoteImageLoader imgLoader;

    public RemoteVolatileShortArrayLoader(RemoteImageLoader imgLoader) {
        this.imgLoader = imgLoader;
    }

    @Override
    public VolatileShortArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        int index = this.imgLoader.getCellIndex(timepoint, setup, level, min);
        short[] data = new short[dimensions[0] * dimensions[1] * dimensions[2]];
        try {
            URL url = new URL(String.format("%s?p=cell/%d/%d/%d/%d/%d/%d/%d/%d/%d/%d", this.imgLoader.baseUrl, index, timepoint, setup, level, dimensions[0], dimensions[1], dimensions[2], min[0], min[1], min[2]));
            InputStream s = url.openStream();
            byte[] buf = new byte[data.length * 2];
            int i = 0;
            int l = s.read(buf, 0, buf.length);
            while (l > 0) {
                l = s.read(buf, i += l, buf.length - i);
            }
            i = 0;
            int j = 0;
            while (i < data.length) {
                data[i] = (short)((buf[j] & 0xFF) << 8 | buf[j + 1] & 0xFF);
                ++i;
                j += 2;
            }
            s.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new VolatileShortArray(data, true);
    }

    @Override
    public int getBytesPerElement() {
        return 2;
    }
}

