/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.state.ViewerState;
import java.util.ArrayList;
import java.util.Collection;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;

public class BoundingBoxUtil {
    public static Interval getSourcesBoundingBox(bdv.viewer.ViewerState state) {
        return BoundingBoxUtil.getSourcesBoundingBox(state, 0, state.getNumTimepoints() - 1);
    }

    public static Interval getSourcesBoundingBox(bdv.viewer.ViewerState state, int minTimepointIndex, int maxTimepointIndex) {
        ArrayList sources = new ArrayList();
        for (SourceAndConverter<?> source : state.getSources()) {
            sources.add(source.getSpimSource());
        }
        return BoundingBoxUtil.getSourcesBoundingBox(sources, minTimepointIndex, maxTimepointIndex);
    }

    public static Interval getSourcesBoundingBox(Collection<? extends Source<?>> sources, int minTimepointIndex, int maxTimepointIndex) {
        long[] bbMin = new long[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        long[] bbMax = new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        long[] min = new long[3];
        long[] max = new long[3];
        AffineTransform3D sourceTransform = new AffineTransform3D();
        RealPoint sourceCorner = new RealPoint(3);
        RealPoint globalCorner = new RealPoint(3);
        for (Source<?> source : sources) {
            for (int t = minTimepointIndex; t <= maxTimepointIndex; ++t) {
                if (!source.isPresent(t)) continue;
                RandomAccessibleInterval<?> sourceInterval = source.getSource(t, 0);
                sourceInterval.min(min);
                sourceInterval.max(max);
                source.getSourceTransform(0, 0, sourceTransform);
                for (int i = 0; i < 8; ++i) {
                    int d;
                    for (d = 0; d < 3; ++d) {
                        double p = (i & 1 << d) == 0 ? (double)min[d] : (double)max[d];
                        sourceCorner.setPosition(p, d);
                    }
                    sourceTransform.apply((RealLocalizable)sourceCorner, (RealPositionable)globalCorner);
                    for (d = 0; d < 3; ++d) {
                        long p = (long)globalCorner.getDoublePosition(d);
                        if (p < bbMin[d]) {
                            bbMin[d] = p;
                        }
                        if (p <= bbMax[d]) continue;
                        bbMax[d] = p;
                    }
                }
            }
        }
        return new FinalInterval(bbMin, bbMax);
    }

    public static RealInterval getSourcesBoundingBoxReal(bdv.viewer.ViewerState state) {
        return BoundingBoxUtil.getSourcesBoundingBoxReal(state, 0, state.getNumTimepoints() - 1);
    }

    public static RealInterval getSourcesBoundingBoxReal(bdv.viewer.ViewerState state, int minTimepointIndex, int maxTimepointIndex) {
        ArrayList sources = new ArrayList();
        for (SourceAndConverter<?> source : state.getSources()) {
            sources.add(source.getSpimSource());
        }
        return BoundingBoxUtil.getSourcesBoundingBoxReal(sources, minTimepointIndex, maxTimepointIndex);
    }

    public static RealInterval getSourcesBoundingBoxReal(Collection<? extends Source<?>> sources, int minTimepointIndex, int maxTimepointIndex) {
        double[] bbMin = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] bbMax = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        long[] min = new long[3];
        long[] max = new long[3];
        AffineTransform3D sourceTransform = new AffineTransform3D();
        RealPoint sourceCorner = new RealPoint(3);
        RealPoint globalCorner = new RealPoint(3);
        for (Source<?> source : sources) {
            for (int t = minTimepointIndex; t <= maxTimepointIndex; ++t) {
                if (!source.isPresent(t)) continue;
                RandomAccessibleInterval<?> sourceInterval = source.getSource(t, 0);
                sourceInterval.min(min);
                sourceInterval.dimensions(max);
                for (int d = 0; d < 3; ++d) {
                    int n = d;
                    max[n] = max[n] + min[d];
                }
                source.getSourceTransform(0, 0, sourceTransform);
                for (int i = 0; i < 8; ++i) {
                    double p;
                    int d;
                    for (d = 0; d < 3; ++d) {
                        p = (i & 1 << d) == 0 ? (double)min[d] : (double)max[d];
                        sourceCorner.setPosition(p, d);
                    }
                    sourceTransform.apply((RealLocalizable)sourceCorner, (RealPositionable)globalCorner);
                    for (d = 0; d < 3; ++d) {
                        p = globalCorner.getDoublePosition(d);
                        if (p < bbMin[d]) {
                            bbMin[d] = p;
                        }
                        if (!(p > bbMax[d])) continue;
                        bbMax[d] = p;
                    }
                }
            }
        }
        return new FinalRealInterval(bbMin, bbMax);
    }

    public static RealInterval transformBoundingBoxReal(RealInterval sourceInterval, AffineTransform3D transform) {
        double[] bbMin = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] bbMax = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] min = new double[3];
        double[] max = new double[3];
        RealPoint sourceCorner = new RealPoint(3);
        RealPoint globalCorner = new RealPoint(3);
        sourceInterval.realMin(min);
        sourceInterval.realMax(max);
        for (int i = 0; i < 8; ++i) {
            double p;
            int d;
            for (d = 0; d < 3; ++d) {
                p = (i & 1 << d) == 0 ? min[d] : max[d];
                sourceCorner.setPosition(p, d);
            }
            transform.apply((RealLocalizable)sourceCorner, (RealPositionable)globalCorner);
            for (d = 0; d < 3; ++d) {
                p = globalCorner.getDoublePosition(d);
                if (p < bbMin[d]) {
                    bbMin[d] = p;
                }
                if (!(p > bbMax[d])) continue;
                bbMax[d] = p;
            }
        }
        return new FinalRealInterval(bbMin, bbMax);
    }

    @Deprecated
    public static Interval getSourcesBoundingBox(ViewerState state) {
        return BoundingBoxUtil.getSourcesBoundingBox(state.getState());
    }

    @Deprecated
    public static Interval getSourcesBoundingBox(ViewerState state, int minTimepointIndex, int maxTimepointIndex) {
        return BoundingBoxUtil.getSourcesBoundingBox(state.getState(), minTimepointIndex, maxTimepointIndex);
    }

    @Deprecated
    public static RealInterval getSourcesBoundingBoxReal(ViewerState state) {
        return BoundingBoxUtil.getSourcesBoundingBoxReal(state.getState());
    }

    @Deprecated
    public static RealInterval getSourcesBoundingBoxReal(ViewerState state, int minTimepointIndex, int maxTimepointIndex) {
        return BoundingBoxUtil.getSourcesBoundingBoxReal(state.getState(), minTimepointIndex, maxTimepointIndex);
    }
}

