/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.brightness;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private final int width;
    private final int height;
    private final boolean drawAsCircle;
    private final int arcWidth;
    private final int arcHeight;
    private final boolean drawOutline;
    private Color outlineColor;
    private Color color;
    private final int size;
    private final int ox;
    private final int oy;

    public ColorIcon(Color color) {
        this(color, 16, 16, true);
    }

    public ColorIcon(Color color, int width, int height, boolean drawAsCircle) {
        this(color, width, height, drawAsCircle, 3, 3, false, null);
    }

    public ColorIcon(Color color, int width, int height, int arcWidth, int arcHeight) {
        this(color, width, height, false, arcWidth, arcHeight, false, null);
    }

    public ColorIcon(Color color, int width, int height, int arcWidth, int arcHeight, boolean drawOutline) {
        this(color, width, height, false, arcWidth, arcHeight, drawOutline, null);
    }

    public ColorIcon(Color color, int width, int height, int arcWidth, int arcHeight, boolean drawOutline, Color outlineColor) {
        this(color, width, height, false, arcWidth, arcHeight, drawOutline, outlineColor);
    }

    private ColorIcon(Color color, int width, int height, boolean drawAsCircle, int arcWidth, int arcHeight, boolean drawOutline, Color outlineColor) {
        this.color = color;
        this.width = width;
        this.height = height;
        this.drawAsCircle = drawAsCircle;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.drawOutline = drawOutline;
        this.outlineColor = outlineColor;
        this.size = Math.min(width, height);
        this.ox = (width - this.size) / 2;
        this.oy = (height - this.size) / 2;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x0 = x + this.ox;
        int y0 = y + this.oy;
        if (this.color == null) {
            g2d.setColor(new Color(0xFFBCBC));
            g2d.fillArc(x0, y0, this.size, this.size, 0, 120);
            g2d.setColor(new Color(0xBCFFBC));
            g2d.fillArc(x0, y0, this.size, this.size, 120, 120);
            g2d.setColor(new Color(0xBCBCFF));
            g2d.fillArc(x0, y0, this.size, this.size, 240, 120);
        } else {
            g2d.setColor(this.color);
            if (this.drawAsCircle) {
                g2d.fillOval(x0, y0, this.size, this.size);
            } else {
                g2d.fillRoundRect(x, y, this.width, this.height, this.arcWidth, this.arcHeight);
            }
            if (this.drawOutline) {
                Color oc = this.outlineColor == null ? (c.isFocusOwner() ? new Color(9422073) : Color.gray) : this.outlineColor;
                g2d.setColor(oc);
                if (this.drawAsCircle) {
                    g2d.drawOval(x0, y0, this.size, this.size);
                } else {
                    g2d.drawRoundRect(x, y, this.width, this.height, this.arcWidth, this.arcHeight);
                }
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }
}

