/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.sourcetable;

import bdv.tools.brightness.ConverterSetup;
import bdv.ui.SourcesTransferable;
import bdv.ui.UIUtils;
import bdv.ui.sourcetable.ColorRenderer;
import bdv.ui.sourcetable.RadioButtonRenderer;
import bdv.ui.sourcetable.SourceTableModel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceToConverterSetupBimap;
import bdv.viewer.ViewerState;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class SourceTable
extends JTable {
    private final SourceTableModel model;
    private final ViewerState state;
    private final SourceToConverterSetupBimap converters;
    private Color selectionActiveBackground;
    private Color selectionInactiveBackground;
    private Color selectionActiveForeground;
    private Color selectionInactiveForeground;
    private Point pressedAt;
    private boolean consumeNext = false;
    private long releasedWhen = 0L;

    public SourceTable(ViewerState state, ConverterSetups converterSetups) {
        this(state, converterSetups, new InputTriggerConfig());
    }

    public SourceTable(ViewerState state, ConverterSetups converterSetups, InputTriggerConfig inputTriggerConfig) {
        this.state = state;
        this.converters = converterSetups;
        this.model = new SourceTableModel(state, converterSetups);
        this.setModel(this.model);
        this.setTransferHandler(new SourceTableTransferHandler());
        this.getColumnModel().getColumn(1).setCellRenderer(new RadioButtonRenderer());
        this.getColumnModel().getColumn(3).setCellRenderer(new ColorRenderer());
        this.setRowHeight((int)Math.round((double)UIManager.getDefaults().getFont("Table.font").getSize() * 1.5));
        this.setShowGrid(false);
        this.getColumnModel().getColumn(1).setMinWidth(20);
        this.getColumnModel().getColumn(2).setMinWidth(20);
        this.getColumnModel().getColumn(3).setMinWidth(40);
        this.installActions(inputTriggerConfig);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SourceTable.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SourceTable.this.repaint();
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setRowHeight((int)Math.round((double)UIManager.getDefaults().getFont("Table.font").getSize() * 1.5));
        this.updateColors();
    }

    private void updateColors() {
        this.selectionActiveBackground = UIManager.getColor("Table.selectionBackground");
        this.selectionInactiveBackground = FlatUIUtils.getUIColor((String)"Table.selectionInactiveBackground", (Color)UIUtils.mix(this.selectionActiveBackground, UIManager.getColor("Table.background"), 0.5));
        this.selectionActiveForeground = UIManager.getColor("Table.selectionForeground");
        this.selectionInactiveForeground = FlatUIUtils.getUIColor((String)"Table.selectionInactiveForeground", (Color)UIUtils.mix(this.selectionActiveForeground, UIManager.getColor("Table.foreground"), 0.0));
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean hasFocus = FlatUIUtils.isPermanentFocusOwner((Component)this);
        this.selectionBackground = hasFocus ? this.selectionActiveBackground : this.selectionInactiveBackground;
        this.selectionForeground = hasFocus ? this.selectionActiveForeground : this.selectionInactiveForeground;
        super.paintComponent(g);
    }

    public List<SourceAndConverter<?>> getSelectedSources() {
        ArrayList sources = new ArrayList();
        for (int row : this.getSelectedRows()) {
            sources.add(this.model.getValueAt(row).getSource());
        }
        return sources;
    }

    public List<ConverterSetup> getSelectedConverterSetups() {
        return this.converters.getConverterSetups(this.getSelectedSources());
    }

    private void installActions(InputTriggerConfig inputTriggerConfig) {
        InputActionBindings keybindings = InputActionBindings.installNewBindings((JComponent)this, (int)0, (boolean)false);
        Actions actions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv"});
        actions.install(keybindings, "source table");
        actions.runnableAction(() -> this.toggleSelectedActive(), "toggle active", new String[]{"A"});
        actions.runnableAction(() -> this.makeSelectedActive(true), "set active", new String[]{"not mapped"});
        actions.runnableAction(() -> this.makeSelectedActive(false), "set inactive", new String[]{"not mapped"});
        actions.runnableAction(() -> this.cycleSelectedCurrent(), "cycle current", new String[]{"C"});
    }

    private void makeSelectedActive(boolean active) {
        List<SourceAndConverter<?>> selectedSources = this.getSelectedSources();
        this.state.setSourcesActive(selectedSources, active);
    }

    private void toggleSelectedActive() {
        List<SourceAndConverter<?>> selectedSources = this.getSelectedSources();
        if (!selectedSources.isEmpty()) {
            this.state.setSourcesActive(selectedSources, !this.state.isSourceActive(selectedSources.get(0)));
        }
    }

    private void cycleSelectedCurrent() {
        List<SourceAndConverter<?>> selectedSources = this.getSelectedSources();
        if (!selectedSources.isEmpty()) {
            SourceAndConverter<?> current = this.state.getCurrentSource();
            int i = (selectedSources.indexOf(current) + 1) % selectedSources.size();
            this.state.setCurrentSource(selectedSources.get(i));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void processMouseEvent(MouseEvent e) {
        block15: {
            block17: {
                block16: {
                    if (e.getModifiers() != 16) break block15;
                    if (e.getID() != 501) break block16;
                    this.pressedAt = point = e.getPoint();
                    vcol = this.columnAtPoint(point);
                    vrow = this.rowAtPoint(point);
                    if (vcol >= 0 && vrow >= 0) {
                        mcol = this.convertColumnIndexToModel(vcol);
                        switch (mcol) {
                            case 1: 
                            case 2: 
                            case 3: {
                                mrow = this.convertRowIndexToModel(vrow);
                                if (!this.isRowSelected(mrow)) break;
                                e.consume();
                                this.consumeNext = true;
                            }
                        }
                    }
                    break block15;
                }
                if (e.getID() != 502) break block17;
                if (this.consumeNext) {
                    this.releasedWhen = e.getWhen();
                    this.consumeNext = false;
                    e.consume();
                }
                if (this.pressedAt == null) {
                    return;
                }
                point = e.getPoint();
                if (point.distanceSq(this.pressedAt) > 2.0) {
                    return;
                }
                vcol = this.columnAtPoint(point);
                vrow = this.rowAtPoint(point);
                if (vcol < 0 || vrow < 0) break block15;
                mcol = this.convertColumnIndexToModel(vcol);
                switch (mcol) {
                    case 1: 
                    case 2: 
                    case 3: {
                        mrow = this.convertRowIndexToModel(vrow);
                        source = this.model.getValueAt(mrow).getSource();
                        if (mcol == 2) {
                            if (this.isRowSelected(mrow)) {
                                this.state.setSourcesActive(this.getSelectedSources(), this.state.isSourceActive(source) == false);
                                break;
                            }
                            this.state.setSourceActive(source, this.state.isSourceActive(source) == false);
                            break;
                        }
                        if (mcol == 1) {
                            this.state.setCurrentSource(source);
                            break;
                        }
                        this.converters.getConverterSetup(source);
                        c = this.converters.getConverterSetup(source);
                        if (c == null || !c.supportsColor() || (newColor = JColorChooser.showDialog(null, "Set Source Color", new Color(c.getColor().get()))) == null) break;
                        color = new ARGBType(newColor.getRGB() | -16777216);
                        if (!this.isRowSelected(mrow)) ** GOTO lbl58
                        for (SourceAndConverter<?> s : this.getSelectedSources()) {
                            cs = this.converters.getConverterSetup(s);
                            if (cs == null || !cs.supportsColor()) continue;
                            cs.setColor(color);
                        }
                        break block15;
lbl58:
                        // 1 sources

                        c.setColor(color);
                    }
                }
                break block15;
            }
            if (e.getID() == 500 && e.getWhen() == this.releasedWhen) {
                e.consume();
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.consumeNext && e.getModifiers() == 16 && e.getID() == 506) {
            e.consume();
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    public SourceTableModel getModel() {
        return this.model;
    }

    static class SourceTableTransferHandler
    extends TransferHandler {
        SourceTableTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000000;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof JTable)) {
                return null;
            }
            JTable table = (JTable)c;
            if (!(table.getModel() instanceof SourceTableModel)) {
                return null;
            }
            SourceTableModel model = (SourceTableModel)table.getModel();
            ArrayList sources = new ArrayList();
            for (int row : table.getSelectedRows()) {
                sources.add(model.getValueAt(row).getSource());
            }
            return new SourcesTransferable(sources);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return false;
        }
    }
}

