/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.state;

import bdv.viewer.ViewerState;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

@Deprecated
public class SourceGroup {
    protected final SortedSet<Integer> sourceIds;
    private final ViewerState state;
    private final bdv.viewer.SourceGroup handle;
    protected String name;
    protected boolean isActive;
    protected boolean isCurrent;

    public SourceGroup(ViewerState state, bdv.viewer.SourceGroup handle) {
        this.state = state;
        this.handle = handle;
        this.sourceIds = Collections.synchronizedSortedSet(new TreeSet());
    }

    public SourceGroup(String name) {
        this.state = null;
        this.handle = null;
        this.sourceIds = Collections.synchronizedSortedSet(new TreeSet());
        this.name = name;
        this.isActive = true;
        this.isCurrent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SourceGroup(SourceGroup g) {
        this.state = null;
        this.handle = null;
        SortedSet<Integer> sortedSet = g.getSourceIds();
        synchronized (sortedSet) {
            this.sourceIds = Collections.synchronizedSortedSet(new TreeSet<Integer>(g.getSourceIds()));
        }
        this.name = g.getName();
        this.isActive = g.isActive();
        this.isCurrent = g.isCurrent();
    }

    public SourceGroup copy() {
        return new SourceGroup(this);
    }

    public void addSource(int sourceId) {
        if (this.handle == null) {
            this.sourceIds.add(sourceId);
        } else {
            this.state.addSourceToGroup(this.state.getSources().get(sourceId), this.handle);
            this.sourceIds.clear();
            this.state.getSourcesInGroup(this.handle).forEach(source -> this.sourceIds.add(this.state.getSources().indexOf(source)));
        }
    }

    public void removeSource(int sourceId) {
        if (this.handle == null) {
            this.sourceIds.remove(sourceId);
        } else {
            this.state.removeSourceFromGroup(this.state.getSources().get(sourceId), this.handle);
            this.sourceIds.clear();
            this.state.getSourcesInGroup(this.handle).forEach(source -> this.sourceIds.add(this.state.getSources().indexOf(source)));
        }
    }

    public SortedSet<Integer> getSourceIds() {
        if (this.handle != null) {
            this.sourceIds.clear();
            this.state.getSourcesInGroup(this.handle).forEach(source -> this.sourceIds.add(this.state.getSources().indexOf(source)));
        }
        return this.sourceIds;
    }

    public String getName() {
        if (this.handle != null) {
            this.name = this.state.getGroupName(this.handle);
        }
        return this.name;
    }

    public void setName(String name) {
        if (this.handle != null) {
            this.state.setGroupName(this.handle, name);
        }
        this.name = name;
    }

    public boolean isActive() {
        if (this.handle != null) {
            this.isActive = this.state.isGroupActive(this.handle);
        }
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        if (this.handle != null) {
            this.state.setGroupActive(this.handle, isActive);
        }
        this.isActive = isActive;
    }

    public boolean isCurrent() {
        if (this.handle != null) {
            this.isCurrent = this.state.isCurrentGroup(this.handle);
        }
        return this.isCurrent;
    }

    public void setCurrent(boolean isCurrent) {
        if (this.handle != null && isCurrent) {
            this.state.setCurrentGroup(this.handle);
        }
        this.isCurrent = isCurrent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceGroup)) {
            return false;
        }
        SourceGroup that = (SourceGroup)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.isActive != that.isActive) {
            return false;
        }
        if (this.isCurrent != that.isCurrent) {
            return false;
        }
        return this.sourceIds.equals(that.sourceIds);
    }

    public int hashCode() {
        int result = this.sourceIds.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.isActive ? 1 : 0);
        result = 31 * result + (this.isCurrent ? 1 : 0);
        return result;
    }
}

