/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.ImageDisplay;
import org.scijava.display.Display;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.display.event.input.MsWheelEvent;
import org.scijava.input.InputModifiers;
import org.scijava.input.KeyCode;
import org.scijava.plugin.Plugin;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.Tool;

@Plugin(type=Tool.class, name="Axis Position Shortcuts")
public class AxisPositionHandler
extends AbstractTool {
    public boolean isAlwaysActive() {
        return true;
    }

    public boolean isActiveInAppFrame() {
        return true;
    }

    public void onKeyDown(KyPressedEvent evt) {
        int delta;
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        KeyCode keyCode = evt.getCode();
        char keyChar = evt.getCharacter();
        if (keyCode == KeyCode.PERIOD || keyCode == KeyCode.GREATER || keyCode == KeyCode.KP_RIGHT || keyCode == KeyCode.RIGHT || keyChar == '>') {
            delta = evt.getModifiers().isAltDown() ? 10 : 1;
        } else if (keyCode == KeyCode.COMMA || keyCode == KeyCode.LESS || keyCode == KeyCode.KP_LEFT || keyCode == KeyCode.LEFT || keyChar == '<') {
            delta = evt.getModifiers().isAltDown() ? -10 : -1;
        } else {
            return;
        }
        AxisType axis = this.getAxis(imageDisplay, evt.getModifiers());
        if (axis == null) {
            return;
        }
        long pos = imageDisplay.getLongPosition(axis) + (long)delta;
        imageDisplay.setPosition(pos, axis);
        evt.consume();
    }

    public void onMouseWheel(MsWheelEvent evt) {
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        AxisType axis = this.getAxis(imageDisplay, evt.getModifiers());
        if (axis == null) {
            return;
        }
        int rotation = evt.getWheelRotation();
        long pos = imageDisplay.getLongPosition(axis) + (long)rotation;
        imageDisplay.setPosition(pos, axis);
        evt.consume();
    }

    private AxisType getAxis(ImageDisplay display, InputModifiers mods) {
        if (display.numDimensions() < 3) {
            return null;
        }
        AxisType axis = mods.isAltDown() || mods.isAltGrDown() ? Axes.TIME : (mods.isCtrlDown() || mods.isMetaDown() ? Axes.Z : Axes.CHANNEL);
        if (display.dimensionIndex(axis) < 0) {
            return ((CalibratedAxis)display.axis(2)).type();
        }
        return axis;
    }
}

