/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.visitor;

import java.io.File;
import org.janelia.thickness.inference.visitor.Visitor;

public abstract class FileSaverVisitor
implements Visitor {
    protected String basePath;
    protected String relativeFilePattern;

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getRelativeFilePattern() {
        return this.relativeFilePattern;
    }

    public void setRelativeFilePattern(String relativeFilePattern) {
        this.relativeFilePattern = relativeFilePattern;
    }

    public void setRelativeFilePattern(String base, int maxIteration, String extension) {
        int length = String.valueOf(maxIteration).length();
        this.relativeFilePattern = String.format("%s%%0%dd%s", base, Math.max(length, 4), extension);
    }

    public FileSaverVisitor(String basePath, String relativeFilePattern) {
        this.basePath = basePath;
        this.relativeFilePattern = relativeFilePattern;
    }

    protected String fileDir(int iteration) {
        return String.format("%s/%s", this.basePath, String.format(this.relativeFilePattern, iteration));
    }

    protected void createParentDirectory(String path) {
        new File(path).getParentFile().mkdirs();
    }
}

