/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import net.imagej.ui.swing.updater.SwingTools;
import net.imagej.ui.swing.updater.UpdaterFrame;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.GroupAction;
import net.imagej.updater.UpdateSite;

public class FileTable
extends JTable {
    protected UpdaterFrame updaterFrame;
    protected FilesCollection files;
    protected List<FileObject> row2file;
    private FileTableModel fileTableModel;
    protected Font plain;
    protected Font bold;
    static final int NAME_COLUMN = 0;
    static final int ACTION_COLUMN = 1;
    static final int SITE_COLUMN = 2;

    public FileTable(UpdaterFrame updaterFrame) {
        this.updaterFrame = updaterFrame;
        this.files = updaterFrame.files;
        this.row2file = new ArrayList<FileObject>();
        for (FileObject file : this.files) {
            this.row2file.add(file);
        }
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoResizeMode(4);
        this.setRequestFocusEnabled(false);
        this.setSelectionMode(2);
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        final JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                popupMenu.removeAll();
                FileTable.this.populatePopupMenu(FileTable.this.getSelectedFiles(), popupMenu);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
                popupMenu.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }
        });
        this.setComponentPopupMenu(popupMenu);
        this.fileTableModel = new FileTableModel(this.files);
        this.setModel(this.fileTableModel);
        this.getModel().addTableModelListener(this);
        this.setColumnWidths();
        TableRowSorter<FileTableModel> sorter = new TableRowSorter<FileTableModel>(this.fileTableModel);
        sorter.setComparator(1, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        this.setRowSorter(sorter);
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                FileTable.this.setStyle(comp, row, column);
                return comp;
            }
        });
    }

    protected void setStyle(Component comp, int row, int column) {
        FileObject file;
        if (this.plain == null) {
            this.plain = comp.getFont();
            this.bold = this.plain.deriveFont(1);
        }
        if ((file = this.getFile(row)) == null) {
            return;
        }
        comp.setFont(file.actionSpecified() || file.isLocallyModified() ? this.bold : this.plain);
        if (file.getStatus() == FileObject.Status.OBSOLETE_MODIFIED) {
            comp.setForeground(Color.RED);
        }
    }

    private void setColumnWidths() {
        TableColumn nameColumn = this.getColumnModel().getColumn(0);
        TableColumn actionColumn = this.getColumnModel().getColumn(1);
        TableColumn siteColumn = this.getColumnModel().getColumn(2);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        nameColumn.setPreferredWidth(fm.stringWidth("jars/imagej-plugins-commands"));
        nameColumn.setMinWidth(fm.stringWidth("jars/bij.jar"));
        nameColumn.setResizable(true);
        actionColumn.setPreferredWidth(fm.stringWidth("Locally modified "));
        actionColumn.setMinWidth(fm.stringWidth("Up-to-date"));
        actionColumn.setResizable(true);
        siteColumn.setPreferredWidth(fm.stringWidth("BigVolumeViewer Demo"));
        siteColumn.setMinWidth(fm.stringWidth("Fiji"));
        siteColumn.setResizable(true);
    }

    public FilesCollection getAllFiles() {
        return this.files;
    }

    public void setFiles(Iterable<FileObject> files) {
        this.fileTableModel.setFiles(files);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        FileObject file = this.getFile(row);
        if (col == 0) {
            return super.getCellEditor(row, col);
        }
        Set actions = this.files.getValidActions(Collections.singleton(file));
        return new DefaultCellEditor(new JComboBox<Object>(actions.toArray()));
    }

    private void populatePopupMenu(Iterable<FileObject> selected, JPopupMenu menu) {
        int count = 0;
        for (GroupAction action : this.files.getValidActions(selected)) {
            JMenuItem item = new JMenuItem(action.getLabel(this.files, selected));
            item.addActionListener(e -> {
                for (FileObject file : selected) {
                    action.setAction(this.files, file);
                    this.fireFileChanged(file);
                }
            });
            menu.add(item);
            ++count;
        }
        if (count == 0) {
            JMenuItem noActions = new JMenuItem("<No common actions>");
            noActions.setEnabled(false);
            menu.add(noActions);
        }
    }

    public FileObject getFile(int viewRow) {
        return this.getFileFromModel(this.convertRowIndexToModel(viewRow));
    }

    private FileObject getFileFromModel(int modelRow) {
        return this.fileTableModel.rowToFile.get(modelRow);
    }

    public Iterable<FileObject> getSelectedFiles() {
        return this.getSelectedFiles(-1);
    }

    public Iterable<FileObject> getSelectedFiles(int fallbackRow) {
        int[] rows = this.getSelectedRows();
        if (fallbackRow >= 0 && this.getFile(fallbackRow) != null && (rows.length == 0 || this.indexOf(rows, fallbackRow) < 0)) {
            rows = new int[]{fallbackRow};
        }
        FileObject[] result = new FileObject[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            result[i] = this.getFile(rows[i]);
        }
        return Arrays.asList(result);
    }

    protected int indexOf(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean areAllSelectedFilesUploadable() {
        if (this.getSelectedRows().length == 0) {
            return false;
        }
        for (FileObject file : this.getSelectedFiles()) {
            if (file.isUploadable(this.updaterFrame.files, true)) continue;
            return false;
        }
        return true;
    }

    public boolean chooseUpdateSite(FilesCollection files, FileObject file) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : files.getUpdateSiteNames(false)) {
            UpdateSite site = files.getUpdateSite(name, true);
            if (!site.isUploadable()) continue;
            list.add(name);
        }
        if (list.size() == 0) {
            this.error("No upload site available");
            return false;
        }
        if (list.size() == 1 && ((String)list.get(0)).equals("ImageJ")) {
            file.updateSite = "ImageJ";
            return true;
        }
        String updateSite = SwingTools.getChoice(this.updaterFrame, list, "To which upload site do you want to upload " + file.filename + "?", "Upload site");
        if (updateSite == null) {
            return false;
        }
        file.updateSite = updateSite;
        return true;
    }

    public void fireFileChanged(FileObject file) {
        this.fileTableModel.fireFileChanged(file);
    }

    protected void error(String message) {
        SwingTools.showMessageBox(this.updaterFrame, message, 0);
    }

    protected class FileTableModel
    extends AbstractTableModel {
        private FilesCollection files;
        protected Map<FileObject, Integer> fileToRow;
        protected List<FileObject> rowToFile;

        public FileTableModel(FilesCollection files) {
            this.files = files;
        }

        public void setFiles(Iterable<FileObject> files) {
            this.setFiles(this.files.clone(files));
        }

        public void setFiles(FilesCollection files) {
            this.files = files;
            this.fileToRow = null;
            this.rowToFile = null;
            this.updateMappings();
            this.fireTableChanged(new TableModelEvent(FileTable.this.fileTableModel));
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 2: {
                    return String.class;
                }
                case 1: {
                    return FileObject.Action.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Status/Action";
                }
                case 2: {
                    return "Update Site";
                }
            }
            throw new Error("Column out of range");
        }

        public FileObject getEntry(int rowIndex) {
            return this.rowToFile.get(rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.files.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            this.updateMappings();
            if (row < 0 || row >= this.files.size()) {
                return null;
            }
            FileObject file = this.rowToFile.get(row);
            switch (column) {
                case 0: {
                    return file.getFilename(true);
                }
                case 1: {
                    return file.getAction();
                }
                case 2: {
                    return file.updateSite;
                }
            }
            throw new RuntimeException("Unhandled column: " + column);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (column == 1) {
                GroupAction action = (GroupAction)value;
                FileObject file = FileTable.this.getFileFromModel(row);
                action.setAction(this.files, file);
                this.fireFileChanged(file);
            }
        }

        public void fireRowChanged(int row) {
            this.fireTableRowsUpdated(row, row);
        }

        public void fireFileChanged(FileObject file) {
            this.updateMappings();
            Integer row = this.fileToRow.get(file);
            if (row != null) {
                this.fireRowChanged(row);
            }
        }

        protected void updateMappings() {
            if (this.fileToRow != null) {
                return;
            }
            this.fileToRow = new HashMap<FileObject, Integer>();
            this.rowToFile = new ArrayList<FileObject>();
            int i = 0;
            for (FileObject f : this.files) {
                this.fileToRow.put(f, new Integer(i++));
                this.rowToFile.add(f);
            }
        }
    }
}

