/*
 * Decompiled with CFR 0.152.
 */
package register_virtual_stack;

import bunwarpj.Transformation;
import bunwarpj.bUnwarpJ_;
import bunwarpj.trakem2.transform.CubicBSplineTransform;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JFileChooser;
import loci.formats.FormatException;
import loci.plugins.BF;
import mpicbg.ij.FeatureTransform;
import mpicbg.ij.SIFT;
import mpicbg.ij.util.Util;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.trakem2.transform.AffineModel2D;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.MovingLeastSquaresTransform;
import mpicbg.trakem2.transform.RigidModel2D;
import mpicbg.trakem2.transform.SimilarityModel2D;
import mpicbg.trakem2.transform.TransformMesh;
import mpicbg.trakem2.transform.TransformMeshMapping;
import mpicbg.trakem2.transform.TranslationModel2D;
import sc.fiji.io.DM3_Reader;

public class Register_Virtual_Stack_MT
implements PlugIn {
    public static final int TRANSLATION = 0;
    public static final int RIGID = 1;
    public static final int SIMILARITY = 2;
    public static final int AFFINE = 3;
    public static final int ELASTIC = 4;
    public static final int MOVING_LEAST_SQUARES = 5;
    public static int featuresModelIndex = 1;
    public static int registrationModelIndex = 1;
    public static String currentDirectory = OpenDialog.getLastDirectory() == null ? OpenDialog.getDefaultDirectory() : OpenDialog.getLastDirectory();
    public static boolean advanced = false;
    public static boolean non_shrinkage = false;
    public static boolean save_transforms = false;
    public static String sourceDirectory = "";
    public static String outputDirectory = "";
    public static double tweakScale = 0.95;
    public static double tweakShear = 0.95;
    public static double tweakIso = 0.95;
    public static boolean displayRelaxGraph = false;
    private static double[] centerX = null;
    private static double[] centerY = null;
    public static boolean postprocess = true;
    private static boolean debug = false;
    public static final String[] registrationModelStrings = new String[]{"Translation          -- no deformation                      ", "Rigid                -- translate + rotate                  ", "Similarity           -- translate + rotate + isotropic scale", "Affine               -- free affine transform               ", "Elastic              -- bUnwarpJ splines                    ", "Moving least squares -- maximal warping                     "};
    public static final String[] featuresModelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine"};
    public static final float STOP_THRESHOLD = 0.01f;
    public static final int MAX_ITER = 300;
    public static final String exts = ".tif.jpg.png.gif.tiff.jpeg.bmp.pgm.ima.dm3.dm4";

    public void run(String arg) {
        String target_dir;
        GenericDialogPlus gd = new GenericDialogPlus("Register Virtual Stack");
        gd.addDirectoryField("Source directory", sourceDirectory, 50);
        gd.addDirectoryField("Output directory", outputDirectory, 50);
        gd.addChoice("Feature extraction model: ", featuresModelStrings, featuresModelStrings[featuresModelIndex]);
        gd.addChoice("Registration model: ", registrationModelStrings, registrationModelStrings[registrationModelIndex]);
        gd.addCheckbox("Advanced setup", advanced);
        gd.addCheckbox("Shrinkage constrain", non_shrinkage);
        gd.addCheckbox("Save transforms", save_transforms);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        sourceDirectory = gd.getNextString();
        outputDirectory = gd.getNextString();
        featuresModelIndex = gd.getNextChoiceIndex();
        registrationModelIndex = gd.getNextChoiceIndex();
        advanced = gd.getNextBoolean();
        non_shrinkage = gd.getNextBoolean();
        save_transforms = gd.getNextBoolean();
        String source_dir = sourceDirectory;
        if (null == source_dir) {
            IJ.error((String)"Error: No source directory was provided.");
            return;
        }
        if (!new File(source_dir).exists()) {
            IJ.error((String)("Error: source directory " + source_dir + " does not exist."));
            return;
        }
        if (!(source_dir = source_dir.replace('\\', '/')).endsWith("/")) {
            source_dir = source_dir + "/";
        }
        if (null == (target_dir = outputDirectory)) {
            IJ.error((String)"Error: No output directory was provided.");
            return;
        }
        if (!new File(target_dir).exists()) {
            IJ.error((String)("Error: output directory " + target_dir + " does not exist."));
            return;
        }
        if (!(target_dir = target_dir.replace('\\', '/')).endsWith("/")) {
            target_dir = target_dir + "/";
        }
        String save_dir = null;
        if (save_transforms) {
            JFileChooser chooser = new JFileChooser(source_dir);
            chooser.setDialogTitle("Choose directory to store Transform files");
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(true);
            if (chooser.showOpenDialog(null) != 0) {
                return;
            }
            save_dir = chooser.getSelectedFile().toString();
            if (null == save_dir) {
                return;
            }
            if (!(save_dir = save_dir.replace('\\', '/')).endsWith("/")) {
                save_dir = save_dir + "/";
            }
        }
        String referenceName = null;
        if (!non_shrinkage) {
            if (Prefs.useJFileChooser) {
                JFileChooser chooser = new JFileChooser(source_dir);
                chooser.setDialogTitle("Choose reference image");
                chooser.setFileSelectionMode(0);
                chooser.setAcceptAllFileFilterUsed(true);
                if (chooser.showOpenDialog(null) != 0) {
                    return;
                }
                referenceName = chooser.getSelectedFile().getName();
            } else {
                FileDialog fd = new FileDialog((Frame)null, "Open", 0);
                fd.setDirectory(source_dir);
                fd.setVisible(true);
                referenceName = fd.getFile();
            }
        }
        Register_Virtual_Stack_MT.exec(source_dir, target_dir, save_dir, referenceName, featuresModelIndex, registrationModelIndex, advanced, non_shrinkage);
    }

    public static void exec(String source_dir, String target_dir, String save_dir, String referenceName, int featuresModelIndex, int registrationModelIndex, boolean advanced, boolean non_shrink) {
        Param p = new Param();
        Param.featuresModelIndex = featuresModelIndex;
        Param.registrationModelIndex = registrationModelIndex;
        if (non_shrink) {
            p.elastic_param.divWeight = 0.1;
            p.elastic_param.curlWeight = 0.1;
            p.elastic_param.landmarkWeight = 1.0;
            p.elastic_param.consistencyWeight = 0.0;
            p.elastic_param.imageWeight = 0.0;
        }
        if (advanced && !p.showDialog()) {
            return;
        }
        if (non_shrink && advanced && Param.registrationModelIndex != 0 && !Register_Virtual_Stack_MT.showRegularizationDialog(p)) {
            return;
        }
        Register_Virtual_Stack_MT.exec(source_dir, target_dir, save_dir, referenceName, p, non_shrink);
    }

    public static void exec(String source_dir, String target_dir, String save_dir, String referenceName, Param p, boolean non_shrink) {
        if (!new File(source_dir).exists()) {
            IJ.error((String)("Error: source directory " + source_dir + " does not exist."));
            return;
        }
        if (!new File(target_dir).exists()) {
            IJ.error((String)("Error: output directory " + target_dir + " does not exist."));
            return;
        }
        if (null != save_dir && !new File(save_dir).exists()) {
            IJ.error((String)("Error: transforms directory " + save_dir + " does not exist."));
            return;
        }
        if (null != referenceName && !new File(source_dir + referenceName).exists()) {
            IJ.error((String)("Error: reference image " + source_dir + referenceName + " does not exist."));
            return;
        }
        Object[] names = new File(source_dir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int idot = name.lastIndexOf(46);
                if (-1 == idot) {
                    return false;
                }
                return Register_Virtual_Stack_MT.exts.contains(name.substring(idot).toLowerCase());
            }
        });
        Arrays.sort(names);
        if (non_shrink) {
            Register_Virtual_Stack_MT.exec(source_dir, (String[])names, target_dir, save_dir, p);
            return;
        }
        int referenceIndex = -1;
        for (int i = 0; i < names.length; ++i) {
            if (!((String)names[i]).equals(referenceName)) continue;
            referenceIndex = i;
            break;
        }
        if (referenceIndex == -1) {
            IJ.error((String)"The reference image was not found in the source folder!");
            return;
        }
        Register_Virtual_Stack_MT.exec(source_dir, (String[])names, referenceIndex, target_dir, save_dir, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exec(String source_dir, String[] sorted_file_names, String target_dir, String save_dir, Param p) {
        TranslationModel2D featuresModel;
        if (source_dir.equals(target_dir)) {
            IJ.error((String)"Source and target directories MUST be different\n or images would get overwritten.\nDid NOT register stack slices.");
            return;
        }
        if (Param.registrationModelIndex < 0 || Param.registrationModelIndex > 5) {
            IJ.error((String)("Don't know how to process registration type " + Param.registrationModelIndex));
            return;
        }
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        switch (Param.featuresModelIndex) {
            case 0: {
                featuresModel = new TranslationModel2D();
                break;
            }
            case 1: {
                featuresModel = new RigidModel2D();
                break;
            }
            case 2: {
                featuresModel = new SimilarityModel2D();
                break;
            }
            case 3: {
                featuresModel = new AffineModel2D();
                break;
            }
            default: {
                IJ.error((String)("ERROR: unknown featuresModelIndex = " + Param.featuresModelIndex));
                return;
            }
        }
        ArrayList[] inliers = new ArrayList[sorted_file_names.length - 1];
        mpicbg.trakem2.transform.CoordinateTransform[] transform = new mpicbg.trakem2.transform.CoordinateTransform[sorted_file_names.length];
        centerX = new double[sorted_file_names.length];
        centerY = new double[sorted_file_names.length];
        transform[0] = new RigidModel2D();
        ArrayList[] fs = new ArrayList[sorted_file_names.length];
        Future[] fu = new Future[sorted_file_names.length];
        try {
            int i;
            int i2;
            for (i2 = 0; i2 < sorted_file_names.length; ++i2) {
                IJ.showStatus((String)"Extracting features from slices...");
                fu[i2] = exe.submit(Register_Virtual_Stack_MT.extractFeatures(p, source_dir + sorted_file_names[i2], i2));
            }
            System.gc();
            for (i2 = 0; i2 < sorted_file_names.length; ++i2) {
                IJ.showStatus((String)("Extracting features " + (i2 + 1) + "/" + sorted_file_names.length));
                IJ.showProgress((double)((double)(i2 + 1) / (double)sorted_file_names.length));
                fs[i2] = (ArrayList)fu[i2].get();
                fu[i2] = null;
            }
            fu = null;
            exe.shutdown();
            exe = Executors.newFixedThreadPool(Prefs.getThreads());
            Future[] fpm = new Future[sorted_file_names.length - 1];
            for (i = 1; i < sorted_file_names.length; ++i) {
                IJ.showStatus((String)"Matching features...");
                try {
                    fpm[i - 1] = exe.submit(Register_Virtual_Stack_MT.matchFeatures(p, fs[i], fs[i - 1], featuresModel));
                    continue;
                }
                catch (NotEnoughDataPointsException e) {
                    IJ.log((String)("No features model found for file " + i + ": " + sorted_file_names[i]));
                    if (Param.registrationModelIndex == 4) continue;
                    IJ.error((String)("No features model found for file " + i + ": " + sorted_file_names[i]));
                    IJ.showProgress((double)1.0);
                    IJ.showStatus((String)"Done!");
                    exe.shutdownNow();
                    return;
                }
            }
            for (i = 1; i < sorted_file_names.length; ++i) {
                IJ.showStatus((String)("Matching features " + (i + 1) + "/" + sorted_file_names.length));
                IJ.showProgress((double)((double)(i + 1) / (double)sorted_file_names.length));
                inliers[i - 1] = (List)fpm[i - 1].get();
                fs[i - 1].clear();
                if (inliers[i - 1].size() >= 2) continue;
                IJ.log((String)("Error: not model found for images " + sorted_file_names[i - 1] + " and " + sorted_file_names[i]));
            }
            fs[sorted_file_names.length - 1].clear();
            fs = null;
            exe.shutdown();
            System.gc();
            for (i = 1; i < sorted_file_names.length; ++i) {
                IJ.showStatus((String)("Registering slice " + (i + 1) + "/" + sorted_file_names.length));
                IJ.showProgress((double)((double)(i + 1) / (double)sorted_file_names.length));
                TranslationModel2D initialModel = Param.registrationModelIndex == 0 ? new TranslationModel2D() : new RigidModel2D();
                inliers[i - 1] = Register_Virtual_Stack_MT.applyTransformReverse(inliers[i - 1], transform[i - 1]);
                if (Param.registrationModelIndex == 0) {
                    initialModel.fit((Collection)inliers[i - 1]);
                } else {
                    ((RigidModel2D)initialModel).fit((Collection)inliers[i - 1]);
                }
                transform[i] = initialModel;
            }
            PointMatch.apply((Collection)inliers[inliers.length - 1], (CoordinateTransform)transform[transform.length - 1]);
            if (Param.registrationModelIndex != 0) {
                IJ.showStatus((String)"Relaxing inliers...");
                if (!Register_Virtual_Stack_MT.relax(inliers, transform, p)) {
                    IJ.log((String)"Error when relaxing inliers!");
                    return;
                }
                for (i = 0; i < inliers.length; ++i) {
                    inliers[i].clear();
                }
                inliers = null;
                if (postprocess) {
                    Register_Virtual_Stack_MT.postProcessTransforms(transform);
                }
            }
            IJ.showStatus((String)"Calculating final images...");
            if (!Register_Virtual_Stack_MT.createResults(source_dir, sorted_file_names, target_dir, save_dir, transform, Param.interpolate)) {
                IJ.log((String)"Error when creating target images");
                return;
            }
        }
        catch (Exception e) {
            IJ.error((String)("ERROR: " + e));
            e.printStackTrace();
        }
        finally {
            IJ.showProgress((double)1.0);
            IJ.showStatus((String)"Done!");
            exe.shutdownNow();
        }
    }

    public static List<PointMatch> applyTransformReverse(List<PointMatch> list, mpicbg.trakem2.transform.CoordinateTransform t) {
        List new_list = (List)PointMatch.flip(list);
        PointMatch.apply((Collection)new_list, (CoordinateTransform)t);
        new_list = (List)PointMatch.flip((Collection)new_list);
        return new_list;
    }

    public static boolean relax(List<PointMatch>[] inliers, mpicbg.trakem2.transform.CoordinateTransform[] transform, Param p) {
        boolean display = displayRelaxGraph;
        int n_iterations = 0;
        float[] mean_distance = new float[301];
        for (int iSlice = 0; iSlice < inliers.length; ++iSlice) {
            mean_distance[0] = (float)((double)mean_distance[0] + PointMatch.meanDistance(inliers[iSlice]));
        }
        mean_distance[0] = mean_distance[0] / (float)inliers.length;
        int[] index = new int[inliers.length + 1];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        for (int n = 0; n < 300; ++n) {
            ++n_iterations;
            Register_Virtual_Stack_MT.randomize(index);
            for (int j = 0; j < index.length; ++j) {
                int iSlice = index[j];
                mpicbg.trakem2.transform.CoordinateTransform t = Register_Virtual_Stack_MT.getCoordinateTransform(p);
                if (t instanceof CubicBSplineTransform) {
                    ((CubicBSplineTransform)t).set(p.elastic_param, (int)centerX[j] * 2, (int)centerY[j] * 2, (int)centerX[j] * 2, (int)centerY[j] * 2);
                }
                if (iSlice == 0) {
                    ArrayList<PointMatch> firstMatches = new ArrayList<PointMatch>();
                    PointMatch.flip(inliers[0], firstMatches);
                    try {
                        Register_Virtual_Stack_MT.fitInliers(p, t, firstMatches);
                        Register_Virtual_Stack_MT.regularize(t, 0);
                        inliers[0] = Register_Virtual_Stack_MT.applyTransformReverse(inliers[0], t);
                        transform[0] = t;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        IJ.error((String)"Error when relaxing first matches...");
                        return false;
                    }
                }
                ArrayList<PointMatch> combined_inliers = new ArrayList<PointMatch>(inliers[iSlice - 1]);
                if (iSlice - 1 < inliers.length - 1) {
                    ArrayList flippedMatches = new ArrayList();
                    PointMatch.flip(inliers[iSlice], flippedMatches);
                    for (PointMatch match : flippedMatches) {
                        combined_inliers.add(match);
                    }
                }
                try {
                    Register_Virtual_Stack_MT.fitInliers(p, t, combined_inliers);
                    Register_Virtual_Stack_MT.regularize(t, iSlice);
                    PointMatch.apply(inliers[iSlice - 1], (CoordinateTransform)t);
                    if (iSlice - 1 < inliers.length - 1) {
                        inliers[iSlice] = Register_Virtual_Stack_MT.applyTransformReverse(inliers[iSlice], t);
                    }
                    transform[iSlice] = t;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IJ.error((String)"Error when relaxing...");
                    return false;
                }
            }
            mean_distance[n + 1] = 0.0f;
            for (int k = 0; k < inliers.length; ++k) {
                int n2 = n + 1;
                mean_distance[n2] = (float)((double)mean_distance[n2] + PointMatch.meanDistance(inliers[k]));
            }
            int n3 = n + 1;
            mean_distance[n3] = mean_distance[n3] / (float)inliers.length;
            if (Math.abs(mean_distance[n + 1] - mean_distance[n]) < 0.01f) break;
        }
        if (display) {
            float[] x_label = new float[n_iterations + 1];
            for (int i = 0; i < x_label.length; ++i) {
                x_label[i] = i;
            }
            float[] distance = new float[n_iterations + 1];
            for (int i = 0; i < distance.length; ++i) {
                distance[i] = mean_distance[i];
            }
            Plot pl = new Plot("Mean distance", "iterations", "MSE", x_label, distance);
            pl.setColor(Color.MAGENTA);
            pl.show();
        }
        return true;
    }

    public static void randomize(int[] array) {
        Random generator = new Random();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            int randomIndex1 = generator.nextInt(n);
            int randomIndex2 = generator.nextInt(n);
            int aux = array[randomIndex1];
            array[randomIndex1] = array[randomIndex2];
            array[randomIndex2] = aux;
        }
    }

    public static boolean createResults(String source_dir, String[] sorted_file_names, String target_dir, String save_dir, mpicbg.trakem2.transform.CoordinateTransform[] transform, boolean interpolate) {
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ImagePlus first = Register_Virtual_Stack_MT.readImage(source_dir + sorted_file_names[0]);
        Rectangle commonBounds = new Rectangle(0, 0, first.getWidth(), first.getHeight());
        Register_Virtual_Stack_MT.flush(first);
        Rectangle[] bounds = new Rectangle[sorted_file_names.length];
        ArrayList<Future<Boolean>> save_job = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < sorted_file_names.length; ++i) {
            save_job.add(exe.submit(Register_Virtual_Stack_MT.applyTransformAndSave(source_dir, sorted_file_names[i], target_dir, transform[i], bounds, interpolate, i)));
        }
        int ind = 0;
        Iterator it = save_job.iterator();
        while (it.hasNext()) {
            ++ind;
            Boolean saved_file = null;
            try {
                IJ.showStatus((String)("Applying transform " + (ind + 1) + "/" + sorted_file_names.length));
                saved_file = (Boolean)((Future)it.next()).get();
                System.gc();
            }
            catch (InterruptedException e) {
                IJ.error((String)"Interruption exception!");
                e.printStackTrace();
                exe.shutdownNow();
                return false;
            }
            catch (ExecutionException e) {
                IJ.error((String)"Execution exception!");
                e.printStackTrace();
                exe.shutdownNow();
                return false;
            }
            if (saved_file.booleanValue()) continue;
            IJ.log((String)("Error while saving: " + Register_Virtual_Stack_MT.makeTargetPath(target_dir, sorted_file_names[ind])));
            exe.shutdownNow();
            return false;
        }
        exe.shutdown();
        save_job = null;
        for (int k = 0; k < sorted_file_names.length; ++k) {
            int min_x = commonBounds.x;
            int min_y = commonBounds.y;
            int max_x = commonBounds.x + commonBounds.width;
            int max_y = commonBounds.y + commonBounds.height;
            if (bounds[k].x < commonBounds.x) {
                min_x = bounds[k].x;
            }
            if (bounds[k].y < commonBounds.y) {
                min_y = bounds[k].y;
            }
            if (bounds[k].x + bounds[k].width > max_x) {
                max_x = bounds[k].x + bounds[k].width;
            }
            if (bounds[k].y + bounds[k].height > max_y) {
                max_y = bounds[k].y + bounds[k].height;
            }
            commonBounds.x = min_x;
            commonBounds.y = min_y;
            commonBounds.width = max_x - min_x;
            commonBounds.height = max_y - min_y;
        }
        for (int i = 0; i < bounds.length; ++i) {
            Rectangle b = bounds[i];
            b.x -= commonBounds.x;
            b.y -= commonBounds.y;
        }
        exe = Executors.newFixedThreadPool(Prefs.getThreads());
        IJ.showStatus((String)"Resizing images...");
        ArrayList<Future<String>> names = new ArrayList<Future<String>>();
        for (int i = 0; i < sorted_file_names.length; ++i) {
            Rectangle b = bounds[i];
            names.add(exe.submit(Register_Virtual_Stack_MT.resizeAndSaveImage(Register_Virtual_Stack_MT.makeTargetPath(target_dir, sorted_file_names[i]), b.x, b.y, commonBounds.width, commonBounds.height)));
        }
        VirtualStack stack = new VirtualStack(commonBounds.width, commonBounds.height, null, target_dir);
        ind = 0;
        Iterator it1 = names.iterator();
        while (it1.hasNext()) {
            String filename = null;
            try {
                IJ.showStatus((String)("Resizing image " + (ind + 1) + "/" + sorted_file_names.length));
                filename = (String)((Future)it1.next()).get();
                System.gc();
            }
            catch (InterruptedException e) {
                IJ.error((String)"Interruption exception!");
                e.printStackTrace();
                return false;
            }
            catch (ExecutionException e) {
                IJ.error((String)"Execution exception!");
                e.printStackTrace();
                return false;
            }
            if (null == filename) {
                IJ.log((String)("Image failed: " + filename));
                return false;
            }
            stack.addSlice(filename);
            ++ind;
        }
        names.clear();
        exe.shutdown();
        if (IJ.getInstance() != null) {
            new ImagePlus("Registered " + new File(source_dir).getName(), (ImageStack)stack).show();
        }
        if (save_dir != null) {
            Register_Virtual_Stack_MT.saveTransforms(transform, save_dir, sorted_file_names);
        }
        IJ.showStatus((String)"Done!");
        return true;
    }

    private static boolean saveTransforms(mpicbg.trakem2.transform.CoordinateTransform[] transform, String save_dir, String[] sorted_file_names) {
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        Future[] jobs = new Future[transform.length];
        for (int i = 0; i < transform.length; ++i) {
            jobs[i] = exe.submit(Register_Virtual_Stack_MT.saveTransform(Register_Virtual_Stack_MT.makeTransformPath(save_dir, sorted_file_names[i]), transform[i]));
        }
        for (Future job : jobs) {
            String filename = null;
            try {
                filename = (String)job.get();
            }
            catch (InterruptedException e) {
                IJ.error((String)"Interruption exception!");
                e.printStackTrace();
                exe.shutdownNow();
                return false;
            }
            catch (ExecutionException e) {
                IJ.error((String)"Execution exception!");
                e.printStackTrace();
                exe.shutdownNow();
                return false;
            }
            if (null != filename) continue;
            IJ.log((String)("Not able to save file: " + filename));
            exe.shutdownNow();
            return false;
        }
        exe.shutdown();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exec(String source_dir, String[] sorted_file_names, int referenceIndex, String target_dir, String save_dir, Param p) {
        if (source_dir.equals(target_dir)) {
            IJ.error((String)"Source and target directories MUST be different\n or images would get overwritten.\nDid NOT register stack slices.");
            return;
        }
        if (Param.registrationModelIndex < 0 || Param.registrationModelIndex > 5) {
            IJ.error((String)("Don't know how to process registration type " + Param.registrationModelIndex));
            return;
        }
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        try {
            Rectangle b;
            TranslationModel2D tr;
            CoordinateTransformList ctl;
            Rectangle b2;
            int i;
            ImagePlus imp1 = null;
            ImagePlus imp2 = Register_Virtual_Stack_MT.readImage(source_dir + sorted_file_names[referenceIndex]);
            imp2.killRoi();
            ImagePlus imp1mask = new ImagePlus();
            ImagePlus imp2mask = new ImagePlus();
            Rectangle commonBounds = new Rectangle(0, 0, imp2.getWidth(), imp2.getHeight());
            ArrayList<Rectangle> boundsFor = new ArrayList<Rectangle>();
            boundsFor.add(new Rectangle(0, 0, imp2.getWidth(), imp2.getHeight()));
            new FileSaver(imp2).saveAsTiff(Register_Virtual_Stack_MT.makeTargetPath(target_dir, sorted_file_names[referenceIndex]));
            mpicbg.trakem2.transform.CoordinateTransform[] transform = new mpicbg.trakem2.transform.CoordinateTransform[sorted_file_names.length];
            for (int i2 = referenceIndex + 1; i2 < sorted_file_names.length; ++i2) {
                imp1 = imp2;
                imp1mask = imp2mask;
                imp2mask = new ImagePlus();
                imp2 = Register_Virtual_Stack_MT.readImage(source_dir + sorted_file_names[i2]);
                imp2.killRoi();
                mpicbg.trakem2.transform.CoordinateTransform t = Register_Virtual_Stack_MT.getCoordinateTransform(p);
                if (!Register_Virtual_Stack_MT.register(imp1, imp2, imp1mask, imp2mask, i2, sorted_file_names, source_dir, target_dir, exe, p, t, commonBounds, boundsFor, referenceIndex)) {
                    return;
                }
                transform[i2] = t;
            }
            imp2 = null;
            imp2mask = new ImagePlus();
            transform[referenceIndex] = new AffineModel2D();
            imp2 = Register_Virtual_Stack_MT.readImage(source_dir + sorted_file_names[referenceIndex]);
            ArrayList<Rectangle> boundsBack = new ArrayList<Rectangle>();
            boundsBack.add(new Rectangle(0, 0, imp2.getWidth(), imp2.getHeight()));
            for (i = referenceIndex - 1; i >= 0; --i) {
                imp1 = imp2;
                imp1mask = imp2mask;
                imp2mask = new ImagePlus();
                imp2 = Register_Virtual_Stack_MT.readImage(source_dir + sorted_file_names[i]);
                imp2.killRoi();
                mpicbg.trakem2.transform.CoordinateTransform t = Register_Virtual_Stack_MT.getCoordinateTransform(p);
                if (!Register_Virtual_Stack_MT.register(imp1, imp2, imp1mask, imp2mask, i, sorted_file_names, source_dir, target_dir, exe, p, t, commonBounds, boundsBack, referenceIndex)) {
                    return;
                }
                transform[i] = t;
            }
            i = 1;
            int j = referenceIndex + 1;
            while (i < boundsFor.size()) {
                b2 = (Rectangle)boundsFor.get(i - 1);
                ctl = new CoordinateTransformList();
                ctl.add((CoordinateTransform)transform[j]);
                tr = new TranslationModel2D();
                tr.set((double)b2.x, (double)b2.y);
                ctl.add((CoordinateTransform)tr);
                transform[j] = ctl;
                ++i;
                ++j;
            }
            i = 1;
            j = referenceIndex - 1;
            while (i < boundsBack.size()) {
                b2 = (Rectangle)boundsBack.get(i - 1);
                ctl = new CoordinateTransformList();
                ctl.add((CoordinateTransform)transform[j]);
                tr = new TranslationModel2D();
                tr.set((double)b2.x, (double)b2.y);
                ctl.add((CoordinateTransform)tr);
                transform[j] = ctl;
                ++i;
                --j;
            }
            for (i = 0; i < boundsFor.size(); ++i) {
                Rectangle b3 = (Rectangle)boundsFor.get(i);
                b3.x -= commonBounds.x;
                b3.y -= commonBounds.y;
            }
            for (i = 0; i < boundsBack.size(); ++i) {
                Rectangle b4 = (Rectangle)boundsBack.get(i);
                b4.x -= commonBounds.x;
                b4.y -= commonBounds.y;
            }
            Future[] jobs = new Future[sorted_file_names.length];
            j = 0;
            int i3 = referenceIndex;
            while (i3 < sorted_file_names.length) {
                b = (Rectangle)boundsFor.get(j);
                jobs[i3] = exe.submit(Register_Virtual_Stack_MT.resizeAndSaveImage(Register_Virtual_Stack_MT.makeTargetPath(target_dir, sorted_file_names[i3]), b.x, b.y, commonBounds.width, commonBounds.height));
                ++i3;
                ++j;
            }
            j = 1;
            i3 = referenceIndex - 1;
            while (i3 >= 0) {
                b = (Rectangle)boundsBack.get(j);
                jobs[i3] = exe.submit(Register_Virtual_Stack_MT.resizeAndSaveImage(Register_Virtual_Stack_MT.makeTargetPath(target_dir, sorted_file_names[i3]), b.x, b.y, commonBounds.width, commonBounds.height));
                --i3;
                ++j;
            }
            VirtualStack stack = new VirtualStack(commonBounds.width, commonBounds.height, null, target_dir);
            for (Future job : jobs) {
                String filename = (String)job.get();
                if (null == filename) {
                    IJ.log((String)("Image failed: " + filename));
                    return;
                }
                stack.addSlice(filename);
            }
            if (save_dir != null) {
                Register_Virtual_Stack_MT.saveTransforms(transform, save_dir, sorted_file_names);
            }
            if (IJ.getInstance() != null) {
                new ImagePlus("Registered " + new File(source_dir).getName(), (ImageStack)stack).show();
            }
            IJ.showStatus((String)"Done!");
        }
        catch (Exception e) {
            IJ.error((String)("ERROR: " + e));
            e.printStackTrace();
        }
        finally {
            IJ.showProgress((double)1.0);
            exe.shutdownNow();
        }
    }

    private static Callable<String> resizeAndSaveImage(final String path, final int x, final int y, final int width, final int height) {
        return new Callable<String>(){

            @Override
            public String call() {
                try {
                    ImagePlus imp = IJ.openImage((String)path);
                    if (null == imp) {
                        IJ.log((String)("Could not open target image at " + path));
                        return null;
                    }
                    ImageProcessor ip = imp.getProcessor().createProcessor(width, height);
                    if (imp.getType() == 4) {
                        ip.setRoi(0, 0, width, height);
                        ip.setValue(0.0);
                        ip.fill();
                    }
                    ip.insert(imp.getProcessor(), x, y);
                    ImagePlus big = new ImagePlus(imp.getTitle(), ip);
                    big.setCalibration(imp.getCalibration());
                    Register_Virtual_Stack_MT.flush(imp);
                    imp = null;
                    ip = null;
                    if (!new FileSaver(big).saveAsTiff(path)) {
                        return null;
                    }
                    Register_Virtual_Stack_MT.flush(big);
                    big = null;
                    System.gc();
                    return new File(path).getName();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    private static Callable<String> saveTransform(final String path, final mpicbg.trakem2.transform.CoordinateTransform t) {
        return new Callable<String>(){

            @Override
            public String call() {
                try {
                    FileWriter fw = new FileWriter(path);
                    fw.write(t.toXML(""));
                    fw.close();
                    return new File(path).getName();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    private static String makeTargetPath(String dir, String name) {
        String filepath = dir + name;
        if (!name.toLowerCase().matches("^.*ti[f]{1,2}$")) {
            filepath = filepath + ".tif";
        }
        return filepath;
    }

    private static String makeTransformPath(String dir, String name) {
        int i = name.lastIndexOf(".");
        String no_ext = name.substring(0, i + 1);
        return dir + no_ext + "xml";
    }

    private static Callable<ArrayList<Feature>> extractFeatures(final Param p, final ImageProcessor ip) {
        return new Callable<ArrayList<Feature>>(){

            @Override
            public ArrayList<Feature> call() {
                ArrayList<Feature> fs = new ArrayList<Feature>();
                new SIFT(new FloatArray2DSIFT(p.sift)).extractFeatures(ip, fs);
                return fs;
            }
        };
    }

    private static Callable<ArrayList<Feature>> extractFeatures(final Param p, final String path, final int index) {
        return new Callable<ArrayList<Feature>>(){

            @Override
            public ArrayList<Feature> call() {
                ImagePlus imp = Register_Virtual_Stack_MT.readImage(path);
                centerX[index] = imp.getWidth() / 2;
                centerY[index] = imp.getHeight() / 2;
                ArrayList<Feature> fs = new ArrayList<Feature>();
                new SIFT(new FloatArray2DSIFT(p.sift)).extractFeatures(imp.getProcessor(), fs);
                Register_Virtual_Stack_MT.flush(imp);
                imp = null;
                System.gc();
                return fs;
            }
        };
    }

    public static ImagePlus readImage(String path) {
        ImagePlus imp;
        if (path.toLowerCase().endsWith(".dm3")) {
            DM3_Reader reader = new DM3_Reader();
            File f = new File(path);
            imp = reader.load(f.getParent(), f.getName());
        } else if (path.toLowerCase().endsWith(".dm4")) {
            ImagePlus[] imps = null;
            try {
                imps = BF.openImagePlus((String)path);
            }
            catch (FormatException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            imp = imps[0];
        } else {
            imp = IJ.openImage((String)path);
        }
        return imp;
    }

    private static Callable<Boolean> saveImage(final ImagePlus imp, final String path) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    return new FileSaver(imp).saveAsTiff(path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        };
    }

    private static Callable<Boolean> applyTransformAndSave(final String source_dir, final String file_name, final String target_dir, final mpicbg.trakem2.transform.CoordinateTransform transform, final Rectangle[] bounds, final boolean interpolate, final int i) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Rectangle currentBounds;
                ImagePlus imp2 = Register_Virtual_Stack_MT.readImage(source_dir + file_name);
                TransformMesh mesh = new TransformMesh((CoordinateTransform)transform, 32, (double)imp2.getWidth(), (double)imp2.getHeight());
                TransformMeshMapping mapping = new TransformMeshMapping(mesh);
                imp2.getProcessor().setValue(0.0);
                ImageProcessor ip2 = interpolate ? mapping.createMappedImageInterpolated(imp2.getProcessor()) : mapping.createMappedImage(imp2.getProcessor());
                imp2.setProcessor(imp2.getTitle(), ip2);
                bounds[i] = currentBounds = mesh.getBoundingBox();
                return new FileSaver(imp2).saveAsTiff(Register_Virtual_Stack_MT.makeTargetPath(target_dir, file_name));
            }
        };
    }

    private static Callable<ArrayList<PointMatch>> matchFeatures(Param p, final Collection<Feature> fs2, final Collection<Feature> fs1, final Model<?> featuresModel) throws Exception {
        return new Callable<ArrayList<PointMatch>>(){

            @Override
            public ArrayList<PointMatch> call() throws Exception {
                ArrayList candidates = new ArrayList();
                FeatureTransform.matchFeatures((Collection)fs2, (Collection)fs1, candidates, (float)Param.rod);
                ArrayList<PointMatch> inliers = new ArrayList<PointMatch>();
                featuresModel.filterRansac(candidates, inliers, 1000, (double)Param.maxEpsilon, (double)Param.minInlierRatio);
                return inliers;
            }
        };
    }

    public static boolean register(ImagePlus imp1, ImagePlus imp2, ImagePlus imp1mask, ImagePlus imp2mask, int i, String[] sorted_file_names, String source_dir, String target_dir, ExecutorService exe, Param p, mpicbg.trakem2.transform.CoordinateTransform t, Rectangle commonBounds, List<Rectangle> bounds, int referenceIndex) throws Exception {
        ArrayList inliers;
        block22: {
            TranslationModel2D featuresModel;
            IJ.showStatus((String)("Registering slice " + (i + 1) + "/" + sorted_file_names.length));
            Future<ArrayList<Feature>> fu1 = exe.submit(Register_Virtual_Stack_MT.extractFeatures(p, imp1.getProcessor()));
            Future<ArrayList<Feature>> fu2 = exe.submit(Register_Virtual_Stack_MT.extractFeatures(p, imp2.getProcessor()));
            ArrayList<Feature> fs1 = fu1.get();
            ArrayList<Feature> fs2 = fu2.get();
            ArrayList candidates = new ArrayList();
            FeatureTransform.matchFeatures(fs2, fs1, candidates, (float)Param.rod);
            inliers = new ArrayList();
            switch (Param.featuresModelIndex) {
                case 0: {
                    featuresModel = new TranslationModel2D();
                    break;
                }
                case 1: {
                    featuresModel = new RigidModel2D();
                    break;
                }
                case 2: {
                    featuresModel = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    featuresModel = new AffineModel2D();
                    break;
                }
                default: {
                    IJ.error((String)("ERROR: unknown featuresModelIndex = " + Param.featuresModelIndex));
                    return false;
                }
            }
            try {
                featuresModel.filterRansac(candidates, inliers, 1000, (double)Param.maxEpsilon, (double)Param.minInlierRatio);
            }
            catch (NotEnoughDataPointsException e) {
                IJ.log((String)("No features model found for file " + i + ": " + sorted_file_names[i]));
                if (Param.registrationModelIndex == 4) break block22;
                IJ.error((String)("No features model found for file " + i + ": " + sorted_file_names[i]));
                return false;
            }
        }
        switch (Param.registrationModelIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ((Model)t).fit(inliers);
                break;
            }
            case 4: {
                ImageProcessor mask2;
                ArrayList sourcePoints = new ArrayList();
                ArrayList targetPoints = new ArrayList();
                if (inliers.size() != 0) {
                    PointMatch.sourcePoints(inliers, sourcePoints);
                    PointMatch.targetPoints(inliers, targetPoints);
                    imp2.setRoi((Roi)Util.pointsToPointRoi(sourcePoints));
                    imp1.setRoi((Roi)Util.pointsToPointRoi(targetPoints));
                }
                if (Param.featuresModelIndex < 3) {
                    p.elastic_param.setShearCorrection(1.0);
                    p.elastic_param.setAnisotropyCorrection(1.0);
                    if (Param.featuresModelIndex < 2) {
                        p.elastic_param.setScaleCorrection(1.0);
                    }
                }
                ImageProcessor mask1 = imp1mask.getProcessor() == null ? null : imp1mask.getProcessor();
                ImageProcessor imageProcessor = mask2 = imp2mask.getProcessor() == null ? null : imp2mask.getProcessor();
                if (debug) {
                    IJ.log((String)("\nsource  " + i + ": " + imp1.getOriginalFileInfo().directory + imp1.getOriginalFileInfo().fileName));
                    IJ.log((String)("target " + i + ": " + imp2.getOriginalFileInfo().directory + imp2.getOriginalFileInfo().fileName));
                }
                Transformation warp = bUnwarpJ_.computeTransformationBatch((ImagePlus)imp2, (ImagePlus)imp1, (ImageProcessor)mask2, (ImageProcessor)mask1, (bunwarpj.Param)p.elastic_param);
                ((CubicBSplineTransform)t).set(warp.getIntervals(), warp.getDirectDeformationCoefficientsX(), warp.getDirectDeformationCoefficientsY(), imp2.getWidth(), imp2.getHeight());
                break;
            }
            case 5: {
                ((MovingLeastSquaresTransform)t).setModel(AffineModel2D.class);
                ((MovingLeastSquaresTransform)t).setAlpha(1.0);
                ((MovingLeastSquaresTransform)t).setMatches(inliers);
            }
        }
        TransformMesh mesh = new TransformMesh((CoordinateTransform)t, 32, (double)imp2.getWidth(), (double)imp2.getHeight());
        TransformMeshMapping mapping = new TransformMeshMapping(mesh);
        if (Param.registrationModelIndex == 4) {
            imp2mask.setProcessor(imp2mask.getTitle(), (ImageProcessor)new ByteProcessor(imp2.getWidth(), imp2.getHeight()));
            imp2mask.getProcessor().setValue(255.0);
            imp2mask.getProcessor().fill();
            ImageProcessor ip2mask = Param.interpolate ? mapping.createMappedImageInterpolated(imp2mask.getProcessor()) : mapping.createMappedImage(imp2mask.getProcessor());
            imp2mask.setProcessor(imp2mask.getTitle(), ip2mask);
        }
        imp2.getProcessor().setValue(0.0);
        ImageProcessor ip2 = Param.interpolate ? mapping.createMappedImageInterpolated(imp2.getProcessor()) : mapping.createMappedImage(imp2.getProcessor());
        imp2.setProcessor(imp2.getTitle(), ip2);
        Rectangle currentBounds = mesh.getBoundingBox();
        Rectangle previousBounds = bounds.get(bounds.size() - 1);
        currentBounds.x += previousBounds.x;
        currentBounds.y += previousBounds.y;
        bounds.add(currentBounds);
        int min_x = commonBounds.x;
        int min_y = commonBounds.y;
        int max_x = commonBounds.x + commonBounds.width;
        int max_y = commonBounds.y + commonBounds.height;
        if (currentBounds.x < commonBounds.x) {
            min_x = currentBounds.x;
        }
        if (currentBounds.y < commonBounds.y) {
            min_y = currentBounds.y;
        }
        if (currentBounds.x + currentBounds.width > max_x) {
            max_x = currentBounds.x + currentBounds.width;
        }
        if (currentBounds.y + currentBounds.height > max_y) {
            max_y = currentBounds.y + currentBounds.height;
        }
        commonBounds.x = min_x;
        commonBounds.y = min_y;
        commonBounds.width = max_x - min_x;
        commonBounds.height = max_y - min_y;
        new FileSaver(imp2).saveAsTiff(Register_Virtual_Stack_MT.makeTargetPath(target_dir, sorted_file_names[i]));
        return true;
    }

    public static mpicbg.trakem2.transform.CoordinateTransform getCoordinateTransform(Param p) {
        TranslationModel2D t;
        switch (Param.registrationModelIndex) {
            case 0: {
                t = new TranslationModel2D();
                break;
            }
            case 1: {
                t = new RigidModel2D();
                break;
            }
            case 2: {
                t = new SimilarityModel2D();
                break;
            }
            case 3: {
                t = new AffineModel2D();
                break;
            }
            case 4: {
                t = new CubicBSplineTransform();
                break;
            }
            case 5: {
                t = new MovingLeastSquaresTransform();
                break;
            }
            default: {
                IJ.log((String)("ERROR: unknown registrationModelIndex = " + Param.registrationModelIndex));
                return null;
            }
        }
        return t;
    }

    public static void fitInliers(Param p, mpicbg.trakem2.transform.CoordinateTransform t, List<PointMatch> inliers) throws Exception {
        switch (Param.registrationModelIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                ((Model)t).fit(inliers);
                break;
            }
            case 5: {
                ((MovingLeastSquaresTransform)t).setModel(AffineModel2D.class);
                ((MovingLeastSquaresTransform)t).setAlpha(1.0);
                ((MovingLeastSquaresTransform)t).setMatches(inliers);
            }
        }
    }

    public static void regularize(mpicbg.trakem2.transform.CoordinateTransform t, int index) {
        if (t instanceof AffineModel2D || t instanceof SimilarityModel2D) {
            AffineTransform a = t instanceof AffineModel2D ? ((AffineModel2D)t).createAffine() : ((SimilarityModel2D)t).createAffine();
            a.translate(centerX[index], centerY[index]);
            double a11 = a.getScaleX();
            double a21 = a.getShearY();
            double scaleX = Math.sqrt(a11 * a11 + a21 * a21);
            double rotang = Math.atan2(a21 / scaleX, a11 / scaleX);
            double a12 = a.getShearX();
            double a22 = a.getScaleY();
            double shearX = Math.cos(-rotang) * a12 - Math.sin(-rotang) * a22;
            double scaleY = Math.sin(-rotang) * a12 + Math.cos(-rotang) * a22;
            double transX = Math.cos(-rotang) * a.getTranslateX() - Math.sin(-rotang) * a.getTranslateY();
            double transY = Math.sin(-rotang) * a.getTranslateX() + Math.cos(-rotang) * a.getTranslateY();
            double new_shearX = shearX * (1.0 - tweakShear);
            double avgScale = (scaleX + scaleY) / 2.0;
            double aspectRatio = scaleX / scaleY;
            double regAvgScale = avgScale * (1.0 - tweakScale) + 1.0 * tweakScale;
            double regAspectRatio = aspectRatio * (1.0 - tweakIso) + 1.0 * tweakIso;
            double new_scaleY = 2.0 * regAvgScale / (regAspectRatio + 1.0);
            double new_scaleX = regAspectRatio * new_scaleY;
            AffineTransform b = Register_Virtual_Stack_MT.makeAffineMatrix(new_scaleX, new_scaleY, new_shearX, 0.0, rotang, transX, transY);
            b.translate(-centerX[index], -centerY[index]);
            if (t instanceof AffineModel2D) {
                ((AffineModel2D)t).set(b);
            } else {
                ((SimilarityModel2D)t).set((double)((float)b.getScaleX()), (double)((float)b.getShearY()), (double)((float)b.getTranslateX()), (double)((float)b.getTranslateY()));
            }
        }
    }

    public static AffineTransform makeAffineMatrix(double scalex, double scaley, double shearx, double sheary, double rotang, double transx, double transy) {
        double m00 = Math.cos(rotang) * scalex - Math.sin(rotang) * sheary;
        double m01 = Math.cos(rotang) * shearx - Math.sin(rotang) * scaley;
        double m02 = Math.cos(rotang) * transx - Math.sin(rotang) * transy;
        double m10 = Math.sin(rotang) * scalex + Math.cos(rotang) * sheary;
        double m11 = Math.sin(rotang) * shearx + Math.cos(rotang) * scaley;
        double m12 = Math.sin(rotang) * transx + Math.cos(rotang) * transy;
        return new AffineTransform(m00, m10, m01, m11, m02, m12);
    }

    public static boolean showRegularizationDialog(Param p) {
        GenericDialog gd = new GenericDialog("Shrinkage regularization");
        if (Param.registrationModelIndex == 2) {
            tweakIso = 1.0;
        }
        gd.addNumericField("shear :", tweakShear, 2);
        TextField shearTextField = (TextField)gd.getNumericFields().lastElement();
        gd.addNumericField("scale :", tweakScale, 2);
        TextField scaleTextField = (TextField)gd.getNumericFields().lastElement();
        gd.addNumericField("isotropy :", tweakIso, 2);
        TextField isotropyTextField = (TextField)gd.getNumericFields().lastElement();
        if (Param.registrationModelIndex == 2) {
            isotropyTextField.setEnabled(false);
        } else if (Param.registrationModelIndex == 4) {
            shearTextField.setEnabled(false);
            scaleTextField.setEnabled(false);
            isotropyTextField.setEnabled(false);
        } else {
            isotropyTextField.setEnabled(true);
        }
        gd.addMessage("Values between 0 and 1 are expected");
        gd.addMessage("(the closest to 1, the closest to rigid)");
        gd.addCheckbox("Display_relaxation_graph", displayRelaxGraph);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        tweakShear = gd.getNextNumber();
        tweakScale = gd.getNextNumber();
        tweakIso = gd.getNextNumber();
        displayRelaxGraph = gd.getNextBoolean();
        return true;
    }

    public static void postProcessTransforms(mpicbg.trakem2.transform.CoordinateTransform[] transform) {
        AffineTransform a;
        double avgAngle = 0.0;
        double avgScale = 0.0;
        for (int i = 0; i < transform.length; ++i) {
            mpicbg.trakem2.transform.CoordinateTransform t = transform[i];
            if (!(t instanceof AffineModel2D) && !(t instanceof SimilarityModel2D)) continue;
            a = t instanceof AffineModel2D ? ((AffineModel2D)t).createAffine() : ((SimilarityModel2D)t).createAffine();
            double a11 = a.getScaleX();
            double a21 = a.getShearY();
            double scaleX = Math.sqrt(a11 * a11 + a21 * a21);
            double rotang = Math.atan2(a21 / scaleX, a11 / scaleX);
            double a12 = a.getShearX();
            double a22 = a.getScaleY();
            double scaleY = Math.sin(-rotang) * a12 + Math.cos(-rotang) * a22;
            avgScale += (scaleX + scaleY) / 2.0;
            avgAngle += rotang;
        }
        AffineTransform correctionMatrix = new AffineTransform(Math.cos(-(avgAngle /= (double)transform.length)) / (avgScale /= (double)transform.length), Math.sin(-avgAngle) / avgScale, -Math.sin(-avgAngle) / avgScale, Math.cos(-avgAngle) / avgScale, 0.0, 0.0);
        for (int i = 0; i < transform.length; ++i) {
            if (!(transform[i] instanceof AffineModel2D) && !(transform[i] instanceof SimilarityModel2D)) continue;
            a = transform[i] instanceof AffineModel2D ? ((AffineModel2D)transform[i]).createAffine() : ((SimilarityModel2D)transform[i]).createAffine();
            AffineTransform b = new AffineTransform(a);
            b.concatenate(correctionMatrix);
            if (transform[i] instanceof AffineModel2D) {
                ((AffineModel2D)transform[i]).set(b);
                continue;
            }
            ((SimilarityModel2D)transform[i]).set((double)((float)b.getScaleX()), (double)((float)b.getShearY()), (double)((float)b.getTranslateX()), (double)((float)b.getTranslateY()));
        }
    }

    public static void flush(ImagePlus imp) {
        if (null == imp) {
            return;
        }
        imp.flush();
        if (null != imp.getProcessor() && null != imp.getProcessor().getPixels()) {
            imp.getProcessor().setPixels(null);
        }
    }

    public static class Param {
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public static float rod = 0.92f;
        public static float maxEpsilon = 25.0f;
        public static float minInlierRatio = 0.05f;
        public static int featuresModelIndex = 1;
        public static int registrationModelIndex = 1;
        public static boolean interpolate = true;
        public bunwarpj.Param elastic_param = new bunwarpj.Param();

        public boolean showDialog() {
            GenericDialog gd = new GenericDialog("Feature extraction");
            gd.addMessage("Scale Invariant Interest Point Detector:");
            gd.addNumericField("initial_gaussian_blur :", (double)this.sift.initialSigma, 2, 6, "px");
            gd.addNumericField("steps_per_scale_octave :", (double)this.sift.steps, 0);
            gd.addNumericField("minimum_image_size :", (double)this.sift.minOctaveSize, 0, 6, "px");
            gd.addNumericField("maximum_image_size :", (double)this.sift.maxOctaveSize, 0, 6, "px");
            gd.addMessage("Feature Descriptor:");
            gd.addNumericField("feature_descriptor_size :", 8.0, 0);
            gd.addNumericField("feature_descriptor_orientation_bins :", (double)this.sift.fdBins, 0);
            gd.addNumericField("closest/next_closest_ratio :", (double)rod, 2);
            gd.addMessage("Geometric Consensus Filter:");
            gd.addNumericField("maximal_alignment_error :", (double)maxEpsilon, 2, 6, "px");
            gd.addNumericField("inlier_ratio :", (double)minInlierRatio, 2);
            gd.addChoice("Feature_extraction_model :", featuresModelStrings, featuresModelStrings[featuresModelIndex]);
            gd.addMessage("Registration:");
            gd.addChoice("Registration_model:", registrationModelStrings, registrationModelStrings[registrationModelIndex]);
            gd.addCheckbox("interpolate", interpolate);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.sift.initialSigma = (float)gd.getNextNumber();
            this.sift.steps = (int)gd.getNextNumber();
            this.sift.minOctaveSize = (int)gd.getNextNumber();
            this.sift.maxOctaveSize = (int)gd.getNextNumber();
            this.sift.fdSize = (int)gd.getNextNumber();
            this.sift.fdBins = (int)gd.getNextNumber();
            rod = (float)gd.getNextNumber();
            maxEpsilon = (float)gd.getNextNumber();
            minInlierRatio = (float)gd.getNextNumber();
            featuresModelIndex = gd.getNextChoiceIndex();
            registrationModelIndex = gd.getNextChoiceIndex();
            interpolate = gd.getNextBoolean();
            return registrationModelIndex != 4 || this.elastic_param.showDialog();
        }
    }
}

