/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.math.BigInteger;
import org.lsmp.djep.groupJep.GroupI;
import org.lsmp.djep.groupJep.GroupJep;
import org.lsmp.djep.groupJep.groups.AlgebraicExtension;
import org.lsmp.djep.groupJep.groups.BigReals;
import org.lsmp.djep.groupJep.groups.ExtendedFreeGroup;
import org.lsmp.djep.groupJep.groups.FreeGroup;
import org.lsmp.djep.groupJep.groups.Group;
import org.lsmp.djep.groupJep.groups.Integers;
import org.lsmp.djep.groupJep.groups.PermutationGroup;
import org.lsmp.djep.groupJep.groups.Quaternions;
import org.lsmp.djep.groupJep.groups.Rationals;
import org.lsmp.djep.groupJep.groups.Reals;
import org.lsmp.djep.groupJep.groups.Zn;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.lsmp.djep.groupJep.values.HasComplexValueI;
import org.lsmp.djep.groupJep.values.Polynomial;
import org.lsmp.djepExamples.Console;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

public class GroupConsole
extends Console {
    private static final long serialVersionUID = -3097491397108691409L;

    public static void main(String[] args) {
        GroupConsole c = new GroupConsole();
        c.run(args);
    }

    @Override
    public String getPrompt() {
        return "GroupJep > ";
    }

    @Override
    public void initialise() {
        this.j = new GroupJep(new Rationals());
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
    }

    public void initialise(Group g) {
        this.j = new GroupJep(g);
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
    }

    @Override
    public void printIntroText() {
        this.println("GroupJep: evaluation over abstract groups");
        this.printGroup();
        super.printStdHelp();
    }

    public void printGroup() {
        this.println("Current Group: " + ((GroupJep)this.j).getGroup().toString());
    }

    @Override
    public void processEquation(Node node) throws ParseException {
        Object value = this.j.evaluate(node);
        if (value instanceof HasComplexValueI) {
            this.println(value.toString() + "=" + ((HasComplexValueI)value).getComplexValue());
        } else {
            this.println(value);
        }
    }

    @Override
    public boolean testSpecialCommands(String command) {
        GroupJep gj = (GroupJep)this.j;
        if (!super.testSpecialCommands(command)) {
            return false;
        }
        String[] words = this.split(command);
        if (words.length == 0) {
            return true;
        }
        if (words[0].equals("group")) {
            if (words.length != 1) {
                if (words[1].equals("Z")) {
                    this.initialise(new Integers());
                } else if (words[1].equals("Q")) {
                    this.initialise(new Rationals());
                } else if (words[1].equals("R") && words.length == 3) {
                    this.initialise(new BigReals(Integer.parseInt(words[2]), 6));
                } else if (words[1].equals("R") && words.length == 2) {
                    this.initialise(new Reals());
                } else if (words[1].equals("P") && words.length == 3) {
                    this.initialise(new PermutationGroup(Integer.parseInt(words[2])));
                } else if (words[1].equals("Zn") && words.length == 3) {
                    this.initialise(new Zn(new BigInteger(words[2])));
                } else if (words[1].equals("Qu")) {
                    this.initialise(new Quaternions());
                } else {
                    this.println("invalid group spec " + command);
                    return false;
                }
            }
            this.printGroup();
            return false;
        }
        if (words[0].equals("extend")) {
            RingI ring = (RingI)gj.getGroup();
            if (words.length < 2) {
                this.println("extend must have at least one argument");
            } else if (words.length == 2) {
                this.initialise(new ExtendedFreeGroup(ring, words[1]));
            } else {
                int deg = words.length - 3;
                Number[] coeffs = new Number[deg + 1];
                for (int i = 0; i <= deg; ++i) {
                    coeffs[i] = ring.valueOf(words[words.length - i - 1]);
                }
                Polynomial p1 = new Polynomial(ring, words[1], coeffs);
                this.initialise(new AlgebraicExtension(ring, p1));
            }
            this.printGroup();
            return false;
        }
        if (words[0].equals("setRootVal")) {
            boolean flag;
            String symbol = words[1];
            Complex val = new Complex(Double.parseDouble(words[2]), Double.parseDouble(words[3]));
            GroupI g = gj.getGroup();
            if (g instanceof FreeGroup && !(flag = ((FreeGroup)g).setRootVal(symbol, val))) {
                this.println("Failed to set root value, could not find symbol");
            }
            return false;
        }
        return true;
    }

    @Override
    public void printHelp() {
        super.printHelp();
        this.println("'group'\tprints the current group");
        this.println("'group G'\tchanges underlying group to G");
        this.println("'group Z'\tintegers (arbitrary precision)");
        this.println("'group Q'\trationals");
        this.println("'group R'\treals, represented as Doubles.");
        this.println("'group R 3'\treals represented as BigDecimals with 3 decimal places");
        this.println("'group P 3'\tpermutation group on three symbols");
        this.println("\t[1,3,2]+[3,2,1] -> (3,1,2)");
        this.println("'group Zn 5'\tintegers modulo 5");
        this.println("'group Qu'\tQuarternions");
        this.println("'extend x'\textends current group by adding symbol x, i.e. a free group");
        this.println("\tsuch a group can be considered as the ring of polynomials");
        this.println("\tsimplification happens automatically");
        this.println("'extend t a b c'\talgebraic extensions generated by t");
        this.println("\twhere t is a root of the polynomial a t^2 + b t +c=0");
        this.println("\te.g  group extend t 1 0 1 gives complex numbers, t^2+1=0.");
        this.println("\tfor these groups there is a natural mapping to complex numbers and complex result is also printed.");
        this.println("'setRootVal t re im'\tsets the value of free variable 't' in a free group to complex number re+i im");
    }
}

