/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Basic;
import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;

class Simple {
    Simple() {
    }

    static boolean simpleFace(Triangulator triRef, int ind1) {
        int ind0 = triRef.fetchPrevData(ind1);
        int i0 = triRef.fetchData(ind0);
        if (ind0 == ind1) {
            System.out.println("***** polygon with only one vertex?! *****\n");
            return true;
        }
        int ind2 = triRef.fetchNextData(ind1);
        int i2 = triRef.fetchData(ind2);
        if (ind0 == ind2) {
            System.out.println("***** polygon with only two vertices?! *****\n");
            return true;
        }
        int ind3 = triRef.fetchNextData(ind2);
        int i3 = triRef.fetchData(ind3);
        if (ind0 == ind3) {
            int i1 = triRef.fetchData(ind1);
            triRef.storeTriangle(ind1, ind2, ind3);
            return true;
        }
        int ind4 = triRef.fetchNextData(ind3);
        int i4 = triRef.fetchData(ind4);
        if (ind0 == ind4) {
            triRef.initPnts(5);
            int i1 = triRef.fetchData(ind1);
            Point3f pq = new Point3f();
            Point3f pr = new Point3f();
            Point3f nr = new Point3f();
            Basic.vectorSub((Tuple3f)triRef.vertices[i1], (Tuple3f)triRef.vertices[i2], (Tuple3f)pq);
            Basic.vectorSub((Tuple3f)triRef.vertices[i3], (Tuple3f)triRef.vertices[i2], (Tuple3f)pr);
            Basic.vectorProduct((Tuple3f)pq, (Tuple3f)pr, (Tuple3f)nr);
            double x = Math.abs(nr.x);
            double y = Math.abs(nr.y);
            double z = Math.abs(nr.z);
            if (z >= x && z >= y) {
                triRef.points[1].x = triRef.vertices[i1].x;
                triRef.points[1].y = triRef.vertices[i1].y;
                triRef.points[2].x = triRef.vertices[i2].x;
                triRef.points[2].y = triRef.vertices[i2].y;
                triRef.points[3].x = triRef.vertices[i3].x;
                triRef.points[3].y = triRef.vertices[i3].y;
                triRef.points[4].x = triRef.vertices[i4].x;
                triRef.points[4].y = triRef.vertices[i4].y;
            } else if (x >= y && x >= z) {
                triRef.points[1].x = triRef.vertices[i1].z;
                triRef.points[1].y = triRef.vertices[i1].y;
                triRef.points[2].x = triRef.vertices[i2].z;
                triRef.points[2].y = triRef.vertices[i2].y;
                triRef.points[3].x = triRef.vertices[i3].z;
                triRef.points[3].y = triRef.vertices[i3].y;
                triRef.points[4].x = triRef.vertices[i4].z;
                triRef.points[4].y = triRef.vertices[i4].y;
            } else {
                triRef.points[1].x = triRef.vertices[i1].x;
                triRef.points[1].y = triRef.vertices[i1].z;
                triRef.points[2].x = triRef.vertices[i2].x;
                triRef.points[2].y = triRef.vertices[i2].z;
                triRef.points[3].x = triRef.vertices[i3].x;
                triRef.points[3].y = triRef.vertices[i3].z;
                triRef.points[4].x = triRef.vertices[i4].x;
                triRef.points[4].y = triRef.vertices[i4].z;
            }
            triRef.numPoints = 5;
            int ori2 = Numerics.orientation(triRef, 1, 2, 3);
            int ori4 = Numerics.orientation(triRef, 1, 3, 4);
            if (ori2 > 0 && ori4 > 0 || ori2 < 0 && ori4 < 0) {
                triRef.storeTriangle(ind1, ind2, ind3);
                triRef.storeTriangle(ind1, ind3, ind4);
            } else {
                triRef.storeTriangle(ind2, ind3, ind4);
                triRef.storeTriangle(ind2, ind4, ind1);
            }
            return true;
        }
        return false;
    }
}

