/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.behaviors.vp.ViewPlatformBehavior;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.vecmath.Matrix4d;

class ConfigViewPlatformBehavior
extends ConfigObject {
    private Transform3D homeTransform = null;
    private Bounds schedulingBounds = null;
    private int schedulingInterval = -1;
    ViewPlatformBehavior viewPlatformBehavior;

    ConfigViewPlatformBehavior() {
    }

    @Override
    protected void setProperty(ConfigCommand cmd) {
        String attribute;
        int argc = cmd.argc;
        Object[] argv = cmd.argv;
        if (argc < 4) {
            this.syntaxError("Wrong number of arguments to " + cmd.commandName);
        }
        if (!this.isName(argv[2])) {
            this.syntaxError("The second argument to " + cmd.commandName + " must be a property name");
        }
        if ((attribute = (String)argv[2]).equals("HomeTransform")) {
            if (!(argv[3] instanceof Matrix4d)) {
                this.syntaxError("HomeTransform must be a Matrix4d");
            }
            this.homeTransform = new Transform3D((Matrix4d)argv[3]);
        } else if (attribute.equals("SchedulingBounds")) {
            if (!(argv[3] instanceof Bounds)) {
                this.syntaxError("SchedulingBounds must be an instance of Bounds");
            }
            this.schedulingBounds = (Bounds)argv[3];
        } else if (attribute.equals("SchedulingInterval")) {
            if (!(argv[3] instanceof Double)) {
                this.syntaxError("SchedulingInterval must be a priority (number)");
            }
            this.schedulingInterval = ((Double)argv[3]).intValue();
        } else {
            this.properties.add(cmd);
        }
    }

    ViewPlatformBehavior createViewPlatformBehavior() {
        this.viewPlatformBehavior = (ViewPlatformBehavior)this.createTargetObject();
        if (this.homeTransform != null) {
            this.viewPlatformBehavior.setHomeTransform(this.homeTransform);
        }
        if (this.schedulingBounds != null) {
            this.viewPlatformBehavior.setSchedulingBounds(this.schedulingBounds);
        }
        if (this.schedulingInterval != -1) {
            this.viewPlatformBehavior.setSchedulingInterval(this.schedulingInterval);
        }
        return this.viewPlatformBehavior;
    }
}

