/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.Optional;
import java.util.function.BiFunction;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;

public interface N5MetadataParser<T extends N5Metadata>
extends BiFunction<N5Reader, N5TreeNode, Optional<T>> {
    public static DatasetAttributes parseDatasetAttributes(N5Reader n5, N5TreeNode node) {
        return n5.getDatasetAttributes(node.getPath());
    }

    public Optional<T> parseMetadata(N5Reader var1, N5TreeNode var2);

    default public Optional<T> parseMetadata(N5Reader n5, String dataset) {
        if (!n5.exists(dataset)) {
            return Optional.empty();
        }
        return this.parseMetadata(n5, new N5TreeNode(dataset));
    }

    @Override
    default public Optional<T> apply(N5Reader n5Reader, N5TreeNode n5TreeNode) {
        return this.parseMetadata(n5Reader, n5TreeNode);
    }
}

