/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.TransformUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractLinearCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AffineCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.BijectionCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateFieldCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.DisplacementFieldCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.IdentityCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.MatrixCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ParametrizedTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.RealCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ReferencedCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ScaleCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ScaleOffsetCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.StackedCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ThinPlateSplineCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.TranslationCoordinateTransform;

public class CoordinateTransformAdapter
implements JsonDeserializer<CoordinateTransform<?>>,
JsonSerializer<CoordinateTransform<?>> {
    final N5Reader n5;
    public static final String[] FIELD_TO_NULL_CHECK = new String[]{"path", "name", "input", "output"};

    public CoordinateTransformAdapter() {
        this(null);
    }

    public CoordinateTransformAdapter(N5Reader n5) {
        this.n5 = n5;
    }

    public CoordinateTransform<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject jobj = json.getAsJsonObject();
        if (!jobj.has("type")) {
            return null;
        }
        CoordinateTransform out = null;
        switch (jobj.get("type").getAsString()) {
            case "identity": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, IdentityCoordinateTransform.class);
                break;
            }
            case "transformReference": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, ReferencedCoordinateTransform.class);
                break;
            }
            case "scale": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, ScaleCoordinateTransform.class);
                break;
            }
            case "translation": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, TranslationCoordinateTransform.class);
                break;
            }
            case "scale_offset": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, ScaleOffsetCoordinateTransform.class);
                break;
            }
            case "affine": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, AffineCoordinateTransform.class);
                break;
            }
            case "matrix": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, MatrixCoordinateTransform.class);
                break;
            }
            case "thin-plate-spline": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, ThinPlateSplineCoordinateTransform.class);
                break;
            }
            case "displacements": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, DisplacementFieldCoordinateTransform.class);
                break;
            }
            case "coordinates": {
                out = (CoordinateTransform)context.deserialize((JsonElement)jobj, CoordinateFieldCoordinateTransform.class);
                break;
            }
            case "bijection": {
                JsonObject btmp = (JsonObject)context.deserialize((JsonElement)jobj, JsonObject.class);
                IdentityCoordinateTransform bid = (IdentityCoordinateTransform)context.deserialize((JsonElement)btmp, IdentityCoordinateTransform.class);
                if (!btmp.has("forward") && !btmp.has("inverse")) {
                    out = null;
                    break;
                }
                RealCoordinateTransform fwd = (RealCoordinateTransform)context.deserialize(btmp.get("forward"), CoordinateTransform.class);
                RealCoordinateTransform inv = (RealCoordinateTransform)context.deserialize(btmp.get("inverse"), CoordinateTransform.class);
                out = new BijectionCoordinateTransform(bid.getName(), bid.getInput(), bid.getOutput(), fwd, inv);
                break;
            }
            case "sequence": {
                IdentityCoordinateTransform id = (IdentityCoordinateTransform)context.deserialize((JsonElement)jobj, IdentityCoordinateTransform.class);
                if (jobj.has("transformations")) {
                    JsonArray ja = jobj.get("transformations").getAsJsonArray();
                    RealCoordinateTransform[] transforms = new RealCoordinateTransform[ja.size()];
                    for (int i = 0; i < ja.size(); ++i) {
                        JsonObject e = ja.get(i).getAsJsonObject();
                        transforms[i] = (RealCoordinateTransform)context.deserialize((JsonElement)e, CoordinateTransform.class);
                    }
                    out = new SequenceCoordinateTransform(id.getName(), id.getInput(), id.getOutput(), transforms);
                    break;
                }
                out = null;
                break;
            }
            case "stacked": {
                IdentityCoordinateTransform sid = (IdentityCoordinateTransform)context.deserialize((JsonElement)jobj, IdentityCoordinateTransform.class);
                RealCoordinateTransform[] transforms = this.parseTransformList(jobj, "transformations", context);
                out = new StackedCoordinateTransform(sid.getName(), sid.getInput(), sid.getOutput(), Arrays.asList(transforms));
            }
        }
        return out;
    }

    private final RealCoordinateTransform[] parseTransformList(JsonObject elem, String key, JsonDeserializationContext context) {
        JsonArray ja = elem.get(key).getAsJsonArray();
        RealCoordinateTransform[] transforms = new RealCoordinateTransform[ja.size()];
        for (int i = 0; i < ja.size(); ++i) {
            JsonObject e = ja.get(i).getAsJsonObject();
            transforms[i] = (RealCoordinateTransform)context.deserialize((JsonElement)e, CoordinateTransform.class);
        }
        return transforms;
    }

    private final CoordinateTransform readTransformParameters(CoordinateTransform transform) {
        ParametrizedTransform pt;
        if (transform instanceof ParametrizedTransform && (pt = (ParametrizedTransform)transform).getParameterPath() != null) {
            pt.buildTransform(pt.getParameters(this.n5));
        }
        return transform;
    }

    public JsonElement serialize(CoordinateTransform<?> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement elem;
        if (src instanceof SequenceCoordinateTransform) {
            SequenceCoordinateTransform seq = (SequenceCoordinateTransform)src;
            JsonArray xfms = new JsonArray();
            CoordinateTransform<?>[] coordinateTransformArray = seq.getTransformations();
            int n = coordinateTransformArray.length;
            for (int i = 0; i < n; ++i) {
                CoordinateTransform<?> t = coordinateTransformArray[i];
                Type type = TypeToken.of(t.getClass()).getType();
                xfms.add(this.serialize(t, type, context));
            }
            JsonObject obj = (JsonObject)context.serialize(src);
            obj.add("transformations", (JsonElement)xfms);
            elem = obj;
        } else if (src instanceof BijectionCoordinateTransform) {
            BijectionCoordinateTransform bct = (BijectionCoordinateTransform)src;
            JsonObject obj = (JsonObject)context.serialize(src);
            RealCoordinateTransform<?> fwd = bct.getForward();
            Type ftype = TypeToken.of(fwd.getClass()).getType();
            obj.add("forward", this.serialize(fwd, ftype, context));
            RealCoordinateTransform<?> inv = bct.getInverse();
            Type itype = TypeToken.of(inv.getClass()).getType();
            obj.add("inverse", this.serialize(inv, itype, context));
            elem = obj;
        } else {
            if (src instanceof AbstractLinearCoordinateTransform) {
                AbstractLinearCoordinateTransform linCt = (AbstractLinearCoordinateTransform)src;
                JsonObject obj = (JsonObject)context.serialize((Object)linCt);
                if (!linCt.serializeFlatArray) {
                    obj.add("affine", context.serialize((Object)TransformUtils.affineToMatrix(linCt.getTransform())));
                }
                return obj;
            }
            elem = context.serialize(src);
        }
        if (elem instanceof JsonObject) {
            JsonObject obj = (JsonObject)elem;
            for (String f : FIELD_TO_NULL_CHECK) {
                if (!obj.has(f) || !obj.get(f).isJsonNull()) continue;
                obj.remove(f);
            }
        }
        return elem;
    }

    public static void test1() {
    }

    public static void seqTest() {
        String scaleString = "{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]}";
        String translationString = "{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}";
        String seqString = "{\"name\": \"myseq\",\"output_space\": \"out\",\"type\": \"sequence\",\"transformations\": [{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]},{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}]}";
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(CoordinateTransform.class, (Object)new CoordinateTransformAdapter(null));
        Gson gson = gsonBuilder.create();
        CoordinateTransform ct = (CoordinateTransform)gson.fromJson("{\"name\": \"myseq\",\"output_space\": \"out\",\"type\": \"sequence\",\"transformations\": [{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]},{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}]}", CoordinateTransform.class);
        System.out.println(ct);
    }

    public static void main(String[] args) {
        CoordinateTransformAdapter.seqTest();
    }
}

