/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.translation;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataNode;
import org.janelia.saalfeldlab.n5.universe.container.ContainerMetadataWriter;
import org.janelia.saalfeldlab.n5.universe.translation.TranslatedN5Reader;

public class TranslatedN5Writer
extends TranslatedN5Reader
implements N5Writer {
    protected N5Writer writer;
    protected ContainerMetadataWriter containerWriter;

    public TranslatedN5Writer(N5Writer n5Base, Gson gson, String fwdTranslation, String invTranslation) {
        super((N5Reader)n5Base, gson, fwdTranslation, invTranslation);
        this.writer = n5Base;
        this.containerWriter = new ContainerMetadataWriter(n5Base, this.translation.getTranslated());
    }

    public N5Writer getBaseWriter() {
        return this.writer;
    }

    public <T> void setAttribute(String pathName, String key, T attribute) {
        this.translation.setTranslatedAttribute(pathName, key, attribute);
        this.containerWriter.setMetadataTree(this.translation.getOrig());
        this.containerWriter.writeAllAttributes();
    }

    public void setAttributes(String pathName, Map<String, ?> attributes) {
        this.translation.setTranslatedAttributes(pathName, attributes);
        this.containerWriter.setMetadataTree(this.translation.getOrig());
        this.containerWriter.writeAllAttributes();
    }

    public void createGroup(String pathName) {
        this.translation.getTranslated().createGroup(pathName);
        this.translation.updateOriginal();
        this.writer.createGroup(this.originalPath(pathName));
    }

    public boolean remove(String pathName) {
        boolean success = this.writer.remove(this.originalPath(pathName));
        if (success) {
            this.translation.getTranslated().remove(pathName);
            this.translation.updateOriginal();
        }
        return success;
    }

    public boolean remove() {
        boolean success = this.writer.remove();
        if (success) {
            this.translation.rootOrig = new ContainerMetadataNode();
            this.translation.rootTranslated = new ContainerMetadataNode();
        }
        return success;
    }

    public boolean removeAttribute(String pathName, String key) {
        ContainerMetadataNode tlated = this.translation.getTranslated();
        if (tlated.removeAttribute(pathName, key)) {
            this.translation.updateOriginal();
            return true;
        }
        return false;
    }

    public <T> T removeAttribute(String pathName, String key, Class<T> clazz) {
        ContainerMetadataNode tlated = this.translation.getTranslated();
        T t = tlated.removeAttribute(pathName, key, clazz);
        if (t != null) {
            this.translation.updateOriginal();
            return t;
        }
        return null;
    }

    public boolean removeAttributes(String pathName, List<String> attributes) {
        ContainerMetadataNode tlated = this.translation.getTranslated();
        if (tlated.removeAttributes(pathName, attributes)) {
            this.translation.updateOriginal();
            return true;
        }
        return false;
    }

    public <T> void writeBlock(String pathName, DatasetAttributes datasetAttributes, DataBlock<T> dataBlock) {
        this.writer.writeBlock(this.originalPath(pathName), datasetAttributes, dataBlock);
    }

    public boolean deleteBlock(String pathName, long ... gridPosition) {
        return this.writer.deleteBlock(this.originalPath(pathName), gridPosition);
    }
}

