/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh.naive;

import net.imagej.mesh.Mesh;
import org.scijava.util.FloatArray;
import org.scijava.util.IntArray;

public class NaiveFloatMesh
implements Mesh {
    private final Vertices vertices = new Vertices();
    private final Triangles triangles = new Triangles();

    @Override
    public Vertices vertices() {
        return this.vertices;
    }

    @Override
    public Triangles triangles() {
        return this.triangles;
    }

    public class Triangles
    implements net.imagej.mesh.Triangles {
        private final IntArray v0s = new IntArray();
        private final IntArray v1s = new IntArray();
        private final IntArray v2s = new IntArray();
        private final FloatArray nxs = new FloatArray();
        private final FloatArray nys = new FloatArray();
        private final FloatArray nzs = new FloatArray();

        @Override
        public Mesh mesh() {
            return NaiveFloatMesh.this;
        }

        @Override
        public long size() {
            return this.v1s.size();
        }

        @Override
        public long vertex0(long tIndex) {
            return this.v0s.get(this.safeIndex(tIndex)).intValue();
        }

        @Override
        public long vertex1(long tIndex) {
            return this.v1s.get(this.safeIndex(tIndex)).intValue();
        }

        @Override
        public long vertex2(long tIndex) {
            return this.v2s.get(this.safeIndex(tIndex)).intValue();
        }

        @Override
        public float nxf(long tIndex) {
            return this.nxs.get(this.safeIndex(tIndex)).floatValue();
        }

        @Override
        public float nyf(long tIndex) {
            return this.nys.get(this.safeIndex(tIndex)).floatValue();
        }

        @Override
        public float nzf(long tIndex) {
            return this.nzs.get(this.safeIndex(tIndex)).floatValue();
        }

        @Override
        public long addf(long v0, long v1, long v2, float nx, float ny, float nz) {
            int index = this.v0s.size();
            this.v0s.add((Object)this.safeIndex(v0));
            this.v1s.add((Object)this.safeIndex(v1));
            this.v2s.add((Object)this.safeIndex(v2));
            this.nxs.add((Object)Float.valueOf(nx));
            this.nys.add((Object)Float.valueOf(ny));
            this.nzs.add((Object)Float.valueOf(nz));
            return index;
        }

        private int safeIndex(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Index too large: " + index);
            }
            return (int)index;
        }
    }

    public class Vertices
    implements net.imagej.mesh.Vertices {
        private final FloatArray xs = new FloatArray();
        private final FloatArray ys = new FloatArray();
        private final FloatArray zs = new FloatArray();
        private final FloatArray nxs = new FloatArray();
        private final FloatArray nys = new FloatArray();
        private final FloatArray nzs = new FloatArray();
        private final FloatArray us = new FloatArray();
        private final FloatArray vs = new FloatArray();

        @Override
        public Mesh mesh() {
            return NaiveFloatMesh.this;
        }

        @Override
        public long size() {
            return this.xs.size();
        }

        @Override
        public float xf(long vIndex) {
            return this.xs.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public float yf(long vIndex) {
            return this.ys.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public float zf(long vIndex) {
            return this.zs.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public float nxf(long vIndex) {
            return this.nxs.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public float nyf(long vIndex) {
            return this.nys.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public float nzf(long vIndex) {
            return this.nzs.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public float uf(long vIndex) {
            return this.us.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public float vf(long vIndex) {
            return this.vs.get(this.safeIndex(vIndex)).floatValue();
        }

        @Override
        public long addf(float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            int index = this.xs.size();
            this.xs.add((Object)Float.valueOf(x));
            this.ys.add((Object)Float.valueOf(y));
            this.zs.add((Object)Float.valueOf(z));
            this.nxs.add((Object)Float.valueOf(nx));
            this.nys.add((Object)Float.valueOf(ny));
            this.nzs.add((Object)Float.valueOf(nz));
            this.us.add((Object)Float.valueOf(u));
            this.vs.add((Object)Float.valueOf(v));
            return index;
        }

        @Override
        public void setf(long vIndex, float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            int index = this.safeIndex(vIndex);
            this.xs.set(index, Float.valueOf(x));
            this.ys.set(index, Float.valueOf(y));
            this.zs.set(index, Float.valueOf(z));
            this.nxs.set(index, Float.valueOf(nx));
            this.nys.set(index, Float.valueOf(ny));
            this.nzs.set(index, Float.valueOf(nz));
            this.us.set(index, Float.valueOf(u));
            this.vs.set(index, Float.valueOf(v));
        }

        @Override
        public void setPositionf(long vIndex, float x, float y, float z) {
            int index = this.safeIndex(vIndex);
            this.xs.set(index, Float.valueOf(x));
            this.ys.set(index, Float.valueOf(y));
            this.zs.set(index, Float.valueOf(z));
        }

        @Override
        public void setNormalf(long vIndex, float nx, float ny, float nz) {
            int index = this.safeIndex(vIndex);
            this.nxs.set(index, Float.valueOf(nx));
            this.nys.set(index, Float.valueOf(ny));
            this.nzs.set(index, Float.valueOf(nz));
        }

        @Override
        public void setTexturef(long vIndex, float u, float v) {
            int index = this.safeIndex(vIndex);
            this.us.set(index, Float.valueOf(u));
            this.vs.set(index, Float.valueOf(v));
        }

        private int safeIndex(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Index too large: " + index);
            }
            return (int)index;
        }
    }
}

