/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa;

import net.imagej.Dataset;
import net.imagej.ImageJ;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import org.scijava.ui.DialogPrompt;

class Utils {
    Utils() {
    }

    public static void askToSwapTimeAndZDimensions(ImageJ ij, Dataset dataset) {
        long zDim;
        int zIdx = dataset.dimensionIndex(Axes.Z);
        int timeIdx = dataset.dimensionIndex(Axes.TIME);
        long timeDim = dataset.dimension(timeIdx);
        if (timeDim < (zDim = dataset.dimension(zIdx))) {
            String mess = new String();
            mess = mess + "It appears this image has " + timeDim + " timepoints";
            mess = mess + " and " + zDim + " Z slices.\n";
            mess = mess + "Do you want to swap Z and T axes ?";
            DialogPrompt.Result result = ij.ui().showDialog(mess, DialogPrompt.MessageType.QUESTION_MESSAGE, DialogPrompt.OptionType.YES_NO_OPTION);
            result.equals((Object)DialogPrompt.Result.YES_OPTION);
            if (result.equals((Object)DialogPrompt.Result.YES_OPTION)) {
                if (zIdx != -1) {
                    ((CalibratedAxis)dataset.axis(zIdx)).setType(Axes.TIME);
                }
                if (timeIdx != -1) {
                    ((CalibratedAxis)dataset.axis(timeIdx)).setType(Axes.Z);
                }
            }
        }
    }

    public static void swapTimeAndZDimensions(ImageJ ij, Dataset dataset) {
        long zDim;
        int zIdx = dataset.dimensionIndex(Axes.Z);
        int timeIdx = dataset.dimensionIndex(Axes.TIME);
        long timeDim = dataset.dimension(timeIdx);
        if (timeDim < (zDim = dataset.dimension(zIdx))) {
            ij.log().info((Object)"Swapping TIME and Z axis.");
            if (zIdx != -1) {
                ((CalibratedAxis)dataset.axis(zIdx)).setType(Axes.TIME);
            }
            if (timeIdx != -1) {
                ((CalibratedAxis)dataset.axis(timeIdx)).setType(Axes.Z);
            }
        }
    }
}

