/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import net.imagej.Extents;
import net.imglib2.Iterator;
import net.imglib2.Localizable;
import net.imglib2.Positionable;

public class Position
implements Localizable,
Positionable,
Iterator {
    private final Extents parentSpace;
    private final long[] position;
    private boolean isInvalid;

    public Position(Extents parentSpace) {
        this.parentSpace = parentSpace;
        this.position = new long[parentSpace.numDimensions()];
        this.reset();
    }

    public Position(Position pos) {
        this.parentSpace = pos.getExtents();
        this.position = new long[pos.numDimensions()];
        for (int i = 0; i < this.position.length; ++i) {
            this.position[i] = pos.position[i];
        }
    }

    public Extents getExtents() {
        return this.parentSpace;
    }

    public int numDimensions() {
        return this.parentSpace.numDimensions();
    }

    public long dimension(int i) {
        return this.parentSpace.dimension(i);
    }

    public boolean hasNext() {
        if (this.isInvalid && this.position.length > 0) {
            return true;
        }
        for (int i = 0; i < this.position.length; ++i) {
            if (this.position[i] >= this.parentSpace.max(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrev() {
        if (this.isInvalid && this.position.length > 0) {
            return true;
        }
        for (int i = 0; i < this.position.length; ++i) {
            if (this.position[i] <= this.parentSpace.min(i)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.isInvalid = true;
        for (int i = 0; i < this.position.length; ++i) {
            this.position[i] = Long.MIN_VALUE;
        }
    }

    public void first() {
        for (int i = 0; i < this.position.length; ++i) {
            this.position[i] = this.parentSpace.min(i);
        }
        this.isInvalid = false;
    }

    public void last() {
        for (int i = 0; i < this.position.length; ++i) {
            this.position[i] = this.parentSpace.max(i);
        }
        this.isInvalid = false;
    }

    public void fwd() {
        if (this.isInvalid) {
            this.first();
            return;
        }
        for (int i = 0; i < this.position.length; ++i) {
            int n = i;
            this.position[n] = this.position[n] + 1L;
            if (this.position[i] <= this.parentSpace.max(i)) {
                return;
            }
            this.position[i] = this.parentSpace.min(i);
        }
        this.last();
        throw new IllegalStateException("cannot move last position forward");
    }

    public void bck() {
        if (this.isInvalid) {
            this.last();
            return;
        }
        for (int i = 0; i < this.position.length; ++i) {
            int n = i;
            this.position[n] = this.position[n] - 1L;
            if (this.position[i] >= this.parentSpace.min(i)) {
                return;
            }
            this.position[i] = this.parentSpace.max(i);
        }
        this.first();
        throw new IllegalStateException("cannot move first position backward");
    }

    public void fwd(int d) {
        if (this.isInvalid) {
            throw new IllegalArgumentException("Cannot move position : it is uninitialized");
        }
        long newValue = this.position[d] + 1L;
        if (newValue > this.parentSpace.max(d)) {
            throw new IllegalArgumentException("cannot move specified dimension forward - it would take position outside defined extents");
        }
        int n = d;
        this.position[n] = this.position[n] + 1L;
    }

    public void bck(int d) {
        if (this.isInvalid) {
            throw new IllegalArgumentException("Cannot move position : it is uninitialized");
        }
        long newValue = this.position[d] - 1L;
        if (newValue < this.parentSpace.min(d)) {
            throw new IllegalArgumentException("cannot move specified dimension backward - it would take position outside defined extents");
        }
        int n = d;
        this.position[n] = this.position[n] - 1L;
    }

    public void jumpFwd(long steps) {
        long stepsLeft = steps;
        if (this.isInvalid) {
            this.first();
            --stepsLeft;
        }
        long currPos = this.getIndex();
        long newPos = currPos + stepsLeft;
        this.setIndex(newPos);
    }

    public void jumpBck(long steps) {
        long stepsLeft = steps;
        if (this.isInvalid) {
            this.last();
            --stepsLeft;
        }
        long currPos = this.getIndex();
        long newPos = currPos - stepsLeft;
        this.setIndex(newPos);
    }

    public void move(long delta, int dim) {
        if (this.isInvalid) {
            throw new IllegalArgumentException("Cannot move position : it is uninitialized");
        }
        long newValue = this.position[dim] + delta;
        if (newValue < this.parentSpace.min(dim) || newValue > this.parentSpace.max(dim)) {
            throw new IllegalArgumentException("specified move would take position outside defined extents");
        }
        this.position[dim] = newValue;
    }

    public void move(long[] deltas) {
        for (int i = 0; i < this.position.length; ++i) {
            this.move(deltas[i], i);
        }
    }

    public void move(int distance, int d) {
        this.move((long)distance, d);
    }

    public void move(int[] distance) {
        for (int i = 0; i < distance.length; ++i) {
            this.move((long)distance[i], i);
        }
    }

    public void move(Localizable localizable) {
        for (int i = 0; i < this.position.length; ++i) {
            this.move(localizable.getLongPosition(i), i);
        }
    }

    public void setPosition(long value, int dim) {
        long min = this.parentSpace.min(dim);
        if (value < min) {
            throw new IllegalArgumentException("invalid position for dimension #" + dim + ": " + value + " < " + min);
        }
        long max = this.parentSpace.max(dim);
        if (value > max) {
            throw new IllegalArgumentException("invalid position for dimension #" + dim + ": " + value + " > " + max);
        }
        this.position[dim] = value;
        if (this.isInvalid) {
            this.isInvalid = this.isInvalid();
        }
    }

    public void setPosition(long[] value) {
        for (int i = 0; i < this.position.length; ++i) {
            this.setPosition(value[i], i);
        }
    }

    public void setPosition(int[] position) {
        for (int i = 0; i < position.length; ++i) {
            this.setPosition((long)position[i], i);
        }
    }

    public void setPosition(int position, int d) {
        this.setPosition((long)position, d);
    }

    public void setPosition(Localizable localizable) {
        for (int i = 0; i < this.position.length; ++i) {
            this.setPosition(localizable.getLongPosition(i), i);
        }
    }

    public void setIndex(long index) {
        if (index < 0L || index >= this.parentSpace.numElements()) {
            throw new IllegalArgumentException("specified index value is outside bounds of extents");
        }
        long offset = 1L;
        long r = index;
        for (int i = 0; i < this.position.length; ++i) {
            long offset1 = offset * this.dimension(i);
            long q = i < this.position.length - 1 ? r % offset1 : r;
            this.position[i] = q / offset + this.parentSpace.min(i);
            r -= q;
            offset = offset1;
        }
        this.isInvalid = false;
    }

    public long getIndex() {
        if (this.isInvalid && this.position.length > 0) {
            throw new IllegalArgumentException("Cannot get index value : position is uninitialized");
        }
        long offset = 1L;
        long index1D = 0L;
        for (int i = 0; i < this.position.length; ++i) {
            index1D += offset * (this.position[i] - this.parentSpace.min(i));
            offset *= this.dimension(i);
        }
        return index1D;
    }

    public void localize(int[] pos) {
        if (this.isInvalid && this.position.length > 0) {
            throw new IllegalArgumentException("Cannot localize : position is uninitialized");
        }
        for (int i = 0; i < this.position.length; ++i) {
            pos[i] = (int)this.position[i];
        }
    }

    public void localize(long[] pos) {
        if (this.isInvalid && this.position.length > 0) {
            throw new IllegalArgumentException("Cannot localize : position is uninitialized");
        }
        for (int i = 0; i < this.position.length; ++i) {
            pos[i] = this.position[i];
        }
    }

    public void localize(float[] pos) {
        if (this.isInvalid && this.position.length > 0) {
            throw new IllegalArgumentException("Cannot localize : position is uninitialized");
        }
        for (int i = 0; i < this.position.length; ++i) {
            pos[i] = this.position[i];
        }
    }

    public void localize(double[] pos) {
        if (this.isInvalid && this.position.length > 0) {
            throw new IllegalArgumentException("Cannot localize : position is uninitialized");
        }
        for (int i = 0; i < this.position.length; ++i) {
            pos[i] = this.position[i];
        }
    }

    public int getIntPosition(int d) {
        if (this.isInvalid) {
            throw new IllegalArgumentException("Cannot get position : position is uninitialized");
        }
        return (int)this.position[d];
    }

    public long getLongPosition(int d) {
        if (this.isInvalid) {
            throw new IllegalArgumentException("Cannot get position : position is uninitialized");
        }
        return this.position[d];
    }

    public float getFloatPosition(int d) {
        if (this.isInvalid) {
            throw new IllegalArgumentException("Cannot get position : position is uninitialized");
        }
        return this.position[d];
    }

    public double getDoublePosition(int d) {
        if (this.isInvalid) {
            throw new IllegalArgumentException("Cannot get position : position is uninitialized");
        }
        return this.position[d];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("extents=" + (Object)((Object)this.parentSpace));
        sb.append(", position={");
        for (long p : this.position) {
            sb.append(" " + p);
        }
        sb.append(" }, valid=" + !this.isInvalid);
        return sb.toString();
    }

    private boolean isInvalid() {
        for (int i = 0; i < this.position.length; ++i) {
            if (this.position[i] >= this.parentSpace.min(i) && this.position[i] <= this.parentSpace.max(i)) continue;
            return true;
        }
        return false;
    }
}

