/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.widget;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.histogram.Histogram1d;

public class HistogramBundle {
    private List<Histogram1d<?>> histograms;
    private long binMin = -1L;
    private long binMax = -1L;
    private double theoryMin = Double.NaN;
    private double theoryMax = Double.NaN;
    private double dataMin = Double.NaN;
    private double dataMax = Double.NaN;
    private int preferredSizeX = 300;
    private int preferredSizeY = 150;
    private double slope = Double.NaN;
    private double intercept = Double.NaN;
    private boolean hasChanges;

    public HistogramBundle(Histogram1d<?> hist) {
        this.histograms = new ArrayList();
        this.histograms.add(hist);
        this.hasChanges = true;
    }

    public HistogramBundle(List<Histogram1d<?>> histList) {
        this.histograms = histList;
        this.hasChanges = true;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void setHasChanges(boolean val) {
        this.hasChanges = val;
    }

    public int getHistogramCount() {
        return this.histograms.size();
    }

    public void setHistogram(int index, Histogram1d<?> hist) {
        if (index < 0) {
            throw new IllegalArgumentException("index number less than 0");
        }
        if (index > this.histograms.size()) {
            throw new IllegalArgumentException("index number more than 1 beyond end");
        }
        if (index == this.histograms.size()) {
            if (hist == null) {
                return;
            }
            this.hasChanges = true;
            this.histograms.add(hist);
        } else if (hist == null) {
            this.hasChanges = true;
            this.histograms.remove(index);
        } else {
            this.hasChanges |= hist != this.getHistogram(index);
            this.histograms.set(index, hist);
        }
    }

    public Histogram1d<?> getHistogram(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index number less than 0");
        }
        if (index > this.histograms.size()) {
            throw new IllegalArgumentException("index number beyond end");
        }
        return this.histograms.get(index);
    }

    public void setMinBin(long min) {
        this.hasChanges |= min != this.binMin;
        this.binMin = min;
    }

    public long getMinBin() {
        return this.binMin;
    }

    public void setMaxBin(long max) {
        this.hasChanges |= max != this.binMax;
        this.binMax = max;
    }

    public long getMaxBin() {
        return this.binMax;
    }

    public void setPreferredSize(int x, int y) {
        this.hasChanges |= this.preferredSizeX != x;
        this.hasChanges |= this.preferredSizeY != y;
        this.preferredSizeX = x;
        this.preferredSizeY = y;
    }

    public int getPreferredSizeX() {
        return this.preferredSizeX;
    }

    public int getPreferredSizeY() {
        return this.preferredSizeY;
    }

    public void setLineSlopeIntercept(double slope, double intercept) {
        this.hasChanges |= this.different(slope, this.slope);
        this.hasChanges |= this.different(intercept, this.intercept);
        this.slope = slope;
        this.intercept = intercept;
    }

    public double getLineSlope() {
        return this.slope;
    }

    public double getLineIntercept() {
        return this.intercept;
    }

    public void setDataMinMax(double min, double max) {
        this.hasChanges |= this.different(min, this.dataMin);
        this.hasChanges |= this.different(max, this.dataMax);
        this.dataMin = min;
        this.dataMax = max;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    public void setTheoreticalMinMax(double min, double max) {
        this.hasChanges |= this.different(min, this.theoryMin);
        this.hasChanges |= this.different(max, this.theoryMax);
        this.theoryMin = min;
        this.theoryMax = max;
    }

    public double getTheoreticalMin() {
        return this.theoryMin;
    }

    public double getTheoreticalMax() {
        return this.theoryMax;
    }

    private boolean different(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            return false;
        }
        return v1 != v2;
    }
}

