/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.ImageRegion;
import fiji.plugin.volumeviewer.Transform;
import java.awt.Color;

class Cube {
    private int widthV;
    private int heightV;
    private int depthV;
    private int numIntersections;
    private int[][] cornerT;
    private float[][] corners;
    private float[][] cornersXY;
    private float[][] cornersYZ;
    private float[][] cornersXZ;
    private int[][] cornersXYT;
    private int[][] cornersYZT;
    private int[][] cornersXZT;
    private float[][] interSections;
    private float[][] textPos;
    private Color backColor;
    private Color frontColor;
    private static final int dm = 16;
    private static final int dp = 10;
    private final String[] letters = new String[]{"0", "x", "y", "z"};
    private Transform tr;
    private Control control;

    public void initTextsAndDrawColors(ImageRegion imageRegion) {
        imageRegion.newText(4);
        imageRegion.newLines(24);
        imageRegion.newClipLine(6);
        this.backColor = Color.BLACK;
        this.frontColor = Color.LIGHT_GRAY;
        Color color = Color.orange;
        for (int i = 0; i < this.letters.length; ++i) {
            imageRegion.setText(this.letters[i], i, color);
        }
    }

    void transformCorners(Transform tr) {
        float[] xyzS;
        int i;
        for (i = 0; i < 8; ++i) {
            xyzS = tr.trVol2Screen(this.corners[i]);
            this.cornerT[i][0] = (int)xyzS[0];
            this.cornerT[i][1] = (int)xyzS[1];
            this.cornerT[i][2] = (int)xyzS[2];
        }
        for (i = 0; i < 4; ++i) {
            xyzS = tr.trVol2Screen(this.cornersXY[i]);
            this.cornersXYT[i][0] = (int)xyzS[0];
            this.cornersXYT[i][1] = (int)xyzS[1];
            this.cornersXYT[i][2] = (int)xyzS[2];
            xyzS = tr.trVol2Screen(this.cornersYZ[i]);
            this.cornersYZT[i][0] = (int)xyzS[0];
            this.cornersYZT[i][1] = (int)xyzS[1];
            this.cornersYZT[i][2] = (int)xyzS[2];
            xyzS = tr.trVol2Screen(this.cornersXZ[i]);
            this.cornersXZT[i][0] = (int)xyzS[0];
            this.cornersXZT[i][1] = (int)xyzS[1];
            this.cornersXZT[i][2] = (int)xyzS[2];
        }
    }

    public void setTextAndLines(ImageRegion imageRegion) {
        if (imageRegion == null) {
            return;
        }
        for (int i = 0; i < this.textPos.length; ++i) {
            float[] xyzS = this.tr.trVol2Screen(this.textPos[i]);
            imageRegion.setTextPos(i, (int)xyzS[0], (int)xyzS[1], (int)xyzS[2]);
        }
        float zMax = -1.0E7f;
        int iHidden = -1;
        for (int i = 0; i < 8; ++i) {
            if (!((float)this.cornerT[i][2] > zMax)) continue;
            zMax = this.cornerT[i][2];
            iHidden = i;
        }
        int line = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 4; j < 8; ++j) {
                Color c;
                if (i + j == 7) continue;
                int z = i == iHidden || j == iHidden ? 1 : -1;
                Color color = c = z <= 0 ? this.frontColor : this.backColor;
                if (!this.control.showAxes) {
                    c = new Color(0, 0, 0, 0);
                }
                imageRegion.setLine(line++, this.cornerT[i][0], this.cornerT[i][1], this.cornerT[j][0], this.cornerT[j][1], z, c);
            }
        }
        Color color = Color.red;
        int[][] corT = this.cornersXZT;
        for (int s = 0; s < 3; ++s) {
            int i;
            if (s == 1) {
                color = Color.green;
                corT = this.cornersYZT;
            } else if (s == 2) {
                color = Color.cyan;
                corT = this.cornersXYT;
            }
            zMax = -1.0E7f;
            iHidden = -1;
            for (i = 0; i < 4; ++i) {
                if (!((float)corT[i][2] > zMax)) continue;
                zMax = corT[i][2];
                iHidden = i;
            }
            for (i = 0; i < 4; ++i) {
                int ip1 = i < 3 ? i + 1 : 0;
                int z = i == iHidden || ip1 == iHidden ? 1 : -1;
                Color c = this.control.showSlices ? color : new Color(0, 0, 0, 0);
                imageRegion.setLine(line++, corT[i][0], corT[i][1], corT[ip1][0], corT[ip1][1], z, c);
            }
        }
    }

    boolean isInside(int x, int y) {
        int[] p = new int[3];
        p[0] = x;
        p[1] = y;
        if (this.inside(p, this.cornerT[0], this.cornerT[1], this.cornerT[4])) {
            return true;
        }
        if (this.inside(p, this.cornerT[0], this.cornerT[1], this.cornerT[5])) {
            return true;
        }
        if (this.inside(p, this.cornerT[2], this.cornerT[3], this.cornerT[6])) {
            return true;
        }
        if (this.inside(p, this.cornerT[2], this.cornerT[3], this.cornerT[7])) {
            return true;
        }
        if (this.inside(p, this.cornerT[1], this.cornerT[3], this.cornerT[5])) {
            return true;
        }
        if (this.inside(p, this.cornerT[1], this.cornerT[3], this.cornerT[7])) {
            return true;
        }
        if (this.inside(p, this.cornerT[0], this.cornerT[2], this.cornerT[4])) {
            return true;
        }
        if (this.inside(p, this.cornerT[0], this.cornerT[2], this.cornerT[6])) {
            return true;
        }
        if (this.inside(p, this.cornerT[1], this.cornerT[2], this.cornerT[4])) {
            return true;
        }
        if (this.inside(p, this.cornerT[1], this.cornerT[2], this.cornerT[7])) {
            return true;
        }
        if (this.inside(p, this.cornerT[0], this.cornerT[3], this.cornerT[5])) {
            return true;
        }
        return this.inside(p, this.cornerT[0], this.cornerT[3], this.cornerT[6]);
    }

    private boolean inside(int[] p, int[] p1, int[] p2, int[] p3) {
        float x = p[0];
        float y = p[1];
        float x1 = p1[0];
        float y1 = p1[1];
        float x2 = p2[0];
        float y2 = p2[1];
        float x3 = p3[0];
        float y3 = p3[1];
        float a = (x2 - x1) * (y - y1) - (y2 - y1) * (x - x1);
        float b = (x3 - x2) * (y - y2) - (y3 - y2) * (x - x2);
        float c = (x1 - x3) * (y - y3) - (y1 - y3) * (x - x3);
        return a >= 0.0f && b >= 0.0f && c >= 0.0f || a <= 0.0f && b <= 0.0f && c <= 0.0f;
    }

    void findIntersections(float d) {
        int i;
        this.numIntersections = 0;
        for (i = 0; i < 4; ++i) {
            for (int j = 4; j < 8; ++j) {
                if (i + j == 7) continue;
                this.findIntersection(this.corners[i], this.corners[j], d);
            }
        }
        if (this.numIntersections == 0) {
            this.numIntersections = 1;
        }
        for (i = this.numIntersections; i < this.getInterSections().length; ++i) {
            this.getInterSections()[i][0] = this.getInterSections()[this.numIntersections - 1][0];
            this.getInterSections()[i][1] = this.getInterSections()[this.numIntersections - 1][1];
            this.getInterSections()[i][2] = this.getInterSections()[this.numIntersections - 1][2];
        }
    }

    void findSliceIntersectionsXY(float d) {
        this.numIntersections = 0;
        this.findIntersection(this.cornersXY[0], this.cornersXY[1], d);
        this.findIntersection(this.cornersXY[1], this.cornersXY[2], d);
        this.findIntersection(this.cornersXY[2], this.cornersXY[3], d);
        this.findIntersection(this.cornersXY[3], this.cornersXY[0], d);
    }

    void findSliceIntersectionsYZ(float d) {
        this.numIntersections = 0;
        this.findIntersection(this.cornersYZ[0], this.cornersYZ[1], d);
        this.findIntersection(this.cornersYZ[1], this.cornersYZ[2], d);
        this.findIntersection(this.cornersYZ[2], this.cornersYZ[3], d);
        this.findIntersection(this.cornersYZ[3], this.cornersYZ[0], d);
    }

    void findIntersections_xz(float d) {
        this.numIntersections = 0;
        this.findIntersection(this.cornersXZ[0], this.cornersXZ[1], d);
        this.findIntersection(this.cornersXZ[1], this.cornersXZ[2], d);
        this.findIntersection(this.cornersXZ[2], this.cornersXZ[3], d);
        this.findIntersection(this.cornersXZ[3], this.cornersXZ[0], d);
    }

    private void findIntersection(float[] p0, float[] p1, float d) {
        float t;
        float[] xyzS = this.tr.trVol2Screen(p0);
        float z0 = xyzS[2];
        float z1 = (xyzS = this.tr.trVol2Screen(p1))[2];
        if (z0 - z1 != 0.0f && (t = (z0 - d) / (z0 - z1)) >= 0.0f && t <= 1.0f) {
            float x0 = p0[0];
            float y0 = p0[1];
            z0 = p0[2];
            float x1 = p1[0];
            float y1 = p1[1];
            z1 = p1[2];
            float xs = x0 + t * (x1 - x0);
            float ys = y0 + t * (y1 - y0);
            float zs = z0 + t * (z1 - z0);
            xyzS = this.tr.trVol2Screen(xs, ys, zs);
            boolean newIntersection = true;
            for (int i = 0; i < this.numIntersections; ++i) {
                if (this.getInterSections()[i][0] != xs || this.getInterSections()[i][1] != ys || this.getInterSections()[i][2] != zs) continue;
                newIntersection = false;
            }
            if (newIntersection) {
                this.getInterSections()[this.numIntersections][0] = xs;
                this.getInterSections()[this.numIntersections][1] = ys;
                this.getInterSections()[this.numIntersections][2] = zs;
                ++this.numIntersections;
            }
        }
    }

    Cube(Control control, int widthV, int heightV, int depthV) {
        this.control = control;
        this.widthV = widthV;
        this.heightV = heightV;
        this.depthV = depthV;
        this.corners = new float[8][3];
        this.cornerT = new int[8][3];
        this.setInterSections(new float[6][3]);
        this.cornersXY = new float[4][3];
        this.cornersYZ = new float[4][3];
        this.cornersXZ = new float[4][3];
        this.cornersXYT = new int[4][3];
        this.cornersYZT = new int[4][3];
        this.cornersXZT = new int[4][3];
        this.textPos = new float[4][3];
    }

    public float[][] getInterSections() {
        return this.interSections;
    }

    public void setInterSections(float[][] interSections) {
        this.interSections = interSections;
    }

    public void setTextPositions(float scale, float zAspect) {
        this.textPos[0][0] = -16.0f / scale;
        this.textPos[0][1] = -16.0f / scale;
        this.textPos[0][2] = -16.0f / (scale * zAspect);
        this.textPos[1][0] = (float)this.widthV + 10.0f / scale;
        this.textPos[1][1] = -16.0f / scale;
        this.textPos[1][2] = -16.0f / (scale * zAspect);
        this.textPos[2][0] = -16.0f / scale;
        this.textPos[2][1] = (float)this.heightV + 10.0f / scale;
        this.textPos[2][2] = -16.0f / (scale * zAspect);
        this.textPos[3][0] = -16.0f / scale;
        this.textPos[3][1] = -16.0f / scale;
        this.textPos[3][2] = (float)this.depthV + 10.0f / (scale * zAspect);
    }

    public void setCornersYZ(float xV) {
        float f = xV + 0.5f;
        this.cornersYZ[3][0] = f;
        this.cornersYZ[2][0] = f;
        this.cornersYZ[1][0] = f;
        this.cornersYZ[0][0] = f;
        this.transformCorners(this.tr);
    }

    public void setCornersXZ(float yV) {
        float f = yV + 0.5f;
        this.cornersXZ[3][1] = f;
        this.cornersXZ[2][1] = f;
        this.cornersXZ[1][1] = f;
        this.cornersXZ[0][1] = f;
        this.transformCorners(this.tr);
    }

    public void setCornersXY(float zV) {
        float f = zV + 0.5f;
        this.cornersXY[3][2] = f;
        this.cornersXY[2][2] = f;
        this.cornersXY[1][2] = f;
        this.cornersXY[0][2] = f;
        this.transformCorners(this.tr);
    }

    public void setSlicePositions(float positionFactorX, float positionFactorY, float positionFactorZ, float zAspect) {
        this.corners[1][1] = this.heightV;
        this.corners[1][2] = this.depthV;
        this.corners[2][0] = this.widthV;
        this.corners[2][2] = this.depthV;
        this.corners[3][0] = this.widthV;
        this.corners[3][1] = this.heightV;
        this.corners[4][2] = this.depthV;
        this.corners[5][1] = this.heightV;
        this.corners[6][0] = this.widthV;
        this.corners[7][0] = this.widthV;
        this.corners[7][1] = this.heightV;
        this.corners[7][2] = this.depthV;
        this.cornersXY[0][0] = 0.0f;
        this.cornersXY[1][0] = this.widthV;
        this.cornersXY[2][0] = this.widthV;
        this.cornersXY[3][0] = 0.0f;
        this.cornersXY[0][1] = 0.0f;
        this.cornersXY[1][1] = 0.0f;
        this.cornersXY[2][1] = this.heightV;
        this.cornersXY[3][1] = this.heightV;
        this.cornersXY[0][2] = (float)this.depthV * positionFactorZ - 0.5f;
        this.cornersXY[1][2] = (float)this.depthV * positionFactorZ - 0.5f;
        this.cornersXY[2][2] = (float)this.depthV * positionFactorZ - 0.5f;
        this.cornersXY[3][2] = (float)this.depthV * positionFactorZ - 0.5f;
        this.cornersYZ[0][0] = (float)this.widthV * positionFactorX - 0.5f;
        this.cornersYZ[1][0] = (float)this.widthV * positionFactorX - 0.5f;
        this.cornersYZ[2][0] = (float)this.widthV * positionFactorX - 0.5f;
        this.cornersYZ[3][0] = (float)this.widthV * positionFactorX - 0.5f;
        this.cornersYZ[0][1] = 0.0f;
        this.cornersYZ[1][1] = 0.0f;
        this.cornersYZ[2][1] = this.heightV;
        this.cornersYZ[3][1] = this.heightV;
        this.cornersYZ[0][2] = 0.0f;
        this.cornersYZ[1][2] = this.depthV;
        this.cornersYZ[2][2] = this.depthV;
        this.cornersYZ[3][2] = 0.0f;
        this.cornersXZ[0][0] = 0.0f;
        this.cornersXZ[1][0] = 0.0f;
        this.cornersXZ[2][0] = this.widthV;
        this.cornersXZ[3][0] = this.widthV;
        this.cornersXZ[0][1] = (float)this.heightV * positionFactorY - 0.5f;
        this.cornersXZ[1][1] = (float)this.heightV * positionFactorY - 0.5f;
        this.cornersXZ[2][1] = (float)this.heightV * positionFactorY - 0.5f;
        this.cornersXZ[3][1] = (float)this.heightV * positionFactorY - 0.5f;
        this.cornersXZ[0][2] = 0.0f;
        this.cornersXZ[1][2] = this.depthV;
        this.cornersXZ[2][2] = this.depthV;
        this.cornersXZ[3][2] = 0.0f;
        this.textPos[0][0] = -16.0f;
        this.textPos[0][1] = -16.0f;
        this.textPos[0][2] = -16.0f / zAspect;
        this.textPos[1][0] = this.widthV + 10;
        this.textPos[1][1] = -16.0f;
        this.textPos[1][2] = -16.0f / zAspect;
        this.textPos[2][0] = -16.0f;
        this.textPos[2][1] = this.heightV + 10;
        this.textPos[2][2] = -16.0f / zAspect;
        this.textPos[3][0] = -16.0f;
        this.textPos[3][1] = -16.0f;
        this.textPos[3][2] = (float)this.depthV + 10.0f / zAspect;
    }

    public float[][] getCorners() {
        return this.corners;
    }

    public void setTransform(Transform tr) {
        this.tr = tr;
    }
}

