/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.Point;

public class PointMatch
implements Serializable {
    private static final long serialVersionUID = -3943684962223800732L;
    protected double strength = 1.0;
    protected final Point p1;
    protected final Point p2;
    protected double[] weights;
    protected double weight;

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }

    protected void calculateWeight() {
        this.weight = 1.0;
        for (double wi : this.weights) {
            this.weight *= wi;
        }
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = (double[])weights.clone();
        this.calculateWeight();
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(int index, double weight) {
        this.weights[index] = weight;
        this.calculateWeight();
    }

    public double popWeight() {
        int l = this.weights.length - 1;
        double w = this.weights[l];
        if (l > 0) {
            double[] newWeights = new double[l];
            System.arraycopy(this.weights, 0, newWeights, 0, l);
            this.weights = newWeights;
            this.calculateWeight();
        } else {
            this.weight = 1.0;
            this.weights[0] = 1.0;
        }
        return w;
    }

    public void pushWeight(double w) {
        double[] newWeights = new double[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 0, this.weights.length);
        newWeights[this.weights.length] = w;
        this.weights = newWeights;
        this.weight *= w;
    }

    public double shiftWeight() {
        int l = this.weights.length - 1;
        double w = this.weights[0];
        if (l > 0) {
            double[] newWeights = new double[l];
            System.arraycopy(this.weights, 1, newWeights, 0, l);
            this.weights = newWeights;
            this.calculateWeight();
        } else {
            this.weight = 1.0;
            this.weights[0] = 1.0;
        }
        return w;
    }

    public void unshiftWeight(double w) {
        double[] newWeights = new double[this.weights.length + 1];
        System.arraycopy(this.weights, 0, newWeights, 1, this.weights.length);
        newWeights[0] = w;
        this.weights = newWeights;
        this.weight *= w;
    }

    public double getDistance() {
        return Point.distance(this.p1, this.p2);
    }

    public PointMatch(Point p1, Point p2, double[] weights, double strength) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = (double[])weights.clone();
        this.calculateWeight();
        this.strength = strength;
    }

    public PointMatch(Point p1, Point p2, double[] weights) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = (double[])weights.clone();
        this.calculateWeight();
    }

    public PointMatch(Point p1, Point p2, double weight) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new double[]{weight};
        this.weight = weight;
    }

    public PointMatch(Point p1, Point p2, double weight, double strength) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new double[]{weight};
        this.weight = weight;
        this.strength = strength;
    }

    public PointMatch(Point p1, Point p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.weights = new double[]{1.0};
        this.weight = 1.0;
    }

    public void apply(CoordinateTransform t) {
        this.p1.apply(t);
    }

    public void apply(CoordinateTransform t, double amount) {
        this.p1.apply(t, this.strength * amount);
    }

    public static void apply(Collection<? extends PointMatch> matches, CoordinateTransform t) {
        for (PointMatch pointMatch : matches) {
            pointMatch.apply(t);
        }
    }

    public static final void flip(Collection<PointMatch> matches, Collection<PointMatch> flippedMatches) {
        for (PointMatch match : matches) {
            flippedMatches.add(new PointMatch(match.p2, match.p1, match.weights));
        }
    }

    public static final Collection<PointMatch> flip(Collection<PointMatch> matches) {
        ArrayList<PointMatch> list = new ArrayList<PointMatch>();
        PointMatch.flip(matches, list);
        return list;
    }

    public static final void sourcePoints(Collection<PointMatch> matches, Collection<Point> sourcePoints) {
        for (PointMatch m : matches) {
            sourcePoints.add(m.getP1());
        }
    }

    public static final void cloneSourcePoints(Collection<PointMatch> matches, Collection<Point> sourcePoints) {
        for (PointMatch m : matches) {
            sourcePoints.add(m.getP1().clone());
        }
    }

    public static final void targetPoints(Collection<PointMatch> matches, Collection<Point> targetPoints) {
        for (PointMatch m : matches) {
            targetPoints.add(m.getP2());
        }
    }

    public static final void cloneTargetPoints(Collection<PointMatch> matches, Collection<Point> targetPoints) {
        for (PointMatch m : matches) {
            targetPoints.add(m.getP2().clone());
        }
    }

    public static double meanDistance(Collection<PointMatch> matches) {
        double d = 0.0;
        for (PointMatch match : matches) {
            d += match.getDistance();
        }
        return d / (double)matches.size();
    }

    public static double maxDistance(Collection<PointMatch> matches) {
        double max = -1.7976931348623157E308;
        for (PointMatch match : matches) {
            double d = match.getDistance();
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }
}

