/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.io.gui.RoundBorder;
import org.scijava.ui.behaviour.io.gui.TagPanelEditor;

public class InputTriggerPanelEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String COMMIT_ACTION = "commit";
    private final List<KeyItem> keyItems;
    private final JTextField textField;
    private final HashSet<InputTriggerChangeListener> listeners;
    private InputTrigger trigger = InputTrigger.NOT_MAPPED;
    private InputTrigger lastValidInputTrigger = InputTrigger.NOT_MAPPED;
    private String invalidTriggerStr = null;
    private static final List<String> INPUT_TRIGGER_SYNTAX_TAGS;
    private static final List<String> INPUT_TRIGGER_SYNTAX_TAGS_SORTED;
    private static final List<String> INPUT_TRIGGER_SYNTAX_TAGS_SMALL_CAPS;
    private static final Map<String, String> TRIGGER_SYMBOLS;
    private static final Map<String, String> INPUT_TRIGGER_SYNTAX_TAG_REMAP;

    public InputTriggerPanelEditor(boolean editable) {
        this.keyItems = new ArrayList<KeyItem>();
        this.listeners = new HashSet();
        this.setPreferredSize(new Dimension(400, 26));
        this.setMinimumSize(new Dimension(26, 26));
        this.setLayout(new BoxLayout(this, 2));
        this.textField = new JTextField();
        this.textField.setColumns(10);
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField.setOpaque(false);
        this.textField.setEditable(editable);
        if (editable) {
            Autocomplete autoComplete = new Autocomplete();
            this.textField.getDocument().addDocumentListener(autoComplete);
            this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), COMMIT_ACTION);
            this.textField.getInputMap().put(KeyStroke.getKeyStroke(' '), COMMIT_ACTION);
            this.textField.setFocusTraversalKeys(0, Collections.emptySet());
            this.textField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMMIT_ACTION);
            this.textField.getActionMap().put(COMMIT_ACTION, autoComplete.new Autocomplete.CommitAction());
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 8 && InputTriggerPanelEditor.this.textField.getText().isEmpty() && !InputTriggerPanelEditor.this.keyItems.isEmpty()) {
                        InputTriggerPanelEditor.this.removeLastKeyItem();
                        e.consume();
                    }
                }
            });
        }
        this.add(this.textField);
        this.add(Box.createHorizontalGlue());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setBackground(UIManager.getColor("TextField.background"));
    }

    public void setInputTrigger(InputTrigger trigger) {
        this.trigger = trigger;
        this.lastValidInputTrigger = trigger;
        this.invalidTriggerStr = null;
        this.regenKeyPanels();
    }

    public InputTrigger getInputTrigger() {
        return this.trigger;
    }

    public InputTrigger getLastValidInputTrigger() {
        return this.lastValidInputTrigger;
    }

    private void checkAndAppendKey(String key) {
        String trimmed = key.trim();
        if (trimmed.equals("|")) {
            String str = null == this.trigger || this.trigger == InputTrigger.NOT_MAPPED ? trimmed : this.trigger.toString() + " " + trimmed;
            this.trigger = null;
            this.invalidTriggerStr = str.trim();
            this.regenKeyPanels();
            return;
        }
        String properCapKey = null;
        for (int i = 0; i < INPUT_TRIGGER_SYNTAX_TAGS.size(); ++i) {
            if (!INPUT_TRIGGER_SYNTAX_TAGS.get(i).equalsIgnoreCase(trimmed)) continue;
            properCapKey = INPUT_TRIGGER_SYNTAX_TAGS.get(i);
            break;
        }
        if (null != properCapKey) {
            properCapKey = INPUT_TRIGGER_SYNTAX_TAG_REMAP.getOrDefault(properCapKey, properCapKey);
            String str = null == this.trigger ? this.invalidTriggerStr + " " + properCapKey : (this.trigger == InputTrigger.NOT_MAPPED ? properCapKey : this.trigger.toString() + " " + properCapKey);
            try {
                this.lastValidInputTrigger = this.trigger = InputTrigger.getFromString(str);
                this.invalidTriggerStr = null;
            }
            catch (IllegalArgumentException iae) {
                this.trigger = null;
                this.invalidTriggerStr = str.trim();
            }
            this.regenKeyPanels();
        }
    }

    private void removeLastKeyItem() {
        String[] tokens = null == this.trigger ? this.invalidTriggerStr.split(" ") : this.trigger.toString().split(" ");
        if (tokens.length == 0) {
            return;
        }
        InputTriggerPanelEditor.sortTokens(tokens);
        StringBuilder strBlder = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            strBlder.append(tokens[i] + " ");
        }
        String str = strBlder.toString();
        try {
            this.lastValidInputTrigger = this.trigger = str.isEmpty() ? InputTrigger.NOT_MAPPED : InputTrigger.getFromString(str);
            this.invalidTriggerStr = null;
        }
        catch (IllegalArgumentException iae) {
            this.trigger = null;
            this.invalidTriggerStr = str.trim();
        }
        this.regenKeyPanels();
        this.notifyListeners();
    }

    private void regenKeyPanels() {
        boolean valid;
        String[] tokens;
        for (KeyItem keyItem : this.keyItems) {
            this.remove(keyItem);
        }
        this.keyItems.clear();
        if (null == this.trigger) {
            tokens = this.invalidTriggerStr.split(" ");
            valid = false;
        } else {
            valid = true;
            tokens = this.trigger == InputTrigger.NOT_MAPPED ? new String[]{} : this.trigger.toString().split(" ");
        }
        if (tokens.length == 0) {
            this.lastValidInputTrigger = this.trigger = InputTrigger.NOT_MAPPED;
            this.invalidTriggerStr = null;
        } else {
            InputTriggerPanelEditor.sortTokens(tokens);
            for (String key : tokens) {
                KeyItem tagp = new KeyItem(key, valid);
                this.keyItems.add(tagp);
                this.add((Component)tagp, this.getComponentCount() - 2);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textField.requestFocusInWindow();
    }

    private void notifyListeners() {
        for (InputTriggerChangeListener listener : this.listeners) {
            listener.inputTriggerChanged();
        }
    }

    public void addInputTriggerChangeListener(InputTriggerChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeInputTriggerChangeListener(InputTriggerChangeListener listener) {
        this.listeners.remove(listener);
    }

    private static final void sortTokens(String[] tokens) {
        int vbarIndex = -1;
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals("|")) continue;
            vbarIndex = i;
            break;
        }
        if (vbarIndex >= 0) {
            Arrays.sort(tokens, 0, vbarIndex, Comparator.comparingInt(INPUT_TRIGGER_SYNTAX_TAGS::indexOf));
            Arrays.sort(tokens, vbarIndex + 1, tokens.length, Comparator.comparingInt(INPUT_TRIGGER_SYNTAX_TAGS::indexOf));
        } else {
            Arrays.sort(tokens, Comparator.comparingInt(INPUT_TRIGGER_SYNTAX_TAGS::indexOf));
        }
    }

    private static boolean isMac() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        return OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0;
    }

    static {
        int i;
        INPUT_TRIGGER_SYNTAX_TAGS = new ArrayList<String>();
        INPUT_TRIGGER_SYNTAX_TAGS_SORTED = new ArrayList<String>();
        TRIGGER_SYMBOLS = new HashMap<String, String>();
        INPUT_TRIGGER_SYNTAX_TAG_REMAP = new HashMap<String, String>();
        INPUT_TRIGGER_SYNTAX_TAGS.addAll(Arrays.asList("all", "ctrl", "alt", "altGraph", "shift", "meta", "command", "cmd", "win", "ENTER", "BACK_SPACE", "TAB", "CANCEL", "CLEAR", "COMPOSE", "PAUSE", "CAPS_LOCK", "ESCAPE", "SPACE", "PAGE_UP", "PAGE_DOWN", "END", "HOME", "BEGIN", "COMMA", "PERIOD", "SLASH", "SEMICOLON", "EQUALS", "OPEN_BRACKET", "BACK_SLASH", "CLOSE_BRACKET", "LEFT", "UP", "RIGHT", "DOWN", "NUMPAD0", "NUMPAD1", "NUMPAD2", "NUMPAD3", "NUMPAD4", "NUMPAD5", "NUMPAD6", "NUMPAD7", "NUMPAD8", "NUMPAD9", "MULTIPLY", "ADD", "SEPARATOR", "SUBTRACT", "DECIMAL", "DIVIDE", "DELETE", "NUM_LOCK", "SCROLL_LOCK", "double-click", "button1", "button2", "button3", "scroll", "|"));
        for (i = 0; i < 26; ++i) {
            INPUT_TRIGGER_SYNTAX_TAGS.add(String.valueOf((char)(65 + i)));
        }
        for (i = 0; i < 10; ++i) {
            INPUT_TRIGGER_SYNTAX_TAGS.add("" + i);
        }
        for (i = 1; i <= 24; ++i) {
            INPUT_TRIGGER_SYNTAX_TAGS.add("F" + i);
        }
        INPUT_TRIGGER_SYNTAX_TAGS_SORTED.addAll(INPUT_TRIGGER_SYNTAX_TAGS);
        INPUT_TRIGGER_SYNTAX_TAGS_SORTED.sort(String.CASE_INSENSITIVE_ORDER);
        INPUT_TRIGGER_SYNTAX_TAGS_SMALL_CAPS = new ArrayList<String>(INPUT_TRIGGER_SYNTAX_TAGS_SORTED.size());
        for (String tag : INPUT_TRIGGER_SYNTAX_TAGS_SORTED) {
            INPUT_TRIGGER_SYNTAX_TAGS_SMALL_CAPS.add(tag.toLowerCase());
        }
        INPUT_TRIGGER_SYNTAX_TAG_REMAP.put("cmd", "meta");
        INPUT_TRIGGER_SYNTAX_TAG_REMAP.put("command", "meta");
        INPUT_TRIGGER_SYNTAX_TAG_REMAP.put("windows", "win");
        TRIGGER_SYMBOLS.put("ENTER", "\u23ce");
        TRIGGER_SYMBOLS.put("BACK_SPACE", "\u232b");
        TRIGGER_SYMBOLS.put("DELETE", "\u2326");
        TRIGGER_SYMBOLS.put("TAB", "\u21e5");
        TRIGGER_SYMBOLS.put("PAUSE", "||");
        TRIGGER_SYMBOLS.put("CAPS_LOCK", "\u21ea");
        TRIGGER_SYMBOLS.put("PAGE_UP", "\u21de");
        TRIGGER_SYMBOLS.put("PAGE_DOWN", "\u21df");
        TRIGGER_SYMBOLS.put("END", "\u2198");
        TRIGGER_SYMBOLS.put("HOME", "\u2196");
        TRIGGER_SYMBOLS.put("ESCAPE", "\u238b");
        TRIGGER_SYMBOLS.put("LEFT", "\u2190");
        TRIGGER_SYMBOLS.put("UP", "\u2191");
        TRIGGER_SYMBOLS.put("RIGHT", "\u2192");
        TRIGGER_SYMBOLS.put("DOWN", "\u2193");
        TRIGGER_SYMBOLS.put("NUMPAD0", "\u24ea");
        TRIGGER_SYMBOLS.put("NUMPAD1", "\u2460");
        TRIGGER_SYMBOLS.put("NUMPAD2", "\u2461");
        TRIGGER_SYMBOLS.put("NUMPAD3", "\u2462");
        TRIGGER_SYMBOLS.put("NUMPAD4", "\u2463");
        TRIGGER_SYMBOLS.put("NUMPAD5", "\u2464");
        TRIGGER_SYMBOLS.put("NUMPAD6", "\u2465");
        TRIGGER_SYMBOLS.put("NUMPAD7", "\u2466");
        TRIGGER_SYMBOLS.put("NUMPAD8", "\u2467");
        TRIGGER_SYMBOLS.put("NUMPAD9", "\u2468");
        TRIGGER_SYMBOLS.put("MULTIPLY", "\u00d7");
        TRIGGER_SYMBOLS.put("DIVIDE", "\u00f7");
        TRIGGER_SYMBOLS.put("ADD", "+");
        TRIGGER_SYMBOLS.put("SUBTRACT", "-");
        TRIGGER_SYMBOLS.put("COMMA", ",");
        TRIGGER_SYMBOLS.put("PERIOD", ".");
        TRIGGER_SYMBOLS.put("SLASH", "/");
        TRIGGER_SYMBOLS.put("SEMICOLON", ";");
        TRIGGER_SYMBOLS.put("EQUALS", "=");
        TRIGGER_SYMBOLS.put("OPEN_BRACKET", "[");
        TRIGGER_SYMBOLS.put("BACK_SLASH", "\\");
        TRIGGER_SYMBOLS.put("CLOSE_BRACKET", "]");
        TRIGGER_SYMBOLS.put("ctrl", "\u2303");
        TRIGGER_SYMBOLS.put("alt", "\u2387");
        TRIGGER_SYMBOLS.put("shift", "\u21e7");
        TRIGGER_SYMBOLS.put("meta", InputTriggerPanelEditor.isMac() ? "\u2318" : "\u25c6");
        TRIGGER_SYMBOLS.put("win", "\u2756");
        TRIGGER_SYMBOLS.put("|", "    |    ");
    }

    private final class KeyItem
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final boolean valid;
        private final JLabel txt;

        public KeyItem(String tag, boolean valid) {
            this.valid = valid;
            String str = TRIGGER_SYMBOLS.containsKey(tag) ? " " + (String)TRIGGER_SYMBOLS.get(tag) + " " : " " + tag + " ";
            this.txt = new JLabel(str);
            this.txt.setOpaque(true);
            this.updateTxtLook();
            this.setLayout(new BoxLayout(this, 2));
            this.add(Box.createHorizontalStrut(1));
            this.add(this.txt);
            this.add(Box.createHorizontalStrut(1));
            this.setOpaque(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.updateTxtLook();
        }

        private void updateTxtLook() {
            if (this.txt != null) {
                Color tfg = UIManager.getColor("TextField.foreground");
                Color tbg = UIManager.getColor("TextField.background");
                Color bg = this.valid ? TagPanelEditor.mix(tbg, tfg, 0.95) : TagPanelEditor.mix(tbg, Color.red, 0.5);
                Color borderColor = TagPanelEditor.mix(bg, tfg, 0.8);
                this.txt.setBackground(bg);
                this.txt.setBorder(new RoundBorder(borderColor, InputTriggerPanelEditor.this, 1));
                Font font = UIManager.getFont("Label.font");
                font = font.deriveFont(font.getSize2D() - 2.0f);
                this.txt.setFont(font);
            }
        }
    }

    private class Autocomplete
    implements DocumentListener {
        private Autocomplete() {
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            String match;
            int w;
            if (ev.getLength() != 1) {
                return;
            }
            int pos = ev.getOffset();
            String content = null;
            try {
                content = InputTriggerPanelEditor.this.textField.getText(0, pos + 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            for (w = pos; w >= 0 && Character.isLetter(content.charAt(w)); --w) {
            }
            if (pos - w < 2) {
                return;
            }
            String prefix = content.substring(w + 1);
            int n = Collections.binarySearch(INPUT_TRIGGER_SYNTAX_TAGS_SMALL_CAPS, prefix.toLowerCase());
            if (n < 0 && -n <= INPUT_TRIGGER_SYNTAX_TAGS_SORTED.size() && (match = (String)INPUT_TRIGGER_SYNTAX_TAGS_SORTED.get(-n - 1)).toLowerCase().startsWith(prefix.toLowerCase())) {
                String completion = match.substring(pos - w);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1));
            }
        }

        private class CompletionTask
        implements Runnable {
            private final String completion;
            private final int position;

            CompletionTask(String completion, int position) {
                this.completion = completion;
                this.position = position;
            }

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer(InputTriggerPanelEditor.this.textField.getText());
                sb.insert(this.position, this.completion);
                InputTriggerPanelEditor.this.textField.setText(sb.toString());
                InputTriggerPanelEditor.this.textField.setCaretPosition(this.position + this.completion.length());
                InputTriggerPanelEditor.this.textField.moveCaretPosition(this.position);
            }
        }

        public class CommitAction
        extends AbstractAction {
            private static final long serialVersionUID = 5794543109646743416L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                String key = InputTriggerPanelEditor.this.textField.getText().trim();
                if (key.isEmpty()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    return;
                }
                InputTriggerPanelEditor.this.checkAndAppendKey(key);
                InputTriggerPanelEditor.this.textField.setText("");
                InputTriggerPanelEditor.this.notifyListeners();
            }
        }
    }

    @FunctionalInterface
    public static interface InputTriggerChangeListener {
        public void inputTriggerChanged();
    }
}

