/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.InputTriggerDescription;
import org.scijava.ui.behaviour.io.InputTriggerDescriptionsBuilder;
import org.scijava.ui.behaviour.io.gui.Command;
import org.scijava.ui.behaviour.io.gui.InputTriggerPanelEditor;
import org.scijava.ui.behaviour.io.gui.TagPanelEditor;

public class VisualEditorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static JFileChooser fileChooser = new JFileChooser();
    private JTextField textFieldFilter;
    private MyTableModel tableModel;
    private TableRowSorter<MyTableModel> tableRowSorter;
    private boolean blockRemoveNotMapped = false;
    private final InputTriggerPanelEditor keybindingEditor;
    private final TagPanelEditor contextsEditor;
    private final JLabel labelCommandName;
    private final JTable tableBindings;
    private final InputTriggerConfig config;
    private final Set<Command> commands;
    private final Map<String, Set<String>> commandNameToAcceptableContexts;
    private final Map<Command, String> actionDescriptions;
    private final JLabel lblConflict;
    private final JTextArea textAreaDescription;
    private final JPanel panelEditor;
    private final JPanel panelButtons;
    private final Listeners.List<ConfigChangeListener> modelChangedListeners;
    private final Listeners.List<ConfigChangeListener> configCommittedListeners;
    private final JButton btnApply;
    private final JButton btnRestore;
    private static final String CSV_SEPARATOR = ",";
    private static final Comparator<MyTableRow> MyTableRowComparator;
    private static final Comparator<InputTrigger> InputTriggerComparator;

    public VisualEditorPanel(InputTriggerConfig config) {
        this(config, VisualEditorPanel.extractEmptyCommandDescriptions(config));
    }

    public VisualEditorPanel(InputTriggerConfig config, Map<Command, String> commandDescriptions) {
        this.config = config;
        this.actionDescriptions = commandDescriptions;
        this.commands = commandDescriptions.keySet();
        this.commandNameToAcceptableContexts = new HashMap<String, Set<String>>();
        for (Command command : this.commands) {
            this.commandNameToAcceptableContexts.computeIfAbsent(command.getName(), k -> new HashSet()).add(command.getContext());
        }
        this.modelChangedListeners = new Listeners.SynchronizedList<ConfigChangeListener>();
        this.configCommittedListeners = new Listeners.SynchronizedList<ConfigChangeListener>();
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelFilter = new JPanel();
        this.add((Component)panelFilter, "North");
        panelFilter.setLayout(new BoxLayout(panelFilter, 0));
        Component horizontalStrut = Box.createHorizontalStrut(5);
        panelFilter.add(horizontalStrut);
        JLabel lblFilter = new JLabel("Filter:");
        lblFilter.setToolTipText("Filter on command names. Accept regular expressions.");
        lblFilter.setAlignmentX(0.5f);
        panelFilter.add(lblFilter);
        Component horizontalStrut_1 = Box.createHorizontalStrut(5);
        panelFilter.add(horizontalStrut_1);
        this.textFieldFilter = new JTextField();
        panelFilter.add(this.textFieldFilter);
        this.textFieldFilter.setColumns(10);
        this.textFieldFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                VisualEditorPanel.this.filterRows();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                VisualEditorPanel.this.filterRows();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VisualEditorPanel.this.filterRows();
            }
        });
        this.panelEditor = new JPanel();
        this.add((Component)this.panelEditor, "South");
        this.panelEditor.setLayout(new BorderLayout(0, 0));
        JPanel panelCommandButtons = new JPanel();
        this.panelEditor.add((Component)panelCommandButtons, "North");
        panelCommandButtons.setLayout(new BoxLayout(panelCommandButtons, 0));
        JButton btnCopyCommand = new JButton("Copy");
        btnCopyCommand.setToolTipText("Duplicate command binding to a new, blank binding.");
        panelCommandButtons.add(btnCopyCommand);
        JButton btnUnbindAction = new JButton("Unbind");
        btnUnbindAction.setToolTipText("Remove current binding for selected command.");
        panelCommandButtons.add(btnUnbindAction);
        JButton btnDeleteAction = new JButton("Unbind all");
        btnDeleteAction.setToolTipText("Remove all bindings to selected command.");
        panelCommandButtons.add(btnDeleteAction);
        Component horizontalGlue = Box.createHorizontalGlue();
        panelCommandButtons.add(horizontalGlue);
        JButton btnExportCsv = new JButton("Export CSV");
        btnExportCsv.setToolTipText("Export all command bindings to a CSV file.");
        panelCommandButtons.add(btnExportCsv);
        JPanel panelCommandEditor = new JPanel();
        this.panelEditor.add((Component)panelCommandEditor, "Center");
        GridBagLayout gbl_panelCommandEditor = new GridBagLayout();
        gbl_panelCommandEditor.rowHeights = new int[]{0, 0, 0, 0, 60};
        gbl_panelCommandEditor.columnWidths = new int[]{30, 100};
        gbl_panelCommandEditor.columnWeights = new double[]{0.0, 1.0};
        gbl_panelCommandEditor.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        panelCommandEditor.setLayout(gbl_panelCommandEditor);
        JLabel lblName = new JLabel("Name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.insets = new Insets(5, 5, 5, 5);
        gbc_lblName.anchor = 17;
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 0;
        panelCommandEditor.add((Component)lblName, gbc_lblName);
        this.labelCommandName = new JLabel();
        GridBagConstraints gbc_labelActionName = new GridBagConstraints();
        gbc_labelActionName.anchor = 17;
        gbc_labelActionName.insets = new Insets(5, 5, 5, 0);
        gbc_labelActionName.gridx = 1;
        gbc_labelActionName.gridy = 0;
        panelCommandEditor.add((Component)this.labelCommandName, gbc_labelActionName);
        JLabel lblBinding = new JLabel("Binding:");
        GridBagConstraints gbc_lblBinding = new GridBagConstraints();
        gbc_lblBinding.anchor = 17;
        gbc_lblBinding.insets = new Insets(5, 5, 5, 5);
        gbc_lblBinding.gridx = 0;
        gbc_lblBinding.gridy = 1;
        panelCommandEditor.add((Component)lblBinding, gbc_lblBinding);
        this.keybindingEditor = new InputTriggerPanelEditor(true);
        GridBagConstraints gbc_textFieldBinding = new GridBagConstraints();
        gbc_textFieldBinding.insets = new Insets(5, 5, 5, 5);
        gbc_textFieldBinding.fill = 2;
        gbc_textFieldBinding.gridx = 1;
        gbc_textFieldBinding.gridy = 1;
        panelCommandEditor.add((Component)this.keybindingEditor, gbc_textFieldBinding);
        JLabel lblContext = new JLabel("Contexts:");
        GridBagConstraints gbc_lblContext = new GridBagConstraints();
        gbc_lblContext.anchor = 17;
        gbc_lblContext.insets = new Insets(5, 5, 5, 5);
        gbc_lblContext.gridx = 0;
        gbc_lblContext.gridy = 2;
        panelCommandEditor.add((Component)lblContext, gbc_lblContext);
        this.contextsEditor = new TagPanelEditor(Collections.emptyList());
        GridBagConstraints gbc_comboBoxContext = new GridBagConstraints();
        gbc_comboBoxContext.insets = new Insets(5, 5, 5, 5);
        gbc_comboBoxContext.fill = 1;
        gbc_comboBoxContext.gridx = 1;
        gbc_comboBoxContext.gridy = 2;
        panelCommandEditor.add((Component)this.contextsEditor, gbc_comboBoxContext);
        JLabel lblConflicts = new JLabel("Conflicts:");
        GridBagConstraints gbc_lblConflicts = new GridBagConstraints();
        gbc_lblConflicts.insets = new Insets(5, 5, 5, 5);
        gbc_lblConflicts.anchor = 17;
        gbc_lblConflicts.gridx = 0;
        gbc_lblConflicts.gridy = 3;
        panelCommandEditor.add((Component)lblConflicts, gbc_lblConflicts);
        this.lblConflict = new JLabel("");
        this.lblConflict.setToolTipText("Conflicts with other commands.");
        this.lblConflict.setForeground(Color.PINK.darker());
        this.lblConflict.setFont(this.getFont().deriveFont(1));
        GridBagConstraints gbc_lblConflict = new GridBagConstraints();
        gbc_lblConflict.insets = new Insets(5, 5, 5, 0);
        gbc_lblConflict.anchor = 17;
        gbc_lblConflict.gridx = 1;
        gbc_lblConflict.gridy = 3;
        panelCommandEditor.add((Component)this.lblConflict, gbc_lblConflict);
        JLabel lblDescription = new JLabel("Description:");
        GridBagConstraints gbc_lblDescription = new GridBagConstraints();
        gbc_lblDescription.insets = new Insets(5, 5, 5, 5);
        gbc_lblDescription.anchor = 18;
        gbc_lblDescription.gridx = 0;
        gbc_lblDescription.gridy = 4;
        panelCommandEditor.add((Component)lblDescription, gbc_lblDescription);
        JScrollPane scrollPaneDescription = new JScrollPane();
        scrollPaneDescription.setOpaque(false);
        scrollPaneDescription.setHorizontalScrollBarPolicy(31);
        GridBagConstraints gbc_scrollPaneDescription = new GridBagConstraints();
        gbc_scrollPaneDescription.insets = new Insets(5, 5, 5, 5);
        gbc_scrollPaneDescription.fill = 1;
        gbc_scrollPaneDescription.gridx = 1;
        gbc_scrollPaneDescription.gridy = 4;
        panelCommandEditor.add((Component)scrollPaneDescription, gbc_scrollPaneDescription);
        this.textAreaDescription = new JTextArea();
        this.textAreaDescription.setRows(3);
        this.textAreaDescription.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 1.0f));
        this.textAreaDescription.setOpaque(false);
        this.textAreaDescription.setWrapStyleWord(true);
        this.textAreaDescription.setEditable(false);
        this.textAreaDescription.setLineWrap(true);
        this.textAreaDescription.setFocusable(false);
        scrollPaneDescription.setViewportView(this.textAreaDescription);
        this.panelButtons = new JPanel();
        this.panelEditor.add((Component)this.panelButtons, "South");
        FlowLayout flowLayout = (FlowLayout)this.panelButtons.getLayout();
        flowLayout.setAlignment(4);
        this.btnRestore = new JButton("Restore");
        this.btnRestore.setToolTipText("Re-read the key bindings from the config.");
        this.panelButtons.add(this.btnRestore);
        this.btnApply = new JButton("Apply");
        this.btnApply.setToolTipText("Write these key bindings in the config.");
        this.panelButtons.add(this.btnApply);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollPane, "Center");
        this.tableBindings = new JTable(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setRowHeight((int)((double)this.getFontMetrics(this.getFont()).getHeight() * 1.5));
            }
        };
        this.tableBindings.setSelectionMode(0);
        this.tableBindings.setFillsViewportHeight(true);
        this.tableBindings.setAutoResizeMode(2);
        this.tableBindings.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                VisualEditorPanel.this.updateEditors();
            }
        });
        this.tableBindings.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (VisualEditorPanel.this.blockRemoveNotMapped) {
                    VisualEditorPanel.this.blockRemoveNotMapped = false;
                    return;
                }
                int selIndex = VisualEditorPanel.this.tableBindings.getSelectionModel().getMinSelectionIndex();
                if (selIndex < 0) {
                    return;
                }
                MyTableRow selectedRowToRestore = (MyTableRow)VisualEditorPanel.this.tableModel.rows.get(selIndex);
                if (!VisualEditorPanel.this.tableModel.removeSuperfluousNotMapped()) {
                    return;
                }
                int bs = Collections.binarySearch(VisualEditorPanel.this.tableModel.rows, selectedRowToRestore, MyTableRowComparator);
                if (bs < 0) {
                    return;
                }
                int vbs = VisualEditorPanel.this.tableBindings.convertRowIndexToView(bs);
                VisualEditorPanel.this.tableBindings.getSelectionModel().setSelectionInterval(vbs, vbs);
            }
        });
        this.tableBindings.setFocusTraversalKeys(0, null);
        this.tableBindings.setFocusTraversalKeys(1, null);
        this.keybindingEditor.addInputTriggerChangeListener(() -> this.keybindingsChanged(this.keybindingEditor.getInputTrigger() == null ? this.keybindingEditor.getLastValidInputTrigger() : this.keybindingEditor.getInputTrigger()));
        this.contextsEditor.addTagSelectionChangeListener(() -> this.contextsChanged(this.contextsEditor.getSelectedTags()));
        btnCopyCommand.addActionListener(e -> this.copyCommand());
        btnUnbindAction.addActionListener(e -> this.unbindCommand());
        btnDeleteAction.addActionListener(e -> this.unbindAllCommand());
        btnExportCsv.addActionListener(e -> this.exportToCsv());
        this.btnRestore.addActionListener(e -> this.configToModel());
        this.btnApply.addActionListener(e -> this.modelToConfig());
        this.modelChangedListeners.add(() -> {
            this.btnApply.setEnabled(true);
            this.btnRestore.setEnabled(true);
        });
        this.configToModel();
        this.tableBindings.getRowSorter().toggleSortOrder(0);
        if (this.tableBindings.getRowCount() > 0) {
            this.tableBindings.getSelectionModel().setSelectionInterval(0, 0);
        }
        scrollPane.setViewportView(this.tableBindings);
    }

    private void lookForConflicts() {
        this.lblConflict.setText("");
        int viewRow = this.tableBindings.getSelectedRow();
        if (viewRow < 0) {
            return;
        }
        int modelRow = this.tableBindings.convertRowIndexToModel(viewRow);
        this.lblConflict.setText("");
        InputTrigger inputTrigger = ((MyTableRow)this.tableModel.rows.get(modelRow)).getTrigger();
        if (inputTrigger == InputTrigger.NOT_MAPPED) {
            return;
        }
        List<String> contexts = ((MyTableRow)this.tableModel.rows.get(modelRow)).getContexts();
        ArrayList<String> conflicts = new ArrayList<String>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (i == modelRow || !((MyTableRow)this.tableModel.rows.get(i)).getTrigger().equals(inputTrigger)) continue;
            ArrayList<String> overlappingContexts = new ArrayList<String>(((MyTableRow)this.tableModel.rows.get(i)).getContexts());
            overlappingContexts.retainAll(contexts);
            if (overlappingContexts.isEmpty()) continue;
            StringBuilder str = new StringBuilder();
            str.append(((MyTableRow)this.tableModel.rows.get(i)).getName());
            str.append(" in ").append((String)overlappingContexts.get(0));
            for (int j = 1; j < overlappingContexts.size(); ++j) {
                str.append(", ").append((String)overlappingContexts.get(j));
            }
            conflicts.add(str.toString());
        }
        if (!conflicts.isEmpty()) {
            StringBuilder str = new StringBuilder((String)conflicts.get(0));
            for (int i = 1; i < conflicts.size(); ++i) {
                str.append("; ").append((String)conflicts.get(i));
            }
            this.lblConflict.setText(str.toString());
        }
    }

    public void setButtonPanelVisible(boolean visible) {
        this.panelEditor.remove(this.panelButtons);
        if (visible) {
            this.panelEditor.add((Component)this.panelButtons, "South");
        }
    }

    public void modelToConfig() {
        this.config.clear();
        for (MyTableRow row : this.tableModel.rows) {
            InputTrigger inputTrigger = row.getTrigger();
            if (inputTrigger == InputTrigger.NOT_MAPPED) continue;
            String action = row.getName();
            this.config.add(inputTrigger, action, row.getContexts());
        }
        for (Command command : this.commands) {
            String action = command.getName();
            if (!this.config.getInputs(action, command.getContext()).isEmpty()) continue;
            this.config.add(InputTrigger.NOT_MAPPED, action, command.getContext());
        }
        this.btnApply.setEnabled(false);
        this.btnRestore.setEnabled(false);
        this.configCommittedListeners.list.forEach(ConfigChangeListener::configChanged);
    }

    public void configToModel() {
        this.tableModel = new MyTableModel(this.commands, this.config);
        this.tableBindings.setModel(this.tableModel);
        this.tableRowSorter = new TableRowSorter<MyTableModel>(this.tableModel);
        this.tableRowSorter.setComparator(1, InputTriggerComparator);
        this.tableBindings.setRowSorter(this.tableRowSorter);
        this.filterRows();
        this.tableBindings.getColumnModel().getColumn(1).setCellRenderer(new MyBindingsRenderer());
        this.tableBindings.getColumnModel().getColumn(2).setCellRenderer(new MyContextsRenderer(Collections.emptyList()));
        this.notifyListeners();
        this.btnApply.setEnabled(false);
        this.btnRestore.setEnabled(false);
    }

    private void filterRows() {
        String regex = this.textFieldFilter.getText();
        Pattern pattern = Pattern.compile(regex, 2);
        final Matcher matcher = pattern.matcher("");
        RowFilter<MyTableModel, Integer> rf = new RowFilter<MyTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends MyTableModel, ? extends Integer> entry) {
                int count = entry.getValueCount();
                while (--count >= 0) {
                    matcher.reset(entry.getStringValue(count));
                    if (!matcher.find()) continue;
                    return true;
                }
                return false;
            }
        };
        this.tableRowSorter.setRowFilter(rf);
    }

    private void exportToCsv() {
        int userSignal = fileChooser.showSaveDialog(this);
        if (userSignal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(fileChooser, "Cannot write on existing file " + file.getAbsolutePath(), "File error", 0);
                return;
            }
            int doOverwrite = JOptionPane.showConfirmDialog(fileChooser, "The file already exists. Do you want to overwrite it?", "Overwrite?", 0);
            if (doOverwrite != 0) {
                return;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MyTableModel.TABLE_HEADERS[0]);
        sb.append(",\t");
        sb.append(MyTableModel.TABLE_HEADERS[1]);
        sb.append(",\t");
        sb.append(MyTableModel.TABLE_HEADERS[2]);
        sb.append('\n');
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            sb.append(((MyTableRow)this.tableModel.rows.get(i)).getName());
            sb.append(",\t");
            sb.append(((MyTableRow)this.tableModel.rows.get(i)).getTrigger().toString());
            sb.append(",\t");
            List<String> contexts = ((MyTableRow)this.tableModel.rows.get(i)).getContexts();
            if (!contexts.isEmpty()) {
                sb.append(contexts.get(0));
                for (int j = 1; j < contexts.size(); ++j) {
                    sb.append(" - ").append(contexts.get(j));
                }
            }
            sb.append('\n');
        }
        try (PrintWriter pw = new PrintWriter(file);){
            pw.write(sb.toString());
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(fileChooser, "Error writing file:\n" + e.getMessage(), "Error writing file.", 0);
            e.printStackTrace();
        }
    }

    private void updateEditors() {
        String description;
        int viewRow = this.tableBindings.getSelectedRow();
        if (viewRow < 0) {
            this.labelCommandName.setText("");
            this.keybindingEditor.setInputTrigger(InputTrigger.NOT_MAPPED);
            this.contextsEditor.setTags(Collections.emptyList());
            this.textAreaDescription.setText("");
            return;
        }
        int modelRow = this.tableBindings.convertRowIndexToModel(viewRow);
        MyTableRow row = (MyTableRow)this.tableModel.rows.get(modelRow);
        String action = row.getName();
        InputTrigger trigger = row.getTrigger();
        List<String> contexts = row.getContexts();
        Set<String> acceptableContexts = this.commandNameToAcceptableContexts.get(action);
        if (acceptableContexts.isEmpty()) {
            description = "";
        } else {
            StringBuilder str = new StringBuilder();
            for (String context : acceptableContexts) {
                String d = this.actionDescriptions.get(new Command(action, context));
                if (d != null) {
                    str.append("\n\nIn ").append(context).append(":\n").append(d);
                    continue;
                }
                str.append("\n\nIn ").append(context).append(" - no description.");
            }
            str.delete(0, 2);
            description = str.toString();
        }
        this.labelCommandName.setText(action);
        this.keybindingEditor.setInputTrigger(trigger);
        this.contextsEditor.setAcceptableTags(acceptableContexts);
        this.contextsEditor.setTags(contexts);
        this.textAreaDescription.setText(description);
        this.textAreaDescription.setCaretPosition(0);
        this.lookForConflicts();
    }

    private void unbindCommand() {
        int viewRow = this.tableBindings.getSelectedRow();
        if (viewRow < 0) {
            return;
        }
        int modelRow = this.tableBindings.convertRowIndexToModel(viewRow);
        this.tableModel.rows.remove(modelRow);
        if (!this.tableModel.addMissingRows()) {
            this.tableModel.fireTableRowsDeleted(modelRow, modelRow);
        }
        this.notifyListeners();
    }

    private void unbindAllCommand() {
        int viewRow = this.tableBindings.getSelectedRow();
        if (viewRow < 0) {
            return;
        }
        int modelRow = this.tableBindings.convertRowIndexToModel(viewRow);
        String removeName = ((MyTableRow)this.tableModel.rows.get(modelRow)).getName();
        this.tableModel.rows.removeIf(row -> row.getName().equals(removeName));
        if (!this.tableModel.addMissingRows()) {
            this.tableModel.fireTableDataChanged();
        }
        this.notifyListeners();
    }

    private void copyCommand() {
        int viewRow = this.tableBindings.getSelectedRow();
        if (viewRow < 0) {
            return;
        }
        int modelRow = this.tableBindings.convertRowIndexToModel(viewRow);
        MyTableRow row = (MyTableRow)this.tableModel.rows.get(modelRow);
        MyTableRow copiedRow = new MyTableRow(row.getName(), InputTrigger.NOT_MAPPED, row.getContexts());
        this.tableModel.rows.add(modelRow + 1, copiedRow);
        this.blockRemoveNotMapped = true;
        if (!this.tableModel.mergeRows()) {
            this.tableModel.fireTableRowsInserted(modelRow + 1, modelRow + 1);
        }
        this.blockRemoveNotMapped = true;
        int modelRowToSelect = Collections.binarySearch(this.tableModel.rows, copiedRow, MyTableRowComparator);
        int rowToSelect = modelRowToSelect < 0 ? this.tableBindings.convertRowIndexToView(modelRow) : this.tableBindings.convertRowIndexToView(modelRowToSelect);
        this.tableBindings.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
        this.keybindingEditor.requestFocusInWindow();
    }

    private void keybindingsChanged(InputTrigger inputTrigger) {
        int viewRow = this.tableBindings.getSelectedRow();
        if (viewRow < 0) {
            return;
        }
        int modelRow = this.tableBindings.convertRowIndexToModel(viewRow);
        MyTableRow row = (MyTableRow)this.tableModel.rows.get(modelRow);
        MyTableRow updatedRow = new MyTableRow(row.getName(), inputTrigger, row.getContexts());
        this.tableModel.rows.set(modelRow, updatedRow);
        if (!this.tableModel.mergeRows()) {
            this.tableModel.fireTableRowsUpdated(modelRow, modelRow);
        }
        this.lookForConflicts();
        int modelRowToSelect = Collections.binarySearch(this.tableModel.rows, updatedRow, MyTableRowComparator);
        int rowToSelect = modelRowToSelect < 0 ? this.tableBindings.convertRowIndexToView(modelRow) : this.tableBindings.convertRowIndexToView(modelRowToSelect);
        this.blockRemoveNotMapped = true;
        this.tableBindings.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
        this.notifyListeners();
    }

    private void contextsChanged(List<String> selectedContexts) {
        int viewRow = this.tableBindings.getSelectedRow();
        if (viewRow < 0) {
            return;
        }
        int modelRow = this.tableBindings.convertRowIndexToModel(viewRow);
        MyTableRow row = (MyTableRow)this.tableModel.rows.get(modelRow);
        ArrayList<String> newContexts = new ArrayList<String>(selectedContexts);
        newContexts.sort(null);
        this.tableModel.rows.set(modelRow, new MyTableRow(row.getName(), row.getTrigger(), newContexts));
        if (!this.tableModel.addMissingRows()) {
            this.tableModel.fireTableRowsUpdated(modelRow, modelRow);
        }
        this.notifyListeners();
        int viewRowToSelect = this.tableBindings.convertRowIndexToView(modelRow);
        if (viewRowToSelect < 0) {
            return;
        }
        this.tableBindings.getSelectionModel().setSelectionInterval(viewRowToSelect, viewRowToSelect);
    }

    private void notifyListeners() {
        this.modelChangedListeners.list.forEach(ConfigChangeListener::configChanged);
    }

    private static Map<Command, String> extractEmptyCommandDescriptions(InputTriggerConfig keyconf) {
        List<InputTriggerDescription> descriptions = new InputTriggerDescriptionsBuilder(keyconf).getDescriptions();
        LinkedHashSet<Command> commands = new LinkedHashSet<Command>();
        for (InputTriggerDescription desc : descriptions) {
            for (String context : desc.getContexts()) {
                commands.add(new Command(desc.getAction(), context));
            }
        }
        HashMap<Command, String> commandDescriptions = new HashMap<Command, String>();
        commands.forEach(command -> {
            String cfr_ignored_0 = commandDescriptions.put((Command)command, (String)null);
        });
        return commandDescriptions;
    }

    @Deprecated
    public Listeners<ConfigChangeListener> configChangeListeners() {
        return this.modelChangedListeners();
    }

    @Deprecated
    public void addConfigChangeListener(ConfigChangeListener listener) {
        this.modelChangedListeners().add(listener);
    }

    @Deprecated
    public void removeConfigChangeListener(ConfigChangeListener listener) {
        this.modelChangedListeners().remove(listener);
    }

    public Listeners<ConfigChangeListener> modelChangedListeners() {
        return this.modelChangedListeners;
    }

    public Listeners<ConfigChangeListener> configCommittedListeners() {
        return this.configCommittedListeners;
    }

    static {
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "CSV files";
            }

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().toLowerCase().endsWith(".csv");
            }
        });
        MyTableRowComparator = new Comparator<MyTableRow>(){

            @Override
            public int compare(MyTableRow o1, MyTableRow o2) {
                int cn = o1.name.compareTo(o2.name);
                if (cn != 0) {
                    return cn;
                }
                return this.compare(o1.trigger, o2.trigger);
            }

            @Override
            private int compare(InputTrigger o1, InputTrigger o2) {
                if (o1 == InputTrigger.NOT_MAPPED) {
                    return o2 == InputTrigger.NOT_MAPPED ? 0 : 1;
                }
                if (o2 == InputTrigger.NOT_MAPPED) {
                    return -1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
        InputTriggerComparator = new Comparator<InputTrigger>(){

            @Override
            public int compare(InputTrigger o1, InputTrigger o2) {
                if (o1 == InputTrigger.NOT_MAPPED) {
                    return 1;
                }
                if (o2 == InputTrigger.NOT_MAPPED) {
                    return -1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final String[] TABLE_HEADERS = new String[]{"Command", "Binding", "Contexts"};
        private final List<MyTableRow> rows = new ArrayList<MyTableRow>();
        private final Set<Command> allCommands;

        public MyTableModel(Set<Command> commands, InputTriggerConfig config) {
            this.allCommands = commands;
            for (Command command : commands) {
                Set<InputTrigger> inputs = config.getInputs(command.getName(), command.getContext());
                for (InputTrigger input : inputs) {
                    this.rows.add(new MyTableRow(command.getName(), input, command.getContext()));
                }
            }
            this.addMissingRows();
        }

        public void removeAllNotMapped(List<MyTableRow> rows) {
            rows.removeIf(row -> row.getTrigger().equals(InputTrigger.NOT_MAPPED));
        }

        public boolean removeSuperfluousNotMapped() {
            ArrayList<MyTableRow> copy = new ArrayList<MyTableRow>(this.rows);
            this.removeAllNotMapped(this.rows);
            this.addMissingRows(this.rows);
            if (!copy.equals(this.rows)) {
                this.fireTableDataChanged();
                return true;
            }
            return false;
        }

        private boolean mergeRows() {
            ArrayList<MyTableRow> copy = new ArrayList<MyTableRow>(this.rows);
            this.mergeRows(this.rows);
            if (!copy.equals(this.rows)) {
                this.fireTableDataChanged();
                return true;
            }
            return false;
        }

        private void mergeRows(List<MyTableRow> rows) {
            ArrayList<MyTableRow> rowsUnmerged = new ArrayList<MyTableRow>(rows);
            rows.clear();
            rowsUnmerged.sort(MyTableRowComparator);
            int i = 0;
            while (i < rowsUnmerged.size()) {
                int j;
                MyTableRow rowA = (MyTableRow)rowsUnmerged.get(i);
                for (j = i + 1; j < rowsUnmerged.size() && MyTableRowComparator.compare(rowsUnmerged.get(j), rowA) == 0; ++j) {
                }
                HashSet<String> contexts = new HashSet<String>();
                for (int k = i; k < j; ++k) {
                    contexts.addAll(((MyTableRow)rowsUnmerged.get(k)).getContexts());
                }
                rows.add(new MyTableRow(rowA.getName(), rowA.getTrigger(), contexts));
                i = j;
            }
        }

        private boolean addMissingRows() {
            ArrayList<MyTableRow> copy = new ArrayList<MyTableRow>(this.rows);
            this.addMissingRows(this.rows);
            if (!copy.equals(this.rows)) {
                this.fireTableDataChanged();
                return true;
            }
            return false;
        }

        private void addMissingRows(List<MyTableRow> rows) {
            ArrayList<Command> missingCommands = new ArrayList<Command>();
            for (Command command : this.allCommands) {
                boolean found = false;
                for (MyTableRow row : rows) {
                    if (!row.getName().equals(command.getName()) || !row.getContexts().contains(command.getContext())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missingCommands.add(command);
            }
            for (Command command : missingCommands) {
                rows.add(new MyTableRow(command.getName(), InputTrigger.NOT_MAPPED, command.getContext()));
            }
            this.mergeRows(rows);
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.rows.get(rowIndex).getName();
                }
                case 1: {
                    return this.rows.get(rowIndex).getTrigger();
                }
                case 2: {
                    return this.rows.get(rowIndex).getContexts();
                }
            }
            throw new NoSuchElementException("Cannot access column " + columnIndex + " in this model.");
        }

        @Override
        public String getColumnName(int column) {
            return TABLE_HEADERS[column];
        }
    }

    private static class MyTableRow {
        private final String name;
        private final InputTrigger trigger;
        private final List<String> contexts;

        public MyTableRow(String name, InputTrigger trigger, String context) {
            this(name, trigger, Collections.singletonList(context));
        }

        public MyTableRow(String name, InputTrigger trigger, Collection<String> contexts) {
            this.name = name;
            this.trigger = trigger;
            this.contexts = new ArrayList<String>(contexts);
        }

        public String getName() {
            return this.name;
        }

        public InputTrigger getTrigger() {
            return this.trigger;
        }

        public List<String> getContexts() {
            return this.contexts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyTableRow that = (MyTableRow)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (!this.trigger.equals(that.trigger)) {
                return false;
            }
            return this.contexts.equals(that.contexts);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.trigger.hashCode();
            result = 31 * result + this.contexts.hashCode();
            return result;
        }

        public String toString() {
            return "MyTableRow{name='" + this.name + '\'' + ", trigger=" + this.trigger + ", contexts=" + this.contexts + '}';
        }
    }

    private static final class MyBindingsRenderer
    extends InputTriggerPanelEditor
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyBindingsRenderer() {
            super(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            InputTrigger input = (InputTrigger)value;
            if (null != input) {
                this.setInputTrigger(input);
                String val = input.toString();
                this.setToolTipText(val);
            } else {
                this.setInputTrigger(InputTrigger.NOT_MAPPED);
                this.setToolTipText("No binding");
            }
            return this;
        }
    }

    private final class MyContextsRenderer
    extends TagPanelEditor
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyContextsRenderer(Collection<String> tags) {
            super(tags, false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            List contexts;
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            int modelRow = VisualEditorPanel.this.tableBindings.convertRowIndexToModel(row);
            String name = ((MyTableRow)VisualEditorPanel.this.tableModel.rows.get(modelRow)).getName();
            this.setAcceptableTags((Collection)VisualEditorPanel.this.commandNameToAcceptableContexts.get(name));
            List list = contexts = value != null ? (List)value : Collections.emptyList();
            if (contexts.isEmpty()) {
                this.setBackground(Color.PINK);
            }
            this.setTags(contexts);
            this.setToolTipText(contexts.toString());
            return this;
        }
    }

    @FunctionalInterface
    public static interface ConfigChangeListener {
        public void configChanged();
    }
}

