/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.event.DatasetRestructuredEvent;
import net.imagej.overlay.AbstractOverlay;
import net.imagej.overlay.Overlay;
import net.imglib2.RealInterval;
import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.condition.FunctionGreaterCondition;
import net.imglib2.ops.condition.FunctionLessCondition;
import net.imglib2.ops.condition.OrCondition;
import net.imglib2.ops.condition.WithinRangeCondition;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.RealImageFunction;
import net.imglib2.ops.pointset.ConditionalPointSet;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetRegionOfInterest;
import net.imglib2.roi.RegionOfInterest;
import net.imglib2.type.numeric.RealType;
import org.scijava.Context;
import org.scijava.display.Displayable;
import org.scijava.event.EventHandler;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;

@Deprecated
public class ThresholdOverlay
extends AbstractOverlay {
    private final Dataset dataset;
    private Function<long[], RealType<?>> function;
    private RealType<?> variable;
    private Displayable figure;
    private ConditionalPointSet pointsLess;
    private ConditionalPointSet pointsGreater;
    private ConditionalPointSet pointsWithin;
    private ConditionalPointSet pointsOutside;
    private FunctionLessCondition<? extends RealType<?>> conditionLess;
    private FunctionGreaterCondition<? extends RealType<?>> conditionGreater;
    private WithinRangeCondition<? extends RealType<?>> conditionWithin;
    private OrCondition<long[]> conditionOutside;
    private RegionOfInterest regionAdapter;
    private ColorRGB colorLess;
    private ColorRGB colorWithin;
    private ColorRGB colorGreater;
    private String defaultName;

    public ThresholdOverlay(Context context, Dataset dataset) {
        super((RealInterval)dataset);
        this.setContext(context);
        this.dataset = dataset;
        this.figure = null;
        this.init(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.initAttributes();
        this.resetThreshold();
        this.setDefaultName(false);
    }

    public ThresholdOverlay(Context context, Dataset ds, double min, double max) {
        this(context, ds);
        this.setRange(min, max);
    }

    public void setFigure(Displayable figure) {
        this.figure = figure;
    }

    public Displayable getFigure() {
        return this.figure;
    }

    public void setRange(double min, double max) {
        boolean changed = min != this.conditionWithin.getMin() || max != this.conditionWithin.getMax();
        this.conditionWithin.setMin(min);
        this.conditionWithin.setMax(max);
        this.conditionLess.setValue(min);
        this.conditionGreater.setValue(max);
        this.pointsGreater.setCondition(this.conditionGreater);
        this.pointsLess.setCondition(this.conditionLess);
        this.pointsWithin.setCondition(this.conditionWithin);
        this.pointsOutside.setCondition(this.conditionOutside);
        this.setDefaultName(changed);
    }

    public double getRangeMin() {
        return this.conditionWithin.getMin();
    }

    public double getRangeMax() {
        return this.conditionWithin.getMax();
    }

    public void resetThreshold() {
        RealType type = this.dataset.getType();
        double min = type.getMinValue();
        double max = type.getMaxValue();
        if (min < -20000.0) {
            min = -20000.0;
        }
        if (max > 20000.0) {
            max = 20000.0;
        }
        this.setRange(min, max / 2.0);
    }

    public PointSet getPointsWithin() {
        return this.pointsWithin;
    }

    public PointSet getPointsLess() {
        return this.pointsLess;
    }

    public PointSet getPointsGreater() {
        return this.pointsGreater;
    }

    public PointSet getPointsOutside() {
        return this.pointsOutside;
    }

    public Condition<long[]> getConditionWithin() {
        return this.conditionWithin;
    }

    public Condition<long[]> getConditionLess() {
        return this.conditionLess;
    }

    public Condition<long[]> getConditionGreater() {
        return this.conditionGreater;
    }

    public Condition<long[]> getConditionOutside() {
        return this.conditionOutside;
    }

    public ColorRGB getColorLess() {
        return this.colorLess;
    }

    public ColorRGB getColorGreater() {
        return this.colorGreater;
    }

    public ColorRGB getColorWithin() {
        return this.colorWithin;
    }

    public void setColorLess(ColorRGB c) {
        this.colorLess = c;
    }

    public void setColorGreater(ColorRGB c) {
        this.colorGreater = c;
    }

    public void setColorWithin(ColorRGB c) {
        this.colorWithin = c;
    }

    public int classify(long[] point) {
        this.function.compute(point, this.variable);
        double val = this.variable.getRealDouble();
        if (Double.isNaN(val)) {
            return Integer.MAX_VALUE;
        }
        if (val < this.conditionWithin.getMin()) {
            return -1;
        }
        if (val > this.conditionWithin.getMax()) {
            return 1;
        }
        return 0;
    }

    public void update() {
        if (this.figure != null) {
            this.figure.draw();
        }
    }

    public void rebuild() {
        this.update();
    }

    public int dimensionIndex(AxisType axis) {
        return this.dataset.dimensionIndex(axis);
    }

    public CalibratedAxis axis(int d) {
        return (CalibratedAxis)this.dataset.axis(d);
    }

    public void axes(CalibratedAxis[] axes) {
        this.dataset.axes((Axis[])axes);
    }

    public void setAxis(CalibratedAxis axis, int d) {
        this.dataset.setAxis((Axis)axis, d);
    }

    public int numDimensions() {
        return this.pointsWithin.numDimensions();
    }

    public double realMin(int d) {
        return this.pointsWithin.min(d);
    }

    public double realMax(int d) {
        return this.pointsWithin.max(d);
    }

    public RegionOfInterest getRegionOfInterest() {
        return this.regionAdapter;
    }

    public ThresholdOverlay duplicate() {
        double min = this.getRangeMin();
        double max = this.getRangeMax();
        ThresholdOverlay overlay = new ThresholdOverlay(this.getContext(), this.dataset, min, max);
        overlay.setColorWithin(this.getColorWithin());
        overlay.setColorLess(this.getColorLess());
        overlay.setColorGreater(this.getColorGreater());
        return overlay;
    }

    public void move(double[] deltas) {
    }

    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        return this.defaultName;
    }

    @EventHandler
    protected void onEvent(DatasetRestructuredEvent evt) {
        if (evt.getObject() == this.dataset) {
            this.reinit();
            this.rebuild();
        }
    }

    private void init(double min, double max) {
        ImgPlus imgPlus = this.dataset.getImgPlus();
        this.function = new RealImageFunction(imgPlus, (RealType)imgPlus.firstElement());
        this.variable = this.function.createOutput();
        this.conditionWithin = new WithinRangeCondition(this.function, min, max);
        this.conditionLess = new FunctionLessCondition(this.function, min);
        this.conditionGreater = new FunctionGreaterCondition(this.function, max);
        this.conditionOutside = new OrCondition<long[]>(this.conditionLess, this.conditionGreater);
        long[] dims = new long[imgPlus.numDimensions()];
        imgPlus.dimensions(dims);
        HyperVolumePointSet volume = new HyperVolumePointSet(dims);
        this.pointsLess = new ConditionalPointSet(volume, this.conditionLess);
        this.pointsGreater = new ConditionalPointSet(volume, this.conditionGreater);
        this.pointsWithin = new ConditionalPointSet(volume, this.conditionWithin);
        this.pointsOutside = new ConditionalPointSet(volume, this.conditionOutside);
        this.regionAdapter = new PointSetRegionOfInterest(this.pointsWithin);
        this.setDefaultName(false);
    }

    private void reinit() {
        ImgPlus imgPlus = this.dataset.getImgPlus();
        Function<long[], RealType<?>> f = this.function = new RealImageFunction(imgPlus, (RealType)imgPlus.firstElement());
        this.conditionWithin.setFunction(f);
        this.conditionLess.setFunction(f);
        this.conditionGreater.setFunction(f);
        long[] dims = new long[imgPlus.numDimensions()];
        imgPlus.dimensions(dims);
        HyperVolumePointSet volume = new HyperVolumePointSet(dims);
        this.pointsWithin.setPointSet(volume);
        this.pointsLess.setPointSet(volume);
        this.pointsGreater.setPointSet(volume);
        this.pointsWithin.setCondition(this.conditionWithin);
        this.pointsLess.setCondition(this.conditionLess);
        this.pointsGreater.setCondition(this.conditionGreater);
        this.pointsOutside.setCondition(this.conditionOutside);
        this.setDefaultName(false);
    }

    private void initAttributes() {
        this.setAlpha(255);
        this.setFillColor(Colors.RED);
        this.setLineColor(Colors.RED);
        this.setLineEndArrowStyle(Overlay.ArrowStyle.NONE);
        this.setLineStartArrowStyle(Overlay.ArrowStyle.NONE);
        this.setLineStyle(Overlay.LineStyle.NONE);
        this.setLineWidth(1.0);
        this.setColorWithin(Colors.RED);
        this.setColorLess(null);
        this.setColorGreater(null);
    }

    private void setDefaultName(boolean emitEvent) {
        this.defaultName = "Threshold: " + this.conditionWithin.getMin() + " to " + this.conditionWithin.getMax();
        if (emitEvent) {
            this.update();
        }
    }
}

