/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.convolve;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.AbstractBlockProcessor;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.blocks.TempArray;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

class ConvolveProcessors {
    ConvolveProcessors() {
    }

    private static float[] extractKernelFloat(Kernel1D k) {
        double[] doubles = k.fullKernel();
        int length = doubles.length;
        float[] result = new float[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (float)doubles[length - 1 - i];
        }
        return result;
    }

    private static double[] extractKernelDouble(Kernel1D k) {
        double[] doubles = k.fullKernel();
        int length = doubles.length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = doubles[length - 1 - i];
        }
        return result;
    }

    static class ConvolveFloat
    extends AbstractConvolve<ConvolveFloat, float[]> {
        ConvolveFloat(Kernel1D[] kernel1Ds) {
            super(kernel1Ds, x$0 -> ConvolveProcessors.extractKernelFloat(x$0), PrimitiveType.FLOAT);
        }

        ConvolveFloat(ConvolveFloat convolve) {
            super(convolve);
        }

        @Override
        public BlockProcessor<float[], float[]> independentCopy() {
            return new ConvolveFloat(this);
        }

        @Override
        void convolve(float[] source, float[] target, float[] kernel, int ol, int til, int kstep, int bw) {
            int kl = kernel.length;
            int sil = til + (kl - 1) * kstep;
            float[] sourceCopy = new float[bw];
            float[] targetCopy = new float[bw];
            int nBlocks = (til - 1) / bw + 1;
            int trailing = til - (nBlocks - 1) * bw;
            for (int o = 0; o < ol; ++o) {
                int to = o * til;
                int so = o * sil;
                for (int b = 0; b < nBlocks; ++b) {
                    int tob = to + b * bw;
                    int sob = so + b * bw;
                    int bwb = b == nBlocks - 1 ? trailing : bw;
                    Arrays.fill(targetCopy, 0.0f);
                    for (int k = 0; k < kl; ++k) {
                        System.arraycopy(source, sob + k * kstep, sourceCopy, 0, bwb);
                        ConvolveFloat.line(sourceCopy, targetCopy, bwb, kernel[k]);
                    }
                    System.arraycopy(targetCopy, 0, target, tob, bwb);
                }
            }
        }

        private static void line(float[] source, float[] target, int txl, float v) {
            for (int x = 0; x < txl; ++x) {
                int n = x;
                target[n] = target[n] + v * source[x];
            }
        }
    }

    static class ConvolveDouble
    extends AbstractConvolve<ConvolveDouble, double[]> {
        ConvolveDouble(Kernel1D[] kernel1Ds) {
            super(kernel1Ds, x$0 -> ConvolveProcessors.extractKernelDouble(x$0), PrimitiveType.DOUBLE);
        }

        ConvolveDouble(ConvolveDouble convolve) {
            super(convolve);
        }

        @Override
        public BlockProcessor<double[], double[]> independentCopy() {
            return new ConvolveDouble(this);
        }

        @Override
        void convolve(double[] source, double[] target, double[] kernel, int ol, int til, int kstep, int bw) {
            int kl = kernel.length;
            int sil = til + (kl - 1) * kstep;
            double[] sourceCopy = new double[bw];
            double[] targetCopy = new double[bw];
            int nBlocks = (til - 1) / bw + 1;
            int trailing = til - (nBlocks - 1) * bw;
            for (int o = 0; o < ol; ++o) {
                int to = o * til;
                int so = o * sil;
                for (int b = 0; b < nBlocks; ++b) {
                    int tob = to + b * bw;
                    int sob = so + b * bw;
                    int bwb = b == nBlocks - 1 ? trailing : bw;
                    Arrays.fill(targetCopy, 0.0);
                    for (int k = 0; k < kl; ++k) {
                        System.arraycopy(source, sob + k * kstep, sourceCopy, 0, bwb);
                        ConvolveDouble.line(sourceCopy, targetCopy, bwb, kernel[k]);
                    }
                    System.arraycopy(targetCopy, 0, target, tob, bwb);
                }
            }
        }

        private static void line(double[] source, double[] target, int txl, double v) {
            for (int x = 0; x < txl; ++x) {
                int n = x;
                target[n] = target[n] + v * source[x];
            }
        }
    }

    static abstract class AbstractConvolve<T extends AbstractConvolve<T, P>, P>
    extends AbstractBlockProcessor<P, P> {
        final P[] kernels;
        final int[] kernelOffsets;
        final int[] kernelSizes;
        final int n;
        final int[] destSize;
        private static final int BUF_AUX0 = 0;
        private static final int BUF_AUX1 = 1;
        private static final int BUF_SRC = 2;
        private static final int BUF_DEST = 3;
        final int[] fromBuf;
        final int[] toBuf;
        final TempArray<P> tempArrayAux0;
        final TempArray<P> tempArrayAux1;
        private final int[] ols;
        private final int[] ils;
        private final int[] ksteps;
        private int aux0Length;
        private int aux1Length;
        private final int bw = 2048;

        AbstractConvolve(Kernel1D[] kernel1Ds, Function<Kernel1D, P> extractKernel, PrimitiveType primitiveType) {
            super(primitiveType, kernel1Ds.length);
            this.n = kernel1Ds.length;
            this.kernels = (Object[])Cast.unchecked(new Object[this.n]);
            this.kernelOffsets = new int[this.n];
            this.kernelSizes = new int[this.n];
            for (int d = 0; d < this.n; ++d) {
                Kernel1D kernel1D = kernel1Ds[d];
                if (kernel1D == null) continue;
                this.kernels[d] = extractKernel.apply(kernel1D);
                this.kernelOffsets[d] = Util.safeInt(kernel1D.min());
                this.kernelSizes[d] = Util.safeInt(kernel1D.size());
            }
            this.destSize = new int[this.n];
            this.fromBuf = new int[this.n];
            this.toBuf = new int[this.n];
            int numPasses = (int)Arrays.stream(this.kernels).filter(Objects::nonNull).count();
            if (numPasses == 0) {
                throw new IllegalArgumentException();
            }
            int pass = 0;
            for (int d = 0; d < this.n; ++d) {
                if (this.kernels[d] == null) continue;
                this.fromBuf[d] = pass == 0 ? 2 : (pass + 1) % 2;
                this.toBuf[d] = pass == numPasses - 1 ? 3 : pass % 2;
                ++pass;
            }
            this.tempArrayAux0 = TempArray.forPrimitiveType(primitiveType);
            this.tempArrayAux1 = TempArray.forPrimitiveType(primitiveType);
            this.ols = new int[this.n];
            this.ils = new int[this.n];
            this.ksteps = new int[this.n];
        }

        AbstractConvolve(T convolve) {
            super(convolve);
            this.n = ((AbstractConvolve)convolve).n;
            this.kernels = ((AbstractConvolve)convolve).kernels;
            this.kernelOffsets = ((AbstractConvolve)convolve).kernelOffsets;
            this.kernelSizes = ((AbstractConvolve)convolve).kernelSizes;
            this.destSize = new int[this.n];
            this.fromBuf = ((AbstractConvolve)convolve).fromBuf;
            this.toBuf = ((AbstractConvolve)convolve).toBuf;
            this.tempArrayAux0 = ((AbstractConvolve)convolve).tempArrayAux0.newInstance();
            this.tempArrayAux1 = ((AbstractConvolve)convolve).tempArrayAux1.newInstance();
            this.ols = new int[this.n];
            this.ils = new int[this.n];
            this.ksteps = new int[this.n];
        }

        @Override
        public void setTargetInterval(Interval interval) {
            assert (interval.numDimensions() == this.n);
            Arrays.setAll(this.destSize, d -> (int)interval.dimension(d));
            Arrays.setAll(this.sourcePos, d -> interval.min(d) + (long)this.kernelOffsets[d]);
            this.aux0Length = 0;
            this.aux1Length = 0;
            System.arraycopy(this.destSize, 0, this.sourceSize, 0, this.n);
            for (int d2 = this.n - 1; d2 >= 0; --d2) {
                int dd;
                if (this.kernels[d2] == null) continue;
                this.ils[d2] = 1;
                for (dd = 0; dd < d2 + 1; ++dd) {
                    int n = d2;
                    this.ils[n] = this.ils[n] * this.sourceSize[dd];
                }
                this.ols[d2] = 1;
                for (dd = d2 + 1; dd < this.n; ++dd) {
                    int n = d2;
                    this.ols[n] = this.ols[n] * this.sourceSize[dd];
                }
                this.ksteps[d2] = 1;
                for (dd = 0; dd < d2; ++dd) {
                    int n = d2;
                    this.ksteps[n] = this.ksteps[n] * this.sourceSize[dd];
                }
                if (this.toBuf[d2] == 0) {
                    this.aux0Length = Math.max(this.aux0Length, Util.safeInt(Intervals.numElements(this.sourceSize)));
                } else if (this.toBuf[d2] == 1) {
                    this.aux1Length = Math.max(this.aux1Length, Util.safeInt(Intervals.numElements(this.sourceSize)));
                }
                int n = d2;
                this.sourceSize[n] = this.sourceSize[n] + (this.kernelSizes[d2] - 1);
            }
        }

        @Override
        public void compute(P src, P dest) {
            P aux0 = this.tempArrayAux0.get(this.aux0Length);
            P aux1 = this.tempArrayAux1.get(this.aux1Length);
            for (int d = 0; d < this.n; ++d) {
                if (this.kernels[d] == null) continue;
                P source = this.selectBuf(this.fromBuf[d], src, dest, aux0, aux1);
                P target = this.selectBuf(this.toBuf[d], src, dest, aux0, aux1);
                this.convolve(source, target, this.kernels[d], this.ols[d], this.ils[d], this.ksteps[d], 2048);
            }
        }

        private P selectBuf(int bufId, P src, P dest, P aux0, P aux1) {
            switch (bufId) {
                case 0: {
                    return aux0;
                }
                case 1: {
                    return aux1;
                }
                case 2: {
                    return src;
                }
            }
            return dest;
        }

        abstract void convolve(P var1, P var2, P var3, int var4, int var5, int var6, int var7);
    }
}

