/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.fast_gauss;

public class FastGaussCalculator {
    private double[] y_n = new double[4];
    private double[] y_n_minus_1 = new double[4];
    private double[] y_n_minus_2 = new double[4];
    private final double[] nk_2;
    private final double[] dk_1;
    private final int M;

    public FastGaussCalculator(Parameters fc) {
        this.nk_2 = fc.nk_2;
        this.dk_1 = fc.dk_1;
        this.M = fc.M;
    }

    public void initialize(double boundaryValue) {
        for (int i = 0; i < this.M; ++i) {
            this.y_n[i] = this.y_n_minus_1[i] = boundaryValue * 2.0 * this.nk_2[i] / (this.dk_1[i] + 2.0);
        }
    }

    public void update(double tmp) {
        double[] t = this.y_n_minus_2;
        this.y_n_minus_2 = this.y_n_minus_1;
        this.y_n_minus_1 = this.y_n;
        this.y_n = t;
        this.y_n[0] = this.nk_2[0] * tmp - this.dk_1[0] * this.y_n_minus_1[0] - this.y_n_minus_2[0];
        this.y_n[1] = this.nk_2[1] * tmp - this.dk_1[1] * this.y_n_minus_1[1] - this.y_n_minus_2[1];
        this.y_n[2] = this.nk_2[2] * tmp - this.dk_1[2] * this.y_n_minus_1[2] - this.y_n_minus_2[2];
        this.y_n[3] = this.nk_2[3] * tmp - this.dk_1[3] * this.y_n_minus_1[3] - this.y_n_minus_2[3];
    }

    public double getValue() {
        return this.y_n[0] + this.y_n[1] + this.y_n[2] + this.y_n[3];
    }

    private static int round(double value) {
        return (int)(value + 0.5);
    }

    public static class Parameters {
        private final int M;
        public final int N;
        private final double[] nk_2;
        private final double[] dk_1;
        private double Sigma = 0.0;

        public static Parameters fast(double sigma) {
            return new Parameters(3, sigma, FastGaussCalculator.round(3.2795 * sigma + 0.2546));
        }

        public static Parameters exact(double sigma) {
            return new Parameters(4, sigma, FastGaussCalculator.round(3.721 * sigma + 0.20157));
        }

        private Parameters(int _M, double sigma, int N) {
            double beta_3;
            double beta_1;
            double D21;
            double D11;
            if (sigma <= 0.0) {
                throw new IllegalArgumentException("Sigma must be positive.");
            }
            this.M = _M == 3 || _M == 4 ? _M : 3;
            this.nk_2 = new double[4];
            this.dk_1 = new double[4];
            double omega_1 = Math.PI / (2.0 * (double)N);
            double omega_3 = Math.PI * 3 / (2.0 * (double)N);
            double omega_5 = Math.PI * 5 / (2.0 * (double)N);
            double omega_7 = Math.PI * 7 / (2.0 * (double)N);
            double p_1 = 1.0 / Math.tan(0.5 * omega_1);
            double p_3 = -1.0 / Math.tan(0.5 * omega_3);
            double p_5 = 1.0 / Math.tan(0.5 * omega_5);
            double p_7 = -1.0 / Math.tan(0.5 * omega_7);
            double r_1 = 1.0 * p_1 * p_1 / Math.sin(omega_1);
            double r_3 = -1.0 * p_3 * p_3 / Math.sin(omega_3);
            double r_5 = 1.0 * p_5 * p_5 / Math.sin(omega_5);
            double r_7 = -1.0 * p_7 * p_7 / Math.sin(omega_7);
            double rho_1 = Math.exp(-0.5 * sigma * sigma * omega_1 * omega_1) / (double)N;
            double rho_3 = Math.exp(-0.5 * sigma * sigma * omega_3 * omega_3) / (double)N;
            double rho_5 = Math.exp(-0.5 * sigma * sigma * omega_5 * omega_5) / (double)N;
            double rho_7 = Math.exp(-0.5 * sigma * sigma * omega_7 * omega_7) / (double)N;
            double D_13 = p_1 * r_3 - p_3 * r_1;
            double D_35 = p_3 * r_5 - p_5 * r_3;
            double D_37 = p_3 * r_7 - p_7 * r_3;
            double D_51 = p_5 * r_1 - p_1 * r_5;
            double D_71 = p_7 * r_1 - p_1 * r_7;
            double C_15 = D_35 / D_13;
            double C_17 = D_37 / D_13;
            double C_35 = D_51 / D_13;
            double C_37 = D_71 / D_13;
            double gamma_2 = (double)(N * N) - sigma * sigma;
            double gamma_3 = C_15 * rho_1 + C_35 * rho_3 + rho_5;
            if (this.M == 3) {
                D11 = r_3 - r_5 * C_35;
                D21 = p_3 - p_5 * C_35;
                double D31 = D_35;
                double D12 = r_1 - r_5 * C_15;
                double D22 = p_1 - p_5 * C_15;
                double D32 = -D_51;
                double det_invA = p_1 * D11 - r_1 * D21 + C_15 * D31;
                beta_1 = (D11 - gamma_2 * D21 + gamma_3 * D31) / det_invA;
                beta_3 = (-D12 + gamma_2 * D22 - gamma_3 * D32) / det_invA;
            } else {
                D11 = r_3 - r_5 * C_35 - r_7 * C_37;
                D21 = p_3 - p_5 * C_35 - p_7 * C_37;
                double D31 = p_3 * r_5 + p_5 * r_7 * C_37 - p_5 * r_3 - p_7 * r_5 * C_37;
                double D41 = p_5 * r_7 * C_35 + p_7 * r_3 - p_3 * r_7 - p_7 * r_5 * C_35;
                double D12 = r_1 - r_5 * C_15 - r_7 * C_17;
                double D22 = p_1 - p_5 * C_15 - p_7 * C_17;
                double D32 = p_1 * r_5 + p_5 * r_7 * C_17 - p_5 * r_1 - p_7 * r_5 * C_17;
                double D42 = p_5 * r_7 * C_15 + p_7 * r_1 - p_1 * r_7 - p_7 * r_5 * C_15;
                double det_invA = p_1 * D11 - r_1 * D21 + C_15 * D31 - C_17 * D41;
                double gamma4 = C_17 * rho_1 + C_37 * rho_3 + rho_7;
                beta_1 = (D11 - gamma_2 * D21 + gamma_3 * D31 - gamma4 * D41) / det_invA;
                beta_3 = (-D12 + gamma_2 * D22 - gamma_3 * D32 + gamma4 * D42) / det_invA;
            }
            double beta_5 = rho_5 + C_15 * (rho_1 - beta_1) + C_35 * (rho_3 - beta_3);
            double beta_7 = rho_7 + C_17 * (rho_1 - beta_1) + C_37 * (rho_3 - beta_3);
            this.N = N;
            this.nk_2[0] = -beta_1 * Math.cos(omega_1 * (double)(N + 1));
            this.nk_2[1] = -beta_3 * Math.cos(omega_3 * (double)(N + 1));
            this.nk_2[2] = -beta_5 * Math.cos(omega_5 * (double)(N + 1));
            this.dk_1[0] = -2.0 * Math.cos(omega_1);
            this.dk_1[1] = -2.0 * Math.cos(omega_3);
            this.dk_1[2] = -2.0 * Math.cos(omega_5);
            if (this.M == 4) {
                this.nk_2[3] = -beta_7 * Math.cos(omega_7 * (double)(N + 1));
                this.dk_1[3] = -2.0 * Math.cos(omega_7);
            }
            this.Sigma = sigma;
        }
    }
}

