/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.algorithm.neighborhood.CenteredRectangleShape;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.DiamondTipsShape;
import net.imglib2.algorithm.neighborhood.HorizontalLineShape;
import net.imglib2.algorithm.neighborhood.HyperSphereShape;
import net.imglib2.algorithm.neighborhood.PeriodicLineShape;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;

public class StructuringElements {
    private static final int HEURISTICS_DIAMOND_RADIUS_2D = 4;
    private static final int HEURISTICS_DIAMOND_RADIUS_OTHERSD = 2;

    public static final List<Shape> disk(long radius, int dimensionality) {
        int decomposition = dimensionality == 2 ? (radius < 4L ? 0 : (radius < 9L ? 4 : (radius < 12L ? 6 : (radius < 17L ? 8 : 6)))) : 0;
        return StructuringElements.disk(radius, dimensionality, decomposition);
    }

    public static final List<Shape> disk(long radius, int dimensionality, int decomposition) {
        if (dimensionality == 2) {
            if (decomposition == 0) {
                ArrayList<Shape> strel = new ArrayList<Shape>(1);
                strel.add(new HyperSphereShape(radius));
                return strel;
            }
            if (decomposition == 8 || decomposition == 4 || decomposition == 6) {
                ArrayList<int[]> vectors = new ArrayList<int[]>(decomposition);
                switch (decomposition) {
                    case 4: {
                        vectors.add(new int[]{1, 0});
                        vectors.add(new int[]{1, 1});
                        vectors.add(new int[]{0, 1});
                        vectors.add(new int[]{-1, 1});
                        break;
                    }
                    case 6: {
                        vectors.add(new int[]{1, 0});
                        vectors.add(new int[]{2, 1});
                        vectors.add(new int[]{1, 2});
                        vectors.add(new int[]{0, 1});
                        vectors.add(new int[]{-1, 2});
                        vectors.add(new int[]{-2, 1});
                        break;
                    }
                    case 8: {
                        vectors.add(new int[]{1, 0});
                        vectors.add(new int[]{2, 1});
                        vectors.add(new int[]{1, 1});
                        vectors.add(new int[]{1, 2});
                        vectors.add(new int[]{0, 1});
                        vectors.add(new int[]{-1, 2});
                        vectors.add(new int[]{-1, 1});
                        vectors.add(new int[]{-2, 1});
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The decomposition number must be 0, 4, 6 or 8. Got " + decomposition + ".");
                    }
                }
                double theta = Math.PI / (double)(2 * decomposition);
                double radialExtent = (double)(2L * radius) / (1.0 / Math.tan(theta) + 1.0 / Math.sin(theta));
                ArrayList<Shape> lines = new ArrayList<Shape>(decomposition + 2);
                long actualRadius = 0L;
                for (int[] vector : vectors) {
                    double norm = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1]);
                    long span = (long)Math.floor(radialExtent / norm);
                    lines.add(new PeriodicLineShape(span, vector));
                    actualRadius += span * (long)Math.abs(vector[0]);
                }
                if (actualRadius < radius) {
                    long dif = radius - actualRadius;
                    lines.add(new HorizontalLineShape(dif, 0, false));
                    lines.add(new HorizontalLineShape(dif, 1, false));
                }
                return lines;
            }
            throw new IllegalArgumentException("The decomposition number must be 0, 4, 6 or 8. Got " + decomposition + ".");
        }
        ArrayList<Shape> strel = new ArrayList<Shape>(1);
        strel.add(new HyperSphereShape(radius));
        return strel;
    }

    public static final List<Shape> square(int radius, int dimensionality, boolean decompose) {
        if (decompose) {
            ArrayList<Shape> strels = new ArrayList<Shape>(dimensionality);
            for (int d = 0; d < dimensionality; ++d) {
                strels.add(new HorizontalLineShape(radius, d, false));
            }
            return strels;
        }
        ArrayList<Shape> strel = new ArrayList<Shape>(1);
        strel.add(new RectangleShape(radius, false));
        return strel;
    }

    public static final List<Shape> square(int radius, int dimensionality) {
        long decomposedNNeighbohoods = dimensionality * (2 * radius + 1);
        long fullNNeighbohoods = (long)Math.pow(2 * radius + 1, dimensionality);
        boolean decompose = decomposedNNeighbohoods < fullNNeighbohoods / 2L;
        return StructuringElements.square(radius, dimensionality, decompose);
    }

    public static final List<Shape> rectangle(int[] halfSpans, boolean decompose) {
        ArrayList<Shape> strels;
        if (decompose) {
            strels = new ArrayList(halfSpans.length);
            for (int d = 0; d < halfSpans.length; ++d) {
                int r = halfSpans[d];
                if ((r = Math.max(0, r)) == 0) continue;
                HorizontalLineShape line = new HorizontalLineShape(r, d, false);
                strels.add(line);
            }
        } else {
            strels = new ArrayList<Shape>(1);
            CenteredRectangleShape square = new CenteredRectangleShape(halfSpans, false);
            strels.add(square);
        }
        return strels;
    }

    public static final List<Shape> rectangle(int[] halfSpans) {
        long decomposedNNeighbohoods = 0L;
        long fullNNeighbohoods = 1L;
        for (int i = 0; i < halfSpans.length; ++i) {
            int l = 2 * halfSpans[i] + 1;
            decomposedNNeighbohoods += (long)l;
            fullNNeighbohoods *= (long)l;
        }
        if (decomposedNNeighbohoods > fullNNeighbohoods / 2L) {
            return StructuringElements.rectangle(halfSpans, false);
        }
        return StructuringElements.rectangle(halfSpans, true);
    }

    public static final List<Shape> diamond(int radius, int dimensionality) {
        boolean decompose = dimensionality <= 2 ? radius > 4 : radius > 2;
        return StructuringElements.diamond(radius, dimensionality, decompose);
    }

    public static final List<Shape> diamond(int radius, int dimensionality, boolean decompose) {
        if (decompose && radius > 1) {
            if (dimensionality <= 2) {
                int ndecomp = (int)Math.floor(Math.log(radius) / Math.log(2.0));
                ArrayList<Shape> shapes = new ArrayList<Shape>(ndecomp);
                DiamondShape shapeBase = new DiamondShape(1L);
                shapes.add(shapeBase);
                for (int k = 0; k < ndecomp; ++k) {
                    int p = 1 << k;
                    DiamondTipsShape shape = new DiamondTipsShape(p);
                    shapes.add(shape);
                }
                int q = radius - (1 << ndecomp);
                if (q > 0) {
                    DiamondTipsShape shape = new DiamondTipsShape(q);
                    shapes.add(shape);
                }
                return shapes;
            }
            ArrayList<Shape> shapes = new ArrayList<Shape>(radius);
            shapes.add(new DiamondShape(1L));
            for (int k = 0; k < radius - 1; ++k) {
                shapes.add(new DiamondTipsShape(1L));
            }
            return shapes;
        }
        ArrayList<Shape> shape = new ArrayList<Shape>(1);
        shape.add(new DiamondShape(radius));
        return shape;
    }

    public static final Shape periodicLine(long span, int[] increments) {
        return new PeriodicLineShape(span, increments);
    }
}

