/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching;

import ij.gui.Roi;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.util.Util;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;
import mpicbg.stitching.ComparePair;
import mpicbg.stitching.GlobalOptimization;
import mpicbg.stitching.ImageCollectionElement;
import mpicbg.stitching.ImagePlusTimePoint;
import mpicbg.stitching.PairWiseStitchingImgLib;
import mpicbg.stitching.PairWiseStitchingResult;
import mpicbg.stitching.StitchingParameters;
import stitching.utils.Log;

public class CollectionStitchingImgLib {
    public static ArrayList<ImagePlusTimePoint> stitchCollection(ArrayList<ImageCollectionElement> elements, final StitchingParameters params) {
        ArrayList<ImagePlusTimePoint> optimized;
        if (params.computeOverlap) {
            final Vector<ComparePair> pairs = CollectionStitchingImgLib.findOverlappingTiles(elements, params);
            if (pairs == null || pairs.size() == 0) {
                Log.error("No overlapping tiles could be found given the approximate layout.");
                return null;
            }
            final AtomicInteger ai = new AtomicInteger(0);
            final int numThreads = params.cpuMemChoice == 0 ? 1 : Runtime.getRuntime().availableProcessors();
            Thread[] threads = SimpleMultiThreading.newThreads((int)numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        for (int i = 0; i < pairs.size(); ++i) {
                            if (i % numThreads != myNumber) continue;
                            ComparePair pair = (ComparePair)pairs.get(i);
                            long start = System.currentTimeMillis();
                            Roi roi1 = CollectionStitchingImgLib.getROI(pair.getTile1().getElement(), pair.getTile2().getElement());
                            Roi roi2 = CollectionStitchingImgLib.getROI(pair.getTile2().getElement(), pair.getTile1().getElement());
                            PairWiseStitchingResult result = PairWiseStitchingImgLib.stitchPairwise(pair.getImagePlus1(), pair.getImagePlus2(), roi1, roi2, pair.getTimePoint1(), pair.getTimePoint2(), params);
                            if (result == null) {
                                Log.error("Collection stitching failed");
                                return;
                            }
                            if (params.dimensionality == 2) {
                                pair.setRelativeShift(new float[]{result.getOffset(0), result.getOffset(1)});
                            } else {
                                pair.setRelativeShift(new float[]{result.getOffset(0), result.getOffset(1), result.getOffset(2)});
                            }
                            pair.setCrossCorrelation(result.getCrossCorrelation());
                            Log.info(pair.getImagePlus1().getTitle() + "[" + pair.getTimePoint1() + "] <- " + pair.getImagePlus2().getTitle() + "[" + pair.getTimePoint2() + "]: " + Util.printCoordinates((float[])result.getOffset()) + " correlation (R)=" + result.getCrossCorrelation() + " (" + (System.currentTimeMillis() - start) + " ms)");
                        }
                    }
                });
            }
            long time = System.currentTimeMillis();
            SimpleMultiThreading.startAndJoin((Thread[])threads);
            optimized = GlobalOptimization.optimize(pairs, pairs.get(0).getTile1(), params);
            Log.info("Finished registration process (" + (System.currentTimeMillis() - time) + " ms).");
        } else {
            optimized = new ArrayList<ImagePlusTimePoint>();
            for (ImageCollectionElement element : elements) {
                TranslationModel2D model;
                ImagePlusTimePoint imt = new ImagePlusTimePoint(element.open(params.virtual), element.getIndex(), 1, element.getModel(), element);
                if (params.dimensionality == 2) {
                    model = (TranslationModel2D)imt.getModel();
                    model.set((double)element.getOffset(0), (double)element.getOffset(1));
                } else {
                    model = (TranslationModel3D)imt.getModel();
                    model.set((double)element.getOffset(0), (double)element.getOffset(1), (double)element.getOffset(2));
                }
                optimized.add(imt);
            }
        }
        return optimized;
    }

    protected static Roi getROI(ImageCollectionElement e1, ImageCollectionElement e2) {
        int[] start = new int[2];
        int[] end = new int[2];
        for (int dim = 0; dim < 2; ++dim) {
            if (e2.offset[dim] >= e1.offset[dim] && e2.offset[dim] <= e1.offset[dim] + (float)e1.size[dim]) {
                start[dim] = Math.round(e2.offset[dim] - e1.offset[dim]);
                if (e2.offset[dim] + (float)e2.size[dim] <= e1.offset[dim] + (float)e1.size[dim]) {
                    end[dim] = Math.round(e2.offset[dim] + (float)e2.size[dim] - e1.offset[dim]);
                    continue;
                }
                end[dim] = Math.round(e1.size[dim]);
                continue;
            }
            if (e2.offset[dim] + (float)e2.size[dim] <= e1.offset[dim] + (float)e1.size[dim]) {
                start[dim] = 0;
                end[dim] = Math.round(e2.offset[dim] + (float)e2.size[dim] - e1.offset[dim]);
                continue;
            }
            start[dim] = -1;
            end[dim] = -1;
        }
        return new Roi(new Rectangle(start[0], start[1], end[0] - start[0], end[1] - start[1]));
    }

    protected static Vector<ComparePair> findOverlappingTiles(ArrayList<ImageCollectionElement> elements, StitchingParameters params) {
        for (ImageCollectionElement imageCollectionElement : elements) {
            if (imageCollectionElement.open(params.virtual) != null) continue;
            return null;
        }
        ArrayList<ImagePlusTimePoint> listImp = new ArrayList<ImagePlusTimePoint>();
        for (ImageCollectionElement element : elements) {
            listImp.add(new ImagePlusTimePoint(element.open(params.virtual), element.getIndex(), 1, element.getModel(), element));
        }
        Vector<ComparePair> vector = new Vector<ComparePair>();
        if (params.sequential) {
            for (int i = 0; i < elements.size(); ++i) {
                for (int j = 1; j <= params.seqRange && i + j < elements.size(); ++j) {
                    vector.add(new ComparePair((ImagePlusTimePoint)listImp.get(i), (ImagePlusTimePoint)listImp.get(i + j)));
                }
            }
            return vector;
        }
        for (int i = 0; i < elements.size() - 1; ++i) {
            for (int j = i + 1; j < elements.size(); ++j) {
                ImageCollectionElement e1 = elements.get(i);
                ImageCollectionElement e2 = elements.get(j);
                boolean overlapping = true;
                for (int d = 0; d < params.dimensionality; ++d) {
                    if (e2.offset[d] >= e1.offset[d] && e2.offset[d] <= e1.offset[d] + (float)e1.size[d] || e2.offset[d] + (float)e2.size[d] >= e1.offset[d] && e2.offset[d] + (float)e2.size[d] <= e1.offset[d] + (float)e1.size[d] || e2.offset[d] <= e1.offset[d] && e2.offset[d] >= e1.offset[d] + (float)e1.size[d]) continue;
                    overlapping = false;
                }
                if (!overlapping) continue;
                vector.add(new ComparePair((ImagePlusTimePoint)listImp.get(i), (ImagePlusTimePoint)listImp.get(j)));
            }
        }
        return vector;
    }
}

