/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DM3_Reader
extends ImagePlus
implements PlugIn {
    public boolean useGatanMinMax = true;
    private boolean littleEndian = true;
    private RandomAccessFile f;
    private FileInfo fi;
    private String notes = "";
    private final int debugLevel = IJ.debugMode ? 10 : 0;
    private int chosenImage = 1;
    private boolean chooseImageInteractive = false;
    private boolean openAsTimeSeries = false;
    private int curGroupLevel = -1;
    private static final int MAXDEPTH = 64;
    private int[] curGroupAtLevelX = new int[64];
    private String[] curGroupNameAtLevelX = new String[64];
    private int[] curTagAtLevelX = new int[64];
    private String curTagName = "";
    private Vector storedTags = new Vector();
    private Hashtable tagHash = new Hashtable();
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int USHORT = 4;
    private static final int ULONG = 5;
    private static final int FLOAT = 6;
    private static final int DOUBLE = 7;
    private static final int BOOLEAN = 8;
    private static final int CHAR = 9;
    private static final int OCTET = 10;
    private static final int STRUCT = 15;
    private static final int STRING = 18;
    private static final int ARRAY = 20;
    private static final String IMGLIST = "root.ImageList.";
    private static final String IMGSRCLIST = "root.ImageSourceList.";
    private static final String OBJLIST = "root.DocumentObjectList.";

    public void run(String arg) {
        String directory = "";
        String fileName = arg;
        if (IJ.altKeyDown()) {
            this.chooseImageInteractive = true;
            if (IJ.debugMode) {
                IJ.log((String)"Choosing image to open interactively");
            }
        }
        if (this.debugLevel > 5) {
            IJ.log((String)("IN:dir = " + directory + ", file=" + fileName));
        }
        if (arg == null || arg == "") {
            OpenDialog od = new OpenDialog("Load DM3 File...", arg);
            fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            directory = od.getDirectory();
            if (this.debugLevel > 5) {
                IJ.log((String)("IF:dir = " + directory + ", file=" + fileName));
            }
        } else {
            File dest = new File(arg);
            directory = dest.getParent();
            fileName = dest.getName();
            if (this.debugLevel > 5) {
                IJ.log((String)("ELSE:dir = " + directory + ", file=" + fileName));
            }
        }
        ImagePlus imp = this.load(directory, fileName);
        if (imp == null) {
            return;
        }
        this.setStack(fileName, imp.getStack());
        this.setFileInfo(this.fi);
        this.setProcessor(fileName, imp.getProcessor());
        this.copyScale(imp);
        this.setProperty("Info", imp.getProperty("Info"));
        if (this.openAsTimeSeries) {
            this.setDimensions(1, 1, this.fi.nImages);
        }
        if (imp.getProperty("FHT") != null) {
            this.setProperty("FHT", imp.getProperty("FHT"));
        }
        if (arg.equals("")) {
            this.show();
        }
    }

    public ImagePlus load(String directory, String fileName) {
        if (fileName == null || fileName == "") {
            return null;
        }
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        IJ.showStatus((String)("Loading DM3 File: " + directory + fileName));
        this.tagHash.clear();
        this.storedTags.clear();
        try {
            this.parseDM3(directory, fileName);
        }
        catch (Exception e) {
            IJ.showStatus((String)"parseDM3() error");
            IJ.showMessage((String)"DM3_Reader", (String)("" + e));
            return null;
        }
        this.chooseImageToLoad();
        this.fi = new FileInfo();
        try {
            this.fi = this.getDM3FileInfo(directory, fileName);
        }
        catch (Exception e) {
            IJ.showStatus((String)"");
            IJ.showMessage((String)"DM3_Reader", (String)("gDM3:" + e));
            return null;
        }
        if (this.debugLevel > 1) {
            IJ.log((String)("Calculated offset = " + this.fi.offset));
        }
        if (this.debugLevel > 1) {
            IJ.log((String)("Chosen image = " + this.chosenImage));
        }
        FileOpener fo = new FileOpener(this.fi);
        ImagePlus imp = fo.open(false);
        StringBuffer notesBuffer = new StringBuffer();
        for (int i = 0; i < this.storedTags.size(); ++i) {
            notesBuffer.append((String)this.storedTags.elementAt(i) + "\n");
        }
        this.notes = notesBuffer.toString();
        if (!this.notes.equals("")) {
            imp.setProperty("Info", (Object)this.notes);
        }
        try {
            imp.setCalibration(this.getDM3CalibrationInfo(imp.getCalibration()));
        }
        catch (Exception e) {
            IJ.showStatus((String)("No Calibration info in " + fileName));
        }
        String imagingMode = (String)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageTags.Microscope Info.Imaging Mode");
        if (imagingMode != null && imagingMode.toUpperCase().equals("DIFFRACTION")) {
            imp.setProperty("FHT", (Object)"Dummy FHT");
        }
        if (this.useGatanMinMax) {
            double hiVal = 0.0;
            double loVal = 0.0;
            Enumeration e = this.tagHash.keys();
            while (e.hasMoreElements()) {
                String thisElementString = (String)e.nextElement();
                if (thisElementString.endsWith("ImageDisplayInfo.HighLimit")) {
                    hiVal = ((Float)this.tagHash.get(thisElementString)).doubleValue();
                }
                if (!thisElementString.endsWith("ImageDisplayInfo.LowLimit")) continue;
                loVal = ((Float)this.tagHash.get(thisElementString)).doubleValue();
            }
            if (hiVal != 0.0 || loVal != 0.0) {
                if (this.debugLevel > 1) {
                    IJ.log((String)("Setting min:" + loVal + " and max:" + hiVal + " brightness based on Gatan properties"));
                }
                ImageProcessor ip = imp.getProcessor();
                ip.setMinAndMax(imp.getCalibration().getRawValue(loVal), imp.getCalibration().getRawValue(hiVal));
            } else if (this.debugLevel > 1) {
                IJ.log((String)"Leaving ImageJ to set min and max values");
            }
        }
        return imp;
    }

    void parseDM3(String directory, String fileName) throws IOException {
        int fileVersion;
        this.f = new RandomAccessFile(directory + fileName, "r");
        if (this.debugLevel > 0) {
            IJ.log((String)("Directory = " + directory));
        }
        if (this.debugLevel > 0) {
            IJ.log((String)("File = " + fileName));
        }
        if ((fileVersion = this.f.readInt()) != 3) {
            throw new IOException("This does not seem to be a DM3 file");
        }
        if (this.debugLevel > 5) {
            IJ.log((String)("File Version" + fileVersion));
        }
        int FileSize = this.f.readInt();
        int lE = this.f.readInt();
        if (this.debugLevel > 5) {
            IJ.log((String)("lE " + lE));
        }
        if (lE == 1) {
            this.littleEndian = true;
        } else if (lE == 0) {
            this.littleEndian = false;
        } else {
            throw new IOException("This does not seem to be a DM3 file");
        }
        this.curGroupNameAtLevelX[0] = "root";
        this.readTagGroup();
        this.f.close();
    }

    void chooseImageToLoad() {
        this.chosenImage = -1;
        if (this.tagHash.containsKey("root.ImageSourceList.0.ImageRef")) {
            this.chosenImage = (Integer)this.tagHash.get("root.ImageSourceList.0.ImageRef");
            if (this.debugLevel > 1) {
                IJ.log((String)("Choosing image: " + this.chosenImage + " based on image source list"));
            }
            if (!this.chooseImageInteractive) {
                return;
            }
        }
        int biggestImage = 0;
        int i = 0;
        long mostPixelsSoFar = 0L;
        while (true) {
            String rString = ".ImageData.Data.Size";
            if (this.debugLevel > 1) {
                IJ.log((String)("Looking for:root.ImageList." + i + rString));
            }
            if (!this.tagHash.containsKey(IMGLIST + i + rString)) break;
            if (this.debugLevel > 1) {
                IJ.log((String)("Found:root.ImageList." + i + rString));
            }
            int pixelDepth = (Integer)this.tagHash.get(IMGLIST + i + ".ImageData.PixelDepth");
            long numPixels = (Long)this.tagHash.get(IMGLIST + i + rString) / (long)pixelDepth;
            if (this.debugLevel > 1) {
                IJ.log((String)("Current Number of Pixels" + numPixels));
            }
            if (numPixels > mostPixelsSoFar) {
                mostPixelsSoFar = numPixels;
                if (this.debugLevel > 1) {
                    IJ.log((String)("New Largest Image (by number of pixels):" + mostPixelsSoFar));
                }
                biggestImage = i;
                if (this.debugLevel > 1) {
                    IJ.log((String)("New Chosen Image:" + biggestImage));
                }
            }
            ++i;
        }
        if (this.chosenImage < 0) {
            this.chosenImage = biggestImage;
        }
        if (this.chooseImageInteractive) {
            GenericDialog gd = new GenericDialog("Select Image to Open");
            gd.addMessage("There are " + i + " images in this file");
            String[] seriesStrings = new String[i];
            for (i = 0; i < seriesStrings.length; ++i) {
                seriesStrings[i] = this.tagHash.containsKey(IMGLIST + i + ".Name") ? (String)this.tagHash.get(IMGLIST + i + ".Name") : "Image " + i;
            }
            gd.addChoice("Images", seriesStrings, seriesStrings[this.chosenImage]);
            gd.showDialog();
            this.chosenImage = gd.getNextChoiceIndex();
            if (this.debugLevel > 1) {
                IJ.log((String)("Chosen image is:" + this.chosenImage));
            }
        }
    }

    FileInfo getDM3FileInfo(String directory, String fileName) throws IOException {
        FileInfo fi = new FileInfo();
        fi.fileFormat = 1;
        fi.fileName = fileName;
        fi.directory = directory;
        fi.intelByteOrder = this.littleEndian;
        fi.width = (Integer)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Dimensions.0");
        try {
            fi.height = (Integer)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Dimensions.1");
        }
        catch (Exception e) {
            IJ.log((String)"Image height missing. Assuming = 1.");
            fi.height = 1;
        }
        if (this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Dimensions.2") != null) {
            fi.nImages = (Integer)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Dimensions.2");
        }
        fi.offset = ((Long)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Data.Offset")).intValue();
        if (this.debugLevel > 1) {
            IJ.log((String)("Chosen image " + this.chosenImage + " with dimensions: " + fi.width + " x " + fi.height + " x " + fi.nImages + " is at offset: " + fi.offset));
        }
        int dataType = (Integer)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.DataType");
        switch (dataType) {
            case 1: {
                fi.fileType = 1;
                break;
            }
            case 10: {
                fi.fileType = 2;
                break;
            }
            case 2: {
                fi.fileType = 4;
                break;
            }
            case 12: {
                fi.fileType = 16;
                break;
            }
            case 6: {
                fi.fileType = 0;
                break;
            }
            case 7: {
                fi.fileType = 3;
                break;
            }
            case 11: {
                fi.fileType = 11;
                break;
            }
            case 8: 
            case 15: {
                fi.fileType = 6;
                break;
            }
            case 16: {
                fi.fileType = 10;
                break;
            }
            case 17: {
                fi.fileType = 12;
                break;
            }
            case 14: {
                fi.fileType = 8;
                break;
            }
            case 23: {
                fi.fileType = 18;
                break;
            }
            default: {
                throw new IOException("Unimplemented ImageData dataType=" + dataType + " in DM3 file.  See getDM3FileInfo() for details");
            }
        }
        return fi;
    }

    Calibration getDM3CalibrationInfo(Calibration cal) {
        String unit = (String)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Calibrations.Dimension.0.Units");
        if (unit.startsWith("1/")) {
            unit = unit.substring(2);
        }
        if (unit.equals("\u00b5m")) {
            cal.setUnit("micron");
        } else {
            cal.setUnit(unit);
        }
        if (this.debugLevel > 0) {
            IJ.log((String)("Calibration unit: " + unit));
        }
        cal.pixelWidth = ((Float)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Calibrations.Dimension.0.Scale")).doubleValue();
        cal.pixelHeight = ((Float)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Calibrations.Dimension.1.Scale")).doubleValue();
        if (this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Calibrations.Dimension.2.Scale") != null) {
            double zstep = ((Float)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Calibrations.Dimension.2.Scale")).doubleValue();
            String zunits = (String)this.tagHash.get(IMGLIST + this.chosenImage + ".ImageData.Calibrations.Dimension.2.Units");
            if (zunits == null || unit.equals(zunits)) {
                cal.pixelDepth = zstep;
            } else {
                this.openAsTimeSeries = true;
                cal.setTimeUnit(zunits);
                cal.frameInterval = zstep;
            }
        }
        return cal;
    }

    int readTagGroup() throws IOException {
        int n = ++this.curGroupLevel;
        this.curGroupAtLevelX[n] = this.curGroupAtLevelX[n] + 1;
        this.curTagAtLevelX[this.curGroupLevel] = -1;
        if (this.debugLevel > 5) {
            IJ.log((String)("rTG: Current Group Level: " + this.curGroupLevel));
        }
        byte isSorted = this.f.readByte();
        byte isOpen = this.f.readByte();
        int nTags = this.f.readInt();
        if (this.debugLevel > 5) {
            IJ.log((String)("rTG: Iterating over the " + nTags + " tag entries in this group"));
        }
        for (int i = 0; i < nTags; ++i) {
            this.readTagEntry();
        }
        --this.curGroupLevel;
        return 1;
    }

    String makeGroupString() {
        String tString = new String("" + this.curGroupAtLevelX[0]);
        for (int i = 1; i <= this.curGroupLevel; ++i) {
            tString = tString + "." + this.curGroupAtLevelX[i];
        }
        return tString;
    }

    int readTagEntry() throws IOException {
        byte isData = this.f.readByte();
        int n = this.curGroupLevel;
        this.curTagAtLevelX[n] = this.curTagAtLevelX[n] + 1;
        short lenTagLabel = this.f.readShort();
        String tagLabel = lenTagLabel != 0 ? this.readString(lenTagLabel) : new String("" + this.curTagAtLevelX[this.curGroupLevel]);
        if (this.debugLevel > 5) {
            IJ.log((String)(this.curGroupLevel + "|" + this.makeGroupString() + ": Tag label = " + tagLabel));
        } else if (this.debugLevel > 0) {
            IJ.log((String)(this.curGroupLevel + ": Tag label = " + tagLabel));
        }
        if (isData == 21) {
            this.curTagName = new String(this.makeGroupNameString() + "." + tagLabel);
            this.readTagType();
        } else {
            this.curGroupNameAtLevelX[this.curGroupLevel + 1] = tagLabel;
            this.readTagGroup();
        }
        return 1;
    }

    String makeGroupNameString() {
        String tString = new String(this.curGroupNameAtLevelX[0]);
        for (int i = 1; i <= this.curGroupLevel; ++i) {
            tString = tString + "." + this.curGroupNameAtLevelX[i];
        }
        return tString;
    }

    int readTagType() throws IOException {
        int Delim = this.f.readInt();
        if (Delim != 0x25252525) {
            throw new IOException("Tag Type delimiter not %%%%");
        }
        int nInTag = this.f.readInt();
        this.readAnyData();
        return 1;
    }

    int readAnyData() throws IOException {
        int encodedType = this.f.readInt();
        int etSize = this.encodedTypeSize(encodedType);
        if (this.debugLevel > 5) {
            IJ.log((String)("rAnD, " + this.hexPosition() + ": Tag Type = " + encodedType + ", Tag Size = " + etSize));
        }
        if (etSize > 0) {
            this.storeTag(this.curTagName, this.readNativeData(encodedType, etSize));
        } else if (encodedType == 18) {
            int stringSize = this.f.readInt();
            this.readStringData(stringSize);
        } else if (encodedType == 15) {
            Vector structTypes = this.readStructTypes();
            this.readStructData(structTypes);
        } else if (encodedType == 20) {
            Vector arrayTypes = this.readArrayTypes();
            this.readArrayData(arrayTypes);
        } else {
            throw new IOException("rAnD, 0x" + this.hexPosition() + ": Can't understand encoded type");
        }
        return 1;
    }

    Object readNativeData(int encodedType, int etSize) throws IOException {
        Comparable<Short> val = null;
        if (encodedType == 2) {
            val = new Short(this.blreadShort());
        } else if (encodedType == 3) {
            val = new Integer(this.blreadInt());
        } else if (encodedType == 4) {
            val = new Short(this.blreadUShort());
        } else if (encodedType == 5) {
            val = new Integer(this.blreadInt());
        } else if (encodedType == 6) {
            val = new Float(this.blreadFloat());
        } else if (encodedType == 7) {
            val = new Double(this.blreadDouble());
        } else if (encodedType == 8) {
            val = this.f.readByte() == 0 ? new Boolean(false) : new Boolean(true);
        } else if (encodedType == 9) {
            val = new Character((char)this.f.readByte());
        } else if (encodedType == 10) {
            val = new Byte(this.f.readByte());
        } else {
            throw new IOException("rND, 0x" + this.hexPosition() + ": Unknown data type " + encodedType);
        }
        if (this.debugLevel > 3) {
            IJ.log((String)("rND, 0x" + this.hexPosition() + ": " + val));
        } else if (this.debugLevel > 0) {
            IJ.log((String)("" + val));
        }
        return val;
    }

    String readStringData(int stringSize) throws IOException {
        String rString;
        if (stringSize <= 0) {
            return new String("");
        }
        byte[] temp = new byte[stringSize];
        this.f.read(temp, 0, stringSize);
        if (this.littleEndian) {
            try {
                rString = new String(temp, "UTF-16LE");
            }
            catch (Exception e) {
                rString = "";
                for (int i = 0; i < stringSize; i += 2) {
                    rString = rString + new Character((char)((temp[i + 1] & 0xFF) << 8 | temp[i] & 0xFF));
                }
            }
        } else {
            try {
                rString = new String(temp, "UTF-16BE");
            }
            catch (Exception e) {
                rString = "";
                for (int i = 0; i < stringSize; i += 2) {
                    rString = rString + new Character((char)((temp[i] & 0xFF) << 8 | temp[i + 1] & 0xFF));
                }
            }
        }
        if (this.debugLevel > 0) {
            IJ.log((String)("StringVal: " + rString));
        }
        this.storeTag(this.curTagName, rString);
        return rString;
    }

    Vector readArrayTypes() throws IOException {
        int arrayType = this.f.readInt();
        Vector itemTypes = new Vector();
        if (arrayType == 15) {
            itemTypes = this.readStructTypes();
        } else if (arrayType == 20) {
            itemTypes = this.readArrayTypes();
        } else {
            itemTypes.addElement(new Integer(arrayType));
        }
        return itemTypes;
    }

    int readArrayData(Vector arrayTypes) throws IOException {
        int arraySize = this.f.readInt();
        if (this.debugLevel > 3) {
            IJ.log((String)("rArD, 0x" + this.hexPosition() + ": Reading array of size = " + arraySize));
        }
        int itemSize = 0;
        int encodedType = 0;
        for (int i = 0; i < arrayTypes.size(); ++i) {
            encodedType = (Integer)arrayTypes.elementAt(i);
            int etSize = this.encodedTypeSize(encodedType);
            itemSize += etSize;
            if (this.debugLevel <= 5) continue;
            IJ.log((String)("rArD: Tag Type = " + encodedType + ", Tag Size = " + etSize));
        }
        if (this.debugLevel > 5) {
            IJ.log((String)("rArD: Array Item Size = " + itemSize));
        }
        long bufSize = (long)arraySize * (long)itemSize;
        if (!this.curTagName.endsWith("ImageData.Data") && arrayTypes.size() == 1 && encodedType == 4 && arraySize < 256) {
            String string = this.readStringData((int)bufSize);
        } else {
            this.storeTag(this.curTagName + ".Size", new Long(bufSize));
            this.storeTag(this.curTagName + ".Offset", new Long(this.f.getFilePointer()));
            this.f.seek(this.f.getFilePointer() + bufSize);
        }
        return 1;
    }

    Vector readStructTypes() throws IOException {
        if (this.debugLevel > 3) {
            IJ.log((String)("Reading Struct Types at Pos = " + this.f.getFilePointer() + ", 0x" + this.hexPosition()));
        }
        int structNameLength = this.f.readInt();
        int nFields = this.f.readInt();
        if (this.debugLevel > 5) {
            IJ.log((String)("nFields = " + nFields));
        }
        if (nFields > 100) {
            throw new IOException("Too many fields");
        }
        Vector<Integer> fieldTypes = new Vector<Integer>();
        int nameLength = 0;
        for (int i = 0; i < nFields; ++i) {
            nameLength = this.f.readInt();
            if (this.debugLevel > 10) {
                IJ.log((String)(i + "th namelength = " + nameLength));
            }
            int fieldType = this.f.readInt();
            fieldTypes.addElement(new Integer(fieldType));
        }
        return fieldTypes;
    }

    int readStructData(Vector structTypes) throws IOException {
        String structAsString = "";
        for (int i = 0; i < structTypes.size(); ++i) {
            Integer iTagType = (Integer)structTypes.elementAt(i);
            int encodedType = iTagType;
            int etSize = this.encodedTypeSize(encodedType);
            if (this.debugLevel > 5) {
                IJ.log((String)("Tag Type = " + encodedType + ", Tag Size = " + etSize));
            }
            structAsString = structAsString + this.readNativeData(encodedType, etSize);
            if (i + 1 == structTypes.size()) continue;
            structAsString = structAsString + ",";
        }
        this.storeTag(this.curTagName, "{" + structAsString + "}");
        return 1;
    }

    int encodedTypeSize(int encodedType) {
        int width = -1;
        switch (encodedType) {
            case 0: {
                width = 0;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                width = 1;
                break;
            }
            case 2: 
            case 4: {
                width = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                width = 4;
                break;
            }
            case 7: {
                width = 8;
            }
        }
        return width;
    }

    void storeTag(String tagName, Object tagValue) {
        this.storedTags.addElement(new String(tagName + " = " + tagValue));
        this.tagHash.put(tagName, tagValue);
    }

    short blreadShort() throws IOException {
        if (!this.littleEndian) {
            return this.f.readShort();
        }
        byte b1 = this.f.readByte();
        byte b2 = this.f.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    short blreadUShort() throws IOException {
        if (!this.littleEndian) {
            return (short)this.f.readUnsignedShort();
        }
        byte b1 = this.f.readByte();
        byte b2 = this.f.readByte();
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    int blreadInt() throws IOException {
        if (!this.littleEndian) {
            return this.f.readInt();
        }
        byte b1 = this.f.readByte();
        byte b2 = this.f.readByte();
        byte b3 = this.f.readByte();
        byte b4 = this.f.readByte();
        return (b4 & 0xFF) << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    long blreadLong() throws IOException {
        if (!this.littleEndian) {
            return this.f.readLong();
        }
        int i1 = this.blreadInt();
        int i2 = this.blreadInt();
        return (long)(i2 & 0xFFFFFFFF) << 32 | (long)(i1 & 0xFFFFFFFF);
    }

    double blreadDouble() throws IOException {
        if (!this.littleEndian) {
            return this.f.readDouble();
        }
        byte[] eightbytes = new byte[8];
        this.f.read(eightbytes);
        return ByteBuffer.wrap(eightbytes).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    float blreadFloat() throws IOException {
        if (!this.littleEndian) {
            return this.f.readFloat();
        }
        int orig = this.blreadInt();
        return Float.intBitsToFloat(orig);
    }

    String readString(int n) throws IOException {
        if (n > 2000) {
            throw new IOException("Can't handle strings longer than 2000 chars, n = " + n + " at pos = " + this.f.getFilePointer());
        }
        byte[] temp = new byte[n];
        this.f.read(temp, 0, n);
        return new String(temp);
    }

    String hexPosition() throws IOException {
        return Long.toHexString(this.f.getFilePointer());
    }
}

