/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.ObserverFullArbiter;
import io.reactivex.internal.observers.FullArbiterObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableTimeoutTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final ObservableSource<? extends T> other;
    static final Disposable NEW_TIMER = new Disposable(){

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return true;
        }
    };

    public ObservableTimeoutTimed(ObservableSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler, ObservableSource<? extends T> other) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        if (this.other == null) {
            this.source.subscribe(new TimeoutTimedObserver<T>(new SerializedObserver<T>(t), this.timeout, this.unit, this.scheduler.createWorker()));
        } else {
            this.source.subscribe(new TimeoutTimedOtherObserver<T>(t, this.timeout, this.unit, this.scheduler.createWorker(), this.other));
        }
    }

    static final class TimeoutTimedObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -8387234228317808253L;
        final Observer<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Disposable s;
        volatile long index;
        volatile boolean done;

        TimeoutTimedObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                this.scheduleTimeout(0L);
            }
        }

        @Override
        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            this.actual.onNext(t);
            this.scheduleTimeout(idx);
        }

        void scheduleTimeout(final long idx) {
            Disposable d = (Disposable)this.get();
            if (d != null) {
                d.dispose();
            }
            if (this.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (idx == TimeoutTimedObserver.this.index) {
                            TimeoutTimedObserver.this.done = true;
                            DisposableHelper.dispose(TimeoutTimedObserver.this);
                            TimeoutTimedObserver.this.s.dispose();
                            TimeoutTimedObserver.this.actual.onError(new TimeoutException());
                            TimeoutTimedObserver.this.worker.dispose();
                        }
                    }
                }, this.timeout, this.unit);
                DisposableHelper.replace(this, d);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.worker.dispose();
            DisposableHelper.dispose(this);
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }
    }

    static final class TimeoutTimedOtherObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -4619702551964128179L;
        final Observer<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final ObservableSource<? extends T> other;
        Disposable s;
        final ObserverFullArbiter<T> arbiter;
        volatile long index;
        volatile boolean done;

        TimeoutTimedOtherObserver(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, ObservableSource<? extends T> other) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.other = other;
            this.arbiter = new ObserverFullArbiter<T>(actual, this, 8);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                if (this.arbiter.setDisposable(s)) {
                    this.actual.onSubscribe(this.arbiter);
                    this.scheduleTimeout(0L);
                }
            }
        }

        @Override
        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            if (this.arbiter.onNext(t, this.s)) {
                this.scheduleTimeout(idx);
            }
        }

        void scheduleTimeout(final long idx) {
            Disposable d = (Disposable)this.get();
            if (d != null) {
                d.dispose();
            }
            if (this.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (idx == TimeoutTimedOtherObserver.this.index) {
                            TimeoutTimedOtherObserver.this.done = true;
                            TimeoutTimedOtherObserver.this.s.dispose();
                            DisposableHelper.dispose(TimeoutTimedOtherObserver.this);
                            TimeoutTimedOtherObserver.this.subscribeNext();
                            TimeoutTimedOtherObserver.this.worker.dispose();
                        }
                    }
                }, this.timeout, this.unit);
                DisposableHelper.replace(this, d);
            }
        }

        void subscribeNext() {
            this.other.subscribe(new FullArbiterObserver<T>(this.arbiter));
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.worker.dispose();
            DisposableHelper.dispose(this);
            this.arbiter.onError(t, this.s);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.worker.dispose();
            DisposableHelper.dispose(this);
            this.arbiter.onComplete(this.s);
        }

        @Override
        public void dispose() {
            this.worker.dispose();
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }
    }
}

