/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.blocks.Extension;
import net.imglib2.outofbounds.OutOfBoundsFactory;

class ExtensionImpl {
    static final Extension border = new DefaultExtension(Extension.Type.BORDER);
    static final Extension mirrorSingle = new DefaultExtension(Extension.Type.MIRROR_SINGLE);
    static final Extension mirrorDouble = new DefaultExtension(Extension.Type.MIRROR_DOUBLE);

    ExtensionImpl() {
    }

    static class ConstantExtension<T>
    extends DefaultExtension {
        private final T value;

        ConstantExtension(T value) {
            super(Extension.Type.CONSTANT);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return "Extension{" + (Object)((Object)this.type()) + ", value=" + this.value.getClass().getSimpleName() + "(" + this.value + ")}";
        }
    }

    static class UnknownExtension<T, F>
    extends DefaultExtension {
        private final OutOfBoundsFactory<T, F> oobFactory;

        UnknownExtension(OutOfBoundsFactory<T, F> oobFactory) {
            super(Extension.Type.UNKNOWN);
            this.oobFactory = oobFactory;
        }

        public OutOfBoundsFactory<T, F> getOobFactory() {
            return this.oobFactory;
        }

        @Override
        public String toString() {
            return "Extension{" + (Object)((Object)this.type()) + ", oobFactory=" + this.oobFactory.getClass().getSimpleName() + '}';
        }
    }

    static class DefaultExtension
    implements Extension {
        private final Extension.Type type;

        DefaultExtension(Extension.Type type) {
            this.type = type;
        }

        @Override
        public Extension.Type type() {
            return this.type;
        }

        public String toString() {
            return "Extension{" + (Object)((Object)this.type) + '}';
        }
    }
}

