/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.neighborsearch;

import java.util.Arrays;
import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.kdtree.KNearestNeighborSearchImpl;
import net.imglib2.neighborsearch.KNearestNeighborSearch;

public class KNearestNeighborSearchOnKDTree<T>
implements KNearestNeighborSearch<T> {
    private final KDTree<T> tree;
    private final int k;
    private final KNearestNeighborSearchImpl impl;
    private final KDTreeNode<T>[] matches;

    public KNearestNeighborSearchOnKDTree(KDTree<T> tree, int k) {
        this.tree = tree;
        this.k = k;
        this.impl = new KNearestNeighborSearchImpl(tree.impl(), k);
        this.matches = new KDTreeNode[k];
        Arrays.setAll(this.matches, i -> tree.createNode());
    }

    private KNearestNeighborSearchOnKDTree(KNearestNeighborSearchOnKDTree<T> knn) {
        this.tree = knn.tree;
        this.k = knn.k;
        this.impl = knn.impl.copy();
        this.matches = new KDTreeNode[this.k];
        Arrays.setAll(this.matches, i -> this.tree.createNode().setNodeIndex(this.impl.bestIndex(i)));
    }

    @Override
    public int numDimensions() {
        return this.tree.numDimensions();
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public void search(RealLocalizable p) {
        this.impl.search(p);
        for (int i = 0; i < this.k; ++i) {
            this.matches[i].setNodeIndex(this.impl.bestIndex(i));
        }
    }

    @Override
    public Sampler<T> getSampler(int i) {
        return this.matches[i];
    }

    @Override
    public RealLocalizable getPosition(int i) {
        return this.matches[i];
    }

    @Override
    public double getSquareDistance(int i) {
        return this.impl.bestSquDistance(i);
    }

    @Override
    public KNearestNeighborSearchOnKDTree<T> copy() {
        return new KNearestNeighborSearchOnKDTree<T>(this);
    }

    @Override
    public RealLocalizable getPosition() {
        return this.getPosition(0);
    }

    @Override
    public Sampler<T> getSampler() {
        return this.getSampler(0);
    }

    @Override
    public double getSquareDistance() {
        return this.getSquareDistance(0);
    }

    @Override
    public double getDistance() {
        return this.getDistance(0);
    }
}

