/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer;

import java.util.Arrays;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.transform.integer.AbstractMixedTransform;
import net.imglib2.transform.integer.Mixed;

public class MixedTransform
extends AbstractMixedTransform
implements Concatenable<Mixed>,
PreConcatenable<Mixed> {
    protected final int numSourceDimensions;
    protected final long[] translation;
    protected final boolean[] zero;
    protected final boolean[] invert;
    protected final int[] component;

    public MixedTransform(int sourceDim, int targetDim) {
        super(targetDim);
        this.numSourceDimensions = sourceDim;
        this.translation = new long[targetDim];
        this.zero = new boolean[targetDim];
        this.invert = new boolean[targetDim];
        this.component = new int[targetDim];
        for (int d = 0; d < targetDim; ++d) {
            if (d < sourceDim) {
                this.component[d] = d;
                continue;
            }
            this.component[d] = 0;
            this.zero[d] = true;
        }
    }

    @Override
    public int numSourceDimensions() {
        return this.numSourceDimensions;
    }

    @Override
    public void getTranslation(long[] t) {
        assert (t.length == this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            t[d] = this.translation[d];
        }
    }

    @Override
    public long getTranslation(int d) {
        assert (d <= this.numTargetDimensions);
        return this.translation[d];
    }

    public void setTranslation(long[] t) {
        assert (t.length == this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.translation[d] = t[d];
        }
    }

    public void setInverseTranslation(long[] tinv) {
        assert (tinv.length == this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.translation[d] = -tinv[d];
        }
    }

    @Override
    public void getComponentZero(boolean[] zero) {
        assert (zero.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            zero[d] = this.zero[d];
        }
    }

    @Override
    public boolean getComponentZero(int d) {
        assert (d <= this.numTargetDimensions);
        return this.zero[d];
    }

    public void setComponentZero(boolean[] zero) {
        assert (zero.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.zero[d] = zero[d];
        }
    }

    @Override
    public void getComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            component[d] = this.component[d];
        }
    }

    @Override
    public int getComponentMapping(int d) {
        assert (d <= this.numTargetDimensions);
        return this.component[d];
    }

    public void setComponentMapping(int[] component) {
        assert (component.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.component[d] = component[d];
        }
    }

    @Override
    public void getComponentInversion(boolean[] invert) {
        assert (invert.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            invert[d] = this.invert[d];
        }
    }

    @Override
    public boolean getComponentInversion(int d) {
        assert (d <= this.numTargetDimensions);
        return this.invert[d];
    }

    public void setComponentInversion(boolean[] invert) {
        assert (invert.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            this.invert[d] = invert[d];
        }
    }

    @Override
    public void apply(long[] source, long[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = this.translation[d];
            if (this.zero[d]) continue;
            long v = source[this.component[d]];
            if (this.invert[d]) {
                int n = d;
                target[n] = target[n] - v;
                continue;
            }
            int n = d;
            target[n] = target[n] + v;
        }
    }

    @Override
    public void apply(int[] source, int[] target) {
        assert (source.length >= this.numSourceDimensions);
        assert (target.length >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            target[d] = (int)this.translation[d];
            if (this.zero[d]) continue;
            long v = source[this.component[d]];
            if (this.invert[d]) {
                int n = d;
                target[n] = (int)((long)target[n] - v);
                continue;
            }
            int n = d;
            target[n] = (int)((long)target[n] + v);
        }
    }

    @Override
    public void apply(Localizable source, Positionable target) {
        assert (source.numDimensions() >= this.numSourceDimensions);
        assert (target.numDimensions() >= this.numTargetDimensions);
        for (int d = 0; d < this.numTargetDimensions; ++d) {
            long pos = this.translation[d];
            if (!this.zero[d]) {
                long v = source.getLongPosition(this.component[d]);
                pos = this.invert[d] ? (pos -= v) : (pos += v);
            }
            target.setPosition(pos, d);
        }
    }

    public MixedTransform concatenate(Mixed t) {
        assert (this.numSourceDimensions == t.numTargetDimensions());
        MixedTransform result = new MixedTransform(t.numSourceDimensions(), this.numTargetDimensions);
        for (int d = 0; d < result.numTargetDimensions; ++d) {
            result.translation[d] = this.translation[d];
            if (this.zero[d]) {
                result.zero[d] = true;
                result.invert[d] = false;
                result.component[d] = 0;
                continue;
            }
            int c = this.component[d];
            long v = t.getTranslation(c);
            if (this.invert[d]) {
                int n = d;
                result.translation[n] = result.translation[n] - v;
            } else {
                int n = d;
                result.translation[n] = result.translation[n] + v;
            }
            if (t.getComponentZero(c)) {
                result.zero[d] = true;
                result.invert[d] = false;
                result.component[d] = 0;
                continue;
            }
            result.zero[d] = false;
            result.invert[d] = this.invert[d] != t.getComponentInversion(c);
            result.component[d] = t.getComponentMapping(c);
        }
        return result;
    }

    @Override
    public Class<Mixed> getConcatenableClass() {
        return Mixed.class;
    }

    public MixedTransform preConcatenate(Mixed t) {
        assert (t.numSourceDimensions() == this.numTargetDimensions);
        MixedTransform result = new MixedTransform(this.numSourceDimensions, t.numTargetDimensions());
        for (int d = 0; d < result.numTargetDimensions; ++d) {
            result.translation[d] = t.getTranslation(d);
            if (t.getComponentZero(d)) {
                result.zero[d] = true;
                result.invert[d] = false;
                result.component[d] = 0;
                continue;
            }
            int c = t.getComponentMapping(d);
            long v = this.translation[c];
            if (t.getComponentInversion(d)) {
                int n = d;
                result.translation[n] = result.translation[n] - v;
            } else {
                int n = d;
                result.translation[n] = result.translation[n] + v;
            }
            if (this.zero[c]) {
                result.zero[d] = true;
                result.invert[d] = false;
                result.component[d] = 0;
                continue;
            }
            result.zero[d] = false;
            result.invert[d] = t.getComponentInversion(d) != this.invert[c];
            result.component[d] = this.component[c];
        }
        return result;
    }

    @Override
    public Class<Mixed> getPreConcatenableClass() {
        return Mixed.class;
    }

    public void set(Mixed transform) {
        assert (this.numSourceDimensions == transform.numSourceDimensions());
        assert (this.numTargetDimensions == transform.numTargetDimensions());
        transform.getTranslation(this.translation);
        transform.getComponentZero(this.zero);
        transform.getComponentMapping(this.component);
        transform.getComponentInversion(this.invert);
    }

    @Override
    public double[][] getMatrix() {
        int d;
        double[][] mat = new double[this.numTargetDimensions + 1][this.numSourceDimensions + 1];
        mat[this.numTargetDimensions][this.numSourceDimensions] = 1.0;
        for (d = 0; d < this.numTargetDimensions; ++d) {
            mat[d][this.numSourceDimensions] = this.translation[d];
        }
        for (d = 0; d < this.numTargetDimensions; ++d) {
            if (this.zero[d]) continue;
            mat[d][this.component[d]] = this.invert[d] ? -1.0 : 1.0;
        }
        return mat;
    }

    public boolean hasFullSourceMapping() {
        int d;
        boolean[] sourceMapped = new boolean[this.numSourceDimensions];
        for (d = 0; d < this.numTargetDimensions; ++d) {
            if (this.zero[d]) continue;
            sourceMapped[this.component[d]] = true;
        }
        for (d = 0; d < this.numSourceDimensions; ++d) {
            if (sourceMapped[d]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MixedTransform{" + this.numSourceDimensions + "->" + this.numTargetDimensions + ", component=" + Arrays.toString(this.component) + ", invert=" + Arrays.toString(this.invert) + ", zero=" + Arrays.toString(this.zero) + ", translation=" + Arrays.toString(this.translation) + '}';
    }
}

