/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.access;

import java.util.Iterator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;

public class RowView<N extends Number>
implements Access1D<N>,
Iterator<RowView<N>> {
    private final Access2D<N> myDelegate2D;
    private final long myLastRow;
    private long myRow = -1L;
    final Iterable<RowView<N>> iterable = () -> this;

    public static <S extends Number> Iterable<RowView<S>> makeIterable(Access2D<S> access) {
        return new RowView<S>(access).iterable;
    }

    protected RowView(Access2D<N> access) {
        this(access, -1L);
    }

    RowView(Access2D<N> access, long row) {
        this.myDelegate2D = access;
        this.myLastRow = access.countRows() - 1L;
        this.myRow = row;
    }

    @Override
    public long count() {
        return this.myDelegate2D.countColumns();
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate2D.doubleValue(this.myRow, index);
    }

    @Override
    public N get(long index) {
        return this.myDelegate2D.get(this.myRow, index);
    }

    @Override
    public boolean hasNext() {
        return this.myRow < this.myLastRow;
    }

    public boolean hasPrevious() {
        return this.myRow > 0L;
    }

    @Override
    public RowView<N> next() {
        ++this.myRow;
        return this;
    }

    public RowView<N> previous() {
        --this.myRow;
        return this;
    }

    @Override
    public void remove() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    public long row() {
        return this.myRow;
    }

    protected void setRow(long row) {
        this.myRow = row;
    }
}

