/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;

public abstract class AggregatorSet<N extends Number> {
    protected AggregatorSet() {
    }

    public abstract AggregatorFunction<N> average();

    public abstract AggregatorFunction<N> cardinality();

    public final AggregatorFunction<N> get(Aggregator aggregator) {
        switch (aggregator) {
            case AVERAGE: {
                return this.average();
            }
            case CARDINALITY: {
                return this.cardinality();
            }
            case LARGEST: {
                return this.largest();
            }
            case MAXIMUM: {
                return this.maximum();
            }
            case MINIMUM: {
                return this.minimum();
            }
            case NORM1: {
                return this.norm1();
            }
            case NORM2: {
                return this.norm2();
            }
            case PRODUCT: {
                return this.product();
            }
            case PRODUCT2: {
                return this.product2();
            }
            case SMALLEST: {
                return this.smallest();
            }
            case SUM: {
                return this.sum();
            }
            case SUM2: {
                return this.sum2();
            }
        }
        return null;
    }

    public abstract AggregatorFunction<N> largest();

    public abstract AggregatorFunction<N> maximum();

    public abstract AggregatorFunction<N> minimum();

    public abstract AggregatorFunction<N> norm1();

    public abstract AggregatorFunction<N> norm2();

    public abstract AggregatorFunction<N> product();

    public abstract AggregatorFunction<N> product2();

    public abstract AggregatorFunction<N> smallest();

    public abstract AggregatorFunction<N> sum();

    public abstract AggregatorFunction<N> sum2();
}

