/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

final class ZeroStore<N extends Number>
extends FactoryStore<N> {
    private final N myNumberZero;
    private final Scalar<N> myScalarZero;

    ZeroStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myScalarZero = factory.scalar().zero();
        this.myNumberZero = this.myScalarZero.get();
    }

    @Override
    public MatrixStore<N> add(MatrixStore<N> addend) {
        return addend;
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new ZeroStore(this.physical(), this.getColDim(), this.getRowDim());
    }

    @Override
    public double doubleValue(long anInd) {
        return PrimitiveMath.ZERO;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        return this.getRowDim();
    }

    @Override
    public int firstInRow(int row) {
        return this.getColDim();
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.myNumberZero;
    }

    @Override
    public int limitOfColumn(int col) {
        return 0;
    }

    @Override
    public int limitOfRow(int row) {
        return 0;
    }

    @Override
    public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        target.reset();
    }

    @Override
    public ZeroStore<N> multiply(double scalar) {
        return new ZeroStore(this.physical(), this.getRowDim(), this.getColDim());
    }

    @Override
    public ZeroStore<N> multiply(MatrixStore<N> right) {
        return new ZeroStore(this.physical(), this.getRowDim(), (int)(right.count() / (long)this.getColDim()));
    }

    @Override
    public ZeroStore<N> multiply(N scalar) {
        return new ZeroStore(this.physical(), this.getRowDim(), this.getColDim());
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return this.physical().scalar().zero().get();
    }

    @Override
    public ZeroStore<N> premultiply(Access1D<N> left) {
        return new ZeroStore(this.physical(), (int)(left.count() / (long)this.getRowDim()), this.getColDim());
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        receiver.reset();
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.myScalarZero;
    }

    @Override
    public MatrixStore<N> transpose() {
        return new ZeroStore(this.physical(), this.getColDim(), this.getRowDim());
    }
}

