/*
 * Decompiled with CFR 0.152.
 */
package fiji.util.gui;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class GenericDialogPlus
extends GenericDialog {
    private static final long serialVersionUID = 1L;
    protected int[] windowIDs;
    protected String[] windowTitles;

    public GenericDialogPlus(String title) {
        super(title);
    }

    public GenericDialogPlus(String title, Frame parent) {
        super(title, parent);
    }

    public void addImageChoice(String label, String defaultImage) {
        if (this.windowTitles == null) {
            this.windowIDs = WindowManager.getIDList();
            if (this.windowIDs == null) {
                this.windowIDs = new int[0];
            }
            this.windowTitles = new String[this.windowIDs.length];
            for (int i = 0; i < this.windowIDs.length; ++i) {
                ImagePlus image = WindowManager.getImage((int)this.windowIDs[i]);
                this.windowTitles[i] = image == null ? "" : image.getTitle();
            }
        }
        this.addChoice(label, this.windowTitles, defaultImage);
    }

    public ImagePlus getNextImage() {
        return WindowManager.getImage((int)this.windowIDs[this.getNextChoiceIndex()]);
    }

    public void addStringField(String label, String defaultString, int columns) {
        super.addStringField(label, defaultString, columns);
        if (GenericDialogPlus.isHeadless()) {
            return;
        }
        TextField text = (TextField)this.stringField.lastElement();
        text.setDropTarget(null);
        new DropTarget(text, new TextDropTarget(text));
    }

    public void addDirectoryOrFileField(String label, String defaultPath) {
        this.addDirectoryOrFileField(label, defaultPath, 20);
    }

    public void addDirectoryOrFileField(String label, String defaultPath, int columns) {
        this.addStringField(label, defaultPath, columns);
        if (GenericDialogPlus.isHeadless()) {
            return;
        }
        TextField text = (TextField)this.stringField.lastElement();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = layout.getConstraints(text);
        Button button = new Button("Browse...");
        DirectoryListener listener = new DirectoryListener("Browse for " + label, text, 2);
        button.addActionListener(listener);
        button.addKeyListener((KeyListener)((Object)this));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(text);
        panel.add(button);
        layout.setConstraints(panel, constraints);
        this.add(panel);
    }

    public void addDirectoryField(String label, String defaultPath) {
        this.addDirectoryField(label, defaultPath, 20);
    }

    public void addDirectoryField(String label, String defaultPath, int columns) {
        this.addStringField(label, defaultPath, columns);
        if (GenericDialogPlus.isHeadless()) {
            return;
        }
        TextField text = (TextField)this.stringField.lastElement();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = layout.getConstraints(text);
        Button button = new Button("Browse...");
        DirectoryListener listener = new DirectoryListener("Browse for " + label, text);
        button.addActionListener(listener);
        button.addKeyListener((KeyListener)((Object)this));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(text);
        panel.add(button);
        layout.setConstraints(panel, constraints);
        this.add(panel);
    }

    public void addFileField(String label, String defaultPath) {
        this.addFileField(label, defaultPath, 20);
    }

    public void addFileField(String label, String defaultPath, int columns) {
        this.addStringField(label, defaultPath, columns);
        if (GenericDialogPlus.isHeadless()) {
            return;
        }
        TextField text = (TextField)this.stringField.lastElement();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = layout.getConstraints(text);
        Button button = new Button("Browse...");
        FileListener listener = new FileListener("Browse for " + label, text);
        button.addActionListener(listener);
        button.addKeyListener((KeyListener)((Object)this));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(text);
        panel.add(button);
        layout.setConstraints(panel, constraints);
        this.add(panel);
    }

    public void addButton(String label, ActionListener listener) {
        if (GenericDialogPlus.isHeadless()) {
            return;
        }
        Button button = new Button(label);
        button.addActionListener(listener);
        button.addKeyListener((KeyListener)((Object)this));
        this.addComponent(button);
    }

    public void addComponent(Component component) {
        if (GenericDialogPlus.isHeadless()) {
            return;
        }
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        layout.setConstraints(component, this.getConstraints());
        this.add(component);
    }

    public void addComponent(Component component, int fill, double weightx) {
        if (GenericDialogPlus.isHeadless()) {
            return;
        }
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints constraints = this.getConstraints();
        constraints.fill = fill;
        constraints.weightx = weightx;
        layout.setConstraints(component, constraints);
        this.add(component);
    }

    public boolean addImage(String path) {
        if (GenericDialogPlus.isHeadless()) {
            return true;
        }
        return this.addImage(((Object)((Object)this)).getClass().getResource(path));
    }

    public boolean addImage(URL imgURL) {
        if (GenericDialogPlus.isHeadless()) {
            return true;
        }
        ImageIcon image = GenericDialogPlus.createImageIcon(imgURL);
        if (image == null) {
            return false;
        }
        this.addImage(image);
        return true;
    }

    public JLabel addImage(ImageIcon image) {
        if (GenericDialogPlus.isHeadless()) {
            return null;
        }
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        JLabel label = new JLabel(image);
        label.setOpaque(true);
        panel.add(label);
        this.addPanel(panel);
        return label;
    }

    public static ImageIcon createImageIcon(URL imgURL) {
        if (GenericDialogPlus.isHeadless()) {
            return null;
        }
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    protected GridBagConstraints getConstraints() {
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        Panel panel = new Panel();
        this.addPanel(panel);
        GridBagConstraints constraints = layout.getConstraints(panel);
        this.remove(panel);
        return constraints;
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    static String stripSuffix(String s, String suffix) {
        return !s.endsWith(suffix) ? s : s.substring(0, s.length() - suffix.length());
    }

    static String getString(DropTargetDropEvent event) throws IOException, UnsupportedFlavorException {
        String text = null;
        DataFlavor fileList = DataFlavor.javaFileListFlavor;
        if (event.isDataFlavorSupported(fileList)) {
            event.acceptDrop(1);
            List list = (List)event.getTransferable().getTransferData(fileList);
            text = ((File)list.get(0)).getAbsolutePath();
        } else if (event.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            event.acceptDrop(1);
            text = (String)event.getTransferable().getTransferData(DataFlavor.stringFlavor);
            if (text.startsWith("file://")) {
                text = text.substring(7);
            }
            text = GenericDialogPlus.stripSuffix(GenericDialogPlus.stripSuffix(text, "\n"), "\r").replaceAll("%20", " ");
        } else {
            event.rejectDrop();
            return null;
        }
        event.dropComplete(text != null);
        return text;
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 27 || keyCode == 87 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            this.windowClosing(null);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    static class TextDropTarget
    extends DropTargetAdapter {
        TextField text;
        DataFlavor flavor = DataFlavor.stringFlavor;

        public TextDropTarget(TextField text) {
            this.text = text;
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                this.text.setText(GenericDialogPlus.getString(event));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class DirectoryListener
    implements ActionListener {
        String title;
        TextField text;
        int fileSelectionMode;

        public DirectoryListener(String title, TextField text) {
            this(title, text, 1);
        }

        public DirectoryListener(String title, TextField text, int fileSelectionMode) {
            this.title = title;
            this.text = text;
            this.fileSelectionMode = fileSelectionMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File directory;
            for (directory = new File(this.text.getText()); directory != null && !directory.exists(); directory = directory.getParentFile()) {
            }
            JFileChooser fc = new JFileChooser(directory);
            fc.setFileSelectionMode(this.fileSelectionMode);
            fc.showOpenDialog(null);
            File selFile = fc.getSelectedFile();
            if (selFile != null) {
                this.text.setText(selFile.getAbsolutePath());
            }
        }
    }

    static class FileListener
    implements ActionListener {
        String title;
        TextField text;

        public FileListener(String title, TextField text) {
            this.title = title;
            this.text = text;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String fileName = null;
            File dir = new File(this.text.getText());
            if (!dir.isDirectory()) {
                if (dir.exists()) {
                    fileName = dir.getName();
                }
                dir = dir.getParentFile();
            }
            while (dir != null && !dir.exists()) {
                dir = dir.getParentFile();
            }
            OpenDialog dialog = dir == null ? new OpenDialog(this.title, fileName) : new OpenDialog(this.title, dir.getAbsolutePath(), fileName);
            String directory = dialog.getDirectory();
            if (directory == null) {
                return;
            }
            fileName = dialog.getFileName();
            this.text.setText(directory + File.separator + fileName);
        }
    }
}

