/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector;

import net.imagej.ImageJ;
import net.imagej.display.ImageDisplay;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.gui.MainAppFrame;

@Plugin(type=DynamicCommand.class, menuPath="Plugins>Tracking>FilamentDetector")
public class FilamentDetectorPlugin
implements Command {
    @Parameter
    private ImageJ ij;
    @Parameter
    private LogService log;
    @Parameter(type=ItemIO.INPUT)
    private ImageDisplay imd;
    public static final String PLUGIN_NAME = "FilamentDetector";
    public static final String VERSION = FilamentDetectorPlugin.version();

    private static String version() {
        String version = null;
        Package pack = FilamentDetectorPlugin.class.getPackage();
        if (pack != null) {
            version = pack.getImplementationVersion();
        }
        return version == null ? "DEVELOPMENT" : version;
    }

    public void run() {
        this.log.info((Object)("Running FilamentDetector version " + VERSION));
        try {
            FilamentWorkflow filamentDetector = new FilamentWorkflow(this.ij.context(), this.imd);
            MainAppFrame app = new MainAppFrame(this.ij, filamentDetector);
            app.setTitle("FilamentDetector version " + VERSION);
            app.initialize();
        }
        catch (Exception e) {
            this.ij.ui().showDialog("Error during initialization", e.getMessage(), DialogPrompt.MessageType.ERROR_MESSAGE);
            this.log.error((Object)"Error during initialization");
            e.printStackTrace();
        }
    }
}

