/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Enumeration;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.FogRetained;
import org.scijava.java3d.Group;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Leaf;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeReferenceTable;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.vecmath.Color3f;

public abstract class Fog
extends Leaf {
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 12;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 13;
    public static final int ALLOW_COLOR_READ = 14;
    public static final int ALLOW_COLOR_WRITE = 15;
    public static final int ALLOW_SCOPE_READ = 18;
    public static final int ALLOW_SCOPE_WRITE = 19;
    private static final int[] readCapabilities = new int[]{12, 14, 18};

    public Fog() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Fog(Color3f color) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((FogRetained)this.retained).initColor(color);
    }

    public Fog(float r, float g, float b) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((FogRetained)this.retained).initColor(r, g, b);
    }

    public void setColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog0"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setColor(color);
        } else {
            ((FogRetained)this.retained).initColor(color);
        }
    }

    public void setColor(float r, float g, float b) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog0"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setColor(r, g, b);
        } else {
            ((FogRetained)this.retained).initColor(r, g, b);
        }
    }

    public void getColor(Color3f color) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog2"));
        }
        ((FogRetained)this.retained).getColor(color);
    }

    public void setInfluencingBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog3"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setInfluencingBounds(region);
        } else {
            ((FogRetained)this.retained).initInfluencingBounds(region);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog4"));
        }
        return ((FogRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog3"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setInfluencingBoundingLeaf(region);
        } else {
            ((FogRetained)this.retained).initInfluencingBoundingLeaf(region);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog4"));
        }
        return ((FogRetained)this.retained).getInfluencingBoundingLeaf();
    }

    public void setScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog7"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).setScope(scope, index);
        } else {
            ((FogRetained)this.retained).initScope(scope, index);
        }
    }

    public Group getScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog8"));
        }
        return ((FogRetained)this.retained).getScope(index);
    }

    public void insertScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog9"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).insertScope(scope, index);
        } else {
            ((FogRetained)this.retained).initInsertScope(scope, index);
        }
    }

    public void removeScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog10"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).removeScope(index);
        } else {
            ((FogRetained)this.retained).initRemoveScope(index);
        }
    }

    public Enumeration<Group> getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog11"));
        }
        return ((FogRetained)this.retained).getAllScopes();
    }

    public void addScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog12"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).addScope(scope);
        } else {
            ((FogRetained)this.retained).initAddScope(scope);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog11"));
        }
        return ((FogRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog8"));
        }
        return ((FogRetained)this.retained).indexOfScope(scope);
    }

    public void removeScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog10"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).removeScope(scope);
        } else {
            ((FogRetained)this.retained).initRemoveScope(scope);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Fog10"));
        }
        if (this.isLive()) {
            ((FogRetained)this.retained).removeAllScopes();
        } else {
            ((FogRetained)this.retained).initRemoveAllScopes();
        }
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        FogRetained attr = (FogRetained)originalNode.retained;
        FogRetained rt = (FogRetained)this.retained;
        Color3f c = new Color3f();
        attr.getColor(c);
        rt.initColor(c);
        rt.initInfluencingBounds(attr.getInfluencingBounds());
        Enumeration<Group> elm = attr.getAllScopes();
        while (elm.hasMoreElements()) {
            rt.initAddScope(elm.nextElement());
        }
        rt.initInfluencingBoundingLeaf(attr.getInfluencingBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        FogRetained rt = (FogRetained)this.retained;
        BoundingLeaf bl = rt.getInfluencingBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.initInfluencingBoundingLeaf((BoundingLeaf)o);
        }
        int num = rt.numScopes();
        for (int i = 0; i < num; ++i) {
            rt.initScope((Group)referenceTable.getNewObjectReference(rt.getScope(i)), i);
        }
    }
}

